/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.registry;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.RegistryObject;

public enum DragonType {
    LIGHTNING("lightning", Raevyx.class, ModEntities.RAEVYX);

    private final String name;
    private final Class<? extends DragonEntity> entityClass;
    private final RegistryObject<? extends EntityType<? extends DragonEntity>> entityType;

    private DragonType(String name, Class<? extends DragonEntity> entityClass, RegistryObject<? extends EntityType<? extends DragonEntity>> entityType) {
        this.name = name;
        this.entityClass = entityClass;
        this.entityType = entityType;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends DragonEntity> getEntityClass() {
        return this.entityClass;
    }

    public RegistryObject<? extends EntityType<? extends DragonEntity>> getEntityType() {
        return this.entityType;
    }

    public EntityType<? extends DragonEntity> getEntityTypeValue() {
        return (EntityType)this.entityType.get();
    }

    public boolean isInstance(DragonEntity entity) {
        return this.entityClass.isInstance((Object)entity);
    }

    public static DragonType fromEntityClass(Class<? extends DragonEntity> entityClass) {
        for (DragonType type : DragonType.values()) {
            if (!type.entityClass.equals(entityClass)) continue;
            return type;
        }
        return null;
    }

    public static DragonType fromEntity(DragonEntity entity) {
        return DragonType.fromEntityClass(((Object)((Object)entity)).getClass());
    }
}

