/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.base;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonCombatCapable;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public abstract class DragonMeleeAttackGoalBase
extends Goal {
    protected final DragonEntity dragon;
    protected final DragonCombatCapable combatCapable;
    protected double attackRange = 2.0;
    protected double directChaseRange = 10.0;
    protected int pathCooldown = 15;
    protected int attackCooldown = 20;
    private int pathCommitmentTicks = 0;
    private int lastPathTime = 0;
    private int attackTimer = 0;

    public DragonMeleeAttackGoalBase(DragonEntity dragon) {
        this.dragon = dragon;
        this.combatCapable = (DragonCombatCapable)((Object)dragon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.dragon.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return this.combatCapable.canMeleeAttack() && this.dragon.m_20280_((Entity)target) <= this.attackRange * this.attackRange;
    }

    public boolean m_8045_() {
        LivingEntity target = this.dragon.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return this.combatCapable.canMeleeAttack() && this.dragon.m_20280_((Entity)target) <= this.attackRange * this.attackRange * 4.0;
    }

    public void m_8056_() {
        this.pathCommitmentTicks = 0;
        this.lastPathTime = this.dragon.f_19797_;
        this.attackTimer = 0;
    }

    public void m_8041_() {
        this.pathCommitmentTicks = 0;
        this.combatCapable.setAttacking(false);
    }

    public void m_8037_() {
        LivingEntity target = this.dragon.m_5448_();
        if (target == null) {
            return;
        }
        ++this.attackTimer;
        this.handlePathfinding(target);
        this.handleAttack(target);
    }

    protected void handlePathfinding(LivingEntity target) {
        Path path;
        PathNavigation navigation = this.dragon.m_21573_();
        double distSqr = this.dragon.m_20280_((Entity)target);
        if (distSqr <= this.directChaseRange * this.directChaseRange) {
            this.dragon.m_21566_().m_6849_(target.m_20185_(), target.m_20186_(), target.m_20189_(), 1.0);
            this.dragon.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            return;
        }
        boolean needsNewPath = this.dragon.f_19797_ - this.lastPathTime >= this.pathCooldown;
        boolean pathDone = navigation.m_26571_();
        if ((needsNewPath || pathDone && this.pathCommitmentTicks > 20) && (path = navigation.m_6570_((Entity)target, 0)) != null) {
            navigation.m_26536_(path, 1.0);
            this.lastPathTime = this.dragon.f_19797_;
            this.pathCommitmentTicks = 0;
        }
        if (!pathDone) {
            ++this.pathCommitmentTicks;
        }
    }

    protected void handleAttack(LivingEntity target) {
        double distSqr = this.dragon.m_20280_((Entity)target);
        if (distSqr <= this.attackRange * this.attackRange && this.attackTimer >= this.attackCooldown) {
            this.combatCapable.performMeleeAttack(target);
            this.attackTimer = 0;
            this.combatCapable.setAttacking(true);
            this.onAttackPerformed(target);
        }
    }

    protected abstract void onAttackPerformed(LivingEntity var1);

    protected void configureCombatParameters() {
        this.attackRange = this.combatCapable.getMeleeRange();
        this.attackCooldown = this.combatCapable.getAttackCooldown();
    }
}

