/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class CindervaneSleepGoal
extends Goal {
    private final Cindervane dragon;
    private int retryCooldown;

    public CindervaneSleepGoal(Cindervane dragon) {
        this.dragon = dragon;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.dragon.isSleepLocked()) {
            return false;
        }
        if (!this.dragon.canSleepNow() || this.dragon.isSleepSuppressed()) {
            return false;
        }
        if (this.dragon.m_20072_() || this.dragon.m_20077_()) {
            return false;
        }
        if (this.dragon.isDying() || this.dragon.m_20160_() || this.dragon.m_5448_() != null || this.dragon.m_5912_()) {
            return false;
        }
        if (this.dragon.m_9236_().m_46470_()) {
            return false;
        }
        return this.dragon.m_21824_() && this.ownerAsleep();
    }

    public boolean m_8045_() {
        return this.dragon.isSleepLocked();
    }

    public void m_8056_() {
        this.dragon.startSleepEnter();
    }

    public void m_8037_() {
        if (this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (this.dragon.isSleepLocked() && !this.shouldRemainAsleep() && !this.dragon.isSleepTransitioning()) {
            this.dragon.startSleepExit();
        }
    }

    public void m_8041_() {
        if (!this.dragon.isSleepLocked()) {
            this.retryCooldown = 100;
        }
    }

    public boolean m_6767_() {
        return false;
    }

    private boolean ownerAsleep() {
        LivingEntity owner = this.dragon.m_269323_();
        if (!(owner instanceof Player)) {
            return false;
        }
        Player player = (Player)owner;
        if (!player.m_5803_() || !player.m_6084_()) {
            return false;
        }
        return player.m_9236_() == this.dragon.m_9236_();
    }

    private boolean shouldRemainAsleep() {
        if (this.dragon.m_21824_()) {
            return this.ownerAsleep();
        }
        return false;
    }
}

