/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class NulljawMoveGoal
extends Goal {
    private final Nulljaw drake;
    private final boolean followWhenUnseen;
    private final double moveSpeed;
    private int pathDelay;

    public NulljawMoveGoal(Nulljaw drake, boolean followWhenUnseen, double moveSpeed) {
        this.drake = drake;
        this.followWhenUnseen = followWhenUnseen;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.drake.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return !this.isPerformingAttack();
    }

    public void m_8056_() {
        this.pathDelay = 0;
        this.drake.m_21561_(true);
        this.drake.setAccelerating(true);
    }

    public void m_8041_() {
        this.drake.m_21573_().m_26573_();
        LivingEntity target = this.drake.m_5448_();
        if (!EntitySelector.f_20406_.test(target)) {
            this.drake.m_6710_(null);
        }
        this.drake.m_21561_(false);
        this.drake.setAccelerating(false);
    }

    public boolean m_8045_() {
        Player player;
        LivingEntity target = this.drake.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (this.isPerformingAttack()) {
            return false;
        }
        if (!this.followWhenUnseen && this.drake.m_21573_().m_26571_()) {
            return false;
        }
        if (!this.drake.m_21444_(target.m_20183_())) {
            return false;
        }
        return !(target instanceof Player) || !(player = (Player)target).m_7500_() && !player.m_5833_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.drake.m_5448_();
        if (target == null || this.isPerformingAttack()) {
            return;
        }
        this.drake.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (--this.pathDelay <= 0) {
            double distance = Math.sqrt(this.drake.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()));
            this.pathDelay = Mth.m_14045_((int)((int)(distance * 0.45)), (int)4, (int)12);
            boolean moved = this.drake.m_21573_().m_5624_((Entity)target, this.moveSpeed);
            if (!moved) {
                this.pathDelay += 5;
            }
        }
    }

    private boolean isPerformingAttack() {
        return this.drake.getActiveAbility() != null || this.drake.combatManager.isAbilityActive(NulljawAbilities.NULLJAW_CLAW);
    }
}

