/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxCombatGoal
extends Goal {
    protected final Raevyx wyvern;
    private final double attackRange = 4.0;

    public RaevyxCombatGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        boolean hasTarget;
        LivingEntity target = this.wyvern.m_5448_();
        boolean bl = hasTarget = target != null && target.m_6084_();
        if (this.wyvern.isInAttackState() || !this.wyvern.canAttack()) {
            return false;
        }
        if (!hasTarget) {
            return false;
        }
        double distanceSq = this.wyvern.m_20280_((Entity)target);
        return !(distanceSq > this.getAttackReachSqr(target)) && this.wyvern.m_21574_().m_148306_((Entity)target);
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8056_() {
        LivingEntity target = this.wyvern.m_5448_();
        if (target == null) {
            return;
        }
        this.chooseAttack(target);
    }

    public void m_8041_() {
    }

    public void m_8037_() {
    }

    private void chooseAttack(LivingEntity target) {
        double gap = this.getGapToTarget(target);
        if (gap <= 3.0) {
            this.wyvern.setAttackState(3);
            this.wyvern.attackCooldown = 3;
        } else if (gap <= 5.0) {
            this.wyvern.setAttackState(1);
            this.wyvern.attackCooldown = 3;
        }
    }

    private double getAttackReachSqr(LivingEntity target) {
        double combinedRadii = (double)(this.wyvern.m_20205_() + target.m_20205_()) * 0.5;
        double reach = this.attackRange + combinedRadii;
        return reach * reach;
    }

    private double getGapToTarget(LivingEntity target) {
        double centerDistance = this.wyvern.m_20270_((Entity)target);
        double combinedRadii = (double)(this.wyvern.m_20205_() + target.m_20205_()) * 0.5;
        return Math.max(0.0, centerDistance - combinedRadii);
    }
}

