/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxStateGoal
extends Goal {
    protected final Raevyx wyvern;
    private final int getAttackState;
    private final int attackState;
    protected final int attackEndState;
    private final int attackFinalTick;
    protected final int attackSeeTick;

    public RaevyxStateGoal(Raevyx wyvern, int getAttackState, int attackState, int attackEndState, int attackFinalTick, int attackSeeTick) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
        this.getAttackState = getAttackState;
        this.attackState = attackState;
        this.attackEndState = attackEndState;
        this.attackFinalTick = attackFinalTick;
        this.attackSeeTick = attackSeeTick;
    }

    public RaevyxStateGoal(Raevyx wyvern, int getAttackState, int attackState, int attackEndState, int attackFinalTick, int attackSeeTick, boolean interruptsAI) {
        this.wyvern = wyvern;
        this.m_7021_(interruptsAI ? EnumSet.of(Goal.Flag.LOOK) : EnumSet.noneOf(Goal.Flag.class));
        this.getAttackState = getAttackState;
        this.attackState = attackState;
        this.attackEndState = attackEndState;
        this.attackFinalTick = attackFinalTick;
        this.attackSeeTick = attackSeeTick;
    }

    public RaevyxStateGoal(Raevyx wyvern, int getAttackState, int attackState, int attackEndState, int attackFinalTick, int attackSeeTick, EnumSet<Goal.Flag> interruptFlagTypes) {
        this.wyvern = wyvern;
        this.m_7021_(interruptFlagTypes.isEmpty() ? EnumSet.noneOf(Goal.Flag.class) : interruptFlagTypes);
        this.getAttackState = getAttackState;
        this.attackState = attackState;
        this.attackEndState = attackEndState;
        this.attackFinalTick = attackFinalTick;
        this.attackSeeTick = attackSeeTick;
    }

    public boolean m_8036_() {
        return this.wyvern.getAttackState() == this.getAttackState;
    }

    public void m_8056_() {
        if (this.getAttackState != this.attackState) {
            this.wyvern.setAttackState(this.attackState);
        }
    }

    public void m_8041_() {
        this.wyvern.setAttackState(this.attackEndState);
    }

    public boolean m_8045_() {
        return this.attackFinalTick > 0 ? this.wyvern.attackTicks <= this.attackFinalTick && this.wyvern.getAttackState() == this.attackState : this.m_8036_();
    }

    public void m_8037_() {
        LivingEntity target = this.wyvern.m_5448_();
        if (this.wyvern.attackTicks < this.attackSeeTick && target != null) {
            this.wyvern.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            this.wyvern.m_21391_((Entity)target, 30.0f, 30.0f);
        } else {
            this.wyvern.m_146922_(this.wyvern.f_19859_);
        }
        this.handleStateTransition();
    }

    public boolean m_183429_() {
        return true;
    }

    private void handleStateTransition() {
        switch (this.attackState) {
            case 1: {
                if (this.wyvern.attackTicks < 3) break;
                this.wyvern.setAttackState(2);
                break;
            }
            case 2: {
                if (this.wyvern.attackTicks < 3) break;
                this.wyvern.tryActivateAbility(RaevyxAbilities.RAEVYX_HORN_GORE);
                this.wyvern.setAttackState(5);
                this.wyvern.attackCooldown = 1;
                break;
            }
            case 3: {
                if (this.wyvern.attackTicks < 3) break;
                this.wyvern.setAttackState(4);
                break;
            }
            case 4: {
                if (this.wyvern.attackTicks < 3) break;
                this.wyvern.tryActivateAbility(RaevyxAbilities.RAEVYX_BITE);
                this.wyvern.setAttackState(5);
                this.wyvern.attackCooldown = 1;
                break;
            }
            case 5: {
                if (this.wyvern.attackTicks < 3) break;
                this.wyvern.setAttackState(0);
            }
        }
    }
}

