/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class StegonautLeaveWaterGoal
extends Goal {
    private static final int NEARBY_SEARCH_RADIUS = 6;
    private static final int RANDOM_SEARCH_ATTEMPTS = 12;
    private static final int PATH_RECHECK_DELAY = 20;
    private final Stegonaut drake;
    private final double moveSpeed;
    private Vec3 targetPosition;
    private int pathCooldown;
    private boolean forcedStandDuringEscape;

    public StegonautLeaveWaterGoal(Stegonaut drake, double moveSpeed) {
        this.drake = drake;
        this.moveSpeed = moveSpeed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (!this.drake.m_20072_()) {
            return false;
        }
        this.targetPosition = this.findDryLand();
        return this.targetPosition != null;
    }

    public boolean m_8045_() {
        if (!this.drake.m_20072_()) {
            return false;
        }
        if (this.targetPosition == null) {
            return false;
        }
        return !this.drake.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.pathCooldown = 0;
        this.forcedStandDuringEscape = false;
        if (this.drake.isPlayingDead()) {
            this.drake.clearPlayDeadGoal();
        }
        if (this.drake.m_21827_()) {
            this.forcedStandDuringEscape = true;
            this.drake.m_21839_(false);
        }
        this.moveToTarget();
    }

    public void m_8041_() {
        this.drake.m_21573_().m_26573_();
        this.targetPosition = null;
        if (this.forcedStandDuringEscape) {
            this.drake.refreshCommandState();
        }
    }

    public void m_8037_() {
        if (this.targetPosition == null) {
            return;
        }
        this.drake.m_21563_().m_24950_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, 45.0f, 45.0f);
        if (--this.pathCooldown <= 0) {
            if (!this.drake.m_21573_().m_26519_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, this.moveSpeed)) {
                this.targetPosition = this.findDryLand();
                if (this.targetPosition != null) {
                    this.drake.m_21573_().m_26519_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, this.moveSpeed);
                }
            }
            this.pathCooldown = 20;
        }
        if (this.drake.f_19862_ && this.drake.m_20069_()) {
            this.drake.m_20256_(this.drake.m_20184_().m_82520_(0.0, 0.08, 0.0));
        }
    }

    private void moveToTarget() {
        if (this.targetPosition != null) {
            this.drake.m_21573_().m_26519_(this.targetPosition.f_82479_, this.targetPosition.f_82480_, this.targetPosition.f_82481_, this.moveSpeed);
        }
    }

    private Vec3 findDryLand() {
        Vec3 nearby = this.searchNearbyDryLand();
        if (nearby != null) {
            return nearby;
        }
        return this.findRandomDryLand();
    }

    private Vec3 searchNearbyDryLand() {
        Level level = this.drake.m_9236_();
        BlockPos origin = this.drake.m_20183_();
        Vec3 originCenter = Vec3.m_82512_((Vec3i)origin);
        BlockPos bestCandidate = null;
        double bestDistance = Double.MAX_VALUE;
        for (int radius = 1; radius <= 6; ++radius) {
            int horizontalRadius = radius;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)origin.m_7918_(-horizontalRadius, -1, -horizontalRadius), (BlockPos)origin.m_7918_(horizontalRadius, 2, horizontalRadius))) {
                double distance;
                int dx = Math.abs(pos.m_123341_() - origin.m_123341_());
                int dz = Math.abs(pos.m_123343_() - origin.m_123343_());
                if (dx > radius || dz > radius || !this.isDryDestination(level, pos) || !((distance = pos.m_203198_(originCenter.f_82479_, originCenter.f_82480_, originCenter.f_82481_)) < bestDistance)) continue;
                bestDistance = distance;
                bestCandidate = pos.m_7949_();
            }
            if (bestCandidate == null) continue;
            return Vec3.m_82539_(bestCandidate);
        }
        return null;
    }

    private Vec3 findRandomDryLand() {
        Level level = this.drake.m_9236_();
        Vec3 candidate = null;
        for (int attempts = 0; attempts < 12; ++attempts) {
            BlockPos blockPos;
            candidate = LandRandomPos.m_148488_((PathfinderMob)this.drake, (int)24, (int)7);
            if (candidate == null || !this.isDryDestination(level, blockPos = BlockPos.m_274446_((Position)candidate))) continue;
            return Vec3.m_82539_((Vec3i)blockPos);
        }
        BlockPos columnExit = this.climbColumnToFindAir();
        return columnExit != null ? Vec3.m_82539_((Vec3i)columnExit) : null;
    }

    private BlockPos climbColumnToFindAir() {
        Level level = this.drake.m_9236_();
        BlockPos.MutableBlockPos cursor = this.drake.m_20183_().m_122032_();
        while (level.m_6425_((BlockPos)cursor).m_205070_(FluidTags.f_13131_) && cursor.m_123342_() < level.m_151558_()) {
            cursor.m_122173_(Direction.UP);
        }
        if (level.m_6425_((BlockPos)cursor).m_205070_(FluidTags.f_13131_)) {
            return null;
        }
        if (!this.isDryDestination(level, (BlockPos)cursor)) {
            cursor.m_122173_(Direction.UP);
            if (!this.isDryDestination(level, (BlockPos)cursor)) {
                return null;
            }
        }
        return cursor.m_7949_();
    }

    private boolean isDryDestination(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        if (!level.m_46859_(pos)) {
            return false;
        }
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        BlockState belowState = level.m_8055_(below);
        if (!level.m_6425_(below).m_76178_()) {
            return false;
        }
        if (!belowState.m_60783_((BlockGetter)level, below, Direction.UP)) {
            return false;
        }
        BlockPos above = pos.m_7494_();
        if (!(level.m_46749_(above) && level.m_46859_(above) && level.m_6425_(above).m_76178_())) {
            return false;
        }
        BlockPos twoAbove = above.m_7494_();
        if (!level.m_46749_(twoAbove)) {
            return true;
        }
        return level.m_46859_(twoAbove) && level.m_6425_(twoAbove).m_76178_();
    }
}

