/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.ai.navigation.DragonAmphibiousNodeEvaluator;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DragonAmphibiousNavigation
extends AmphibiousPathNavigation {
    private static final double MIN_PROGRESS_SQR = 0.12249999999999998;
    private static final int PROGRESS_TICKS = 20;
    private Vec3 lastProgressSample = Vec3.f_82478_;
    private int lastProgressTick;
    private int stalledRepaths;

    public DragonAmphibiousNavigation(Mob mob, Level level) {
        super(mob, level);
        this.m_7008_(true);
        this.lastProgressSample = this.m_7475_();
        this.lastProgressTick = this.f_26494_.f_19797_;
    }

    @NotNull
    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new DragonAmphibiousNodeEvaluator();
        return new PathFinder(this.f_26508_, maxVisitedNodes);
    }

    public boolean m_6342_(@NotNull BlockPos pos) {
        if (!this.f_26495_.m_6425_(pos).m_76178_()) {
            return true;
        }
        BlockState state = this.f_26495_.m_8055_(pos);
        if (state.m_60795_()) {
            BlockState below = this.f_26495_.m_8055_(pos.m_7495_());
            return !below.m_60795_() || !below.m_60819_().m_76178_();
        }
        return super.m_6342_(pos);
    }

    protected void m_7636_() {
        Path currentPath = this.f_26496_;
        if (currentPath == null || currentPath.m_77392_()) {
            return;
        }
        Vec3 entityPos = this.m_7475_();
        this.tryAdvanceSameY(currentPath, entityPos);
        this.tryShortcut(currentPath, entityPos);
        if (currentPath.m_77392_()) {
            return;
        }
        Vec3 target = currentPath.m_77380_((Entity)this.f_26494_);
        if (target == null) {
            return;
        }
        float reach = Math.max(0.8f, this.f_26494_.m_20205_() * 0.5f);
        if (entityPos.m_82557_(target) < (double)(reach * reach)) {
            currentPath.m_77374_();
            if (currentPath.m_77392_()) {
                return;
            }
            target = currentPath.m_77380_((Entity)this.f_26494_);
            if (target == null) {
                return;
            }
        }
        this.f_26494_.m_21566_().m_6849_(target.f_82479_, target.f_82480_, target.f_82481_, this.f_26497_);
        this.monitorProgress(entityPos, target);
    }

    private void tryAdvanceSameY(Path path, Vec3 entityPos) {
        int next = path.m_77399_();
        int limit = path.m_77398_();
        double yFloor = Math.floor(entityPos.f_82480_);
        for (int lastSameY = next; lastSameY < limit && (double)path.m_77375_((int)lastSameY).f_77272_ == yFloor; ++lastSameY) {
        }
        for (int i = lastSameY - 1; i > next; --i) {
            Vec3 candidate = path.m_77382_((Entity)this.f_26494_, i);
            if (!this.hasLineOfSight(entityPos, candidate)) continue;
            path.m_77393_(i);
            return;
        }
    }

    private void tryShortcut(Path path, Vec3 entityPos) {
        int max;
        int next = path.m_77399_();
        for (int i = max = Math.min(next + 6, path.m_77398_() - 1); i > next; --i) {
            Vec3 candidate = path.m_77382_((Entity)this.f_26494_, i);
            if (!(candidate.m_82557_(entityPos) <= 16.0) || !this.hasLineOfSight(entityPos, candidate)) continue;
            path.m_77393_(i);
            return;
        }
    }

    private void monitorProgress(Vec3 entityPos, Vec3 target) {
        if (this.f_26494_.f_19797_ - this.lastProgressTick < 20) {
            return;
        }
        if (entityPos.m_82557_(this.lastProgressSample) < 0.12249999999999998) {
            this.m_26569_();
            ++this.stalledRepaths;
            if (this.stalledRepaths >= 2) {
                this.nudgeSideways(entityPos, target);
                this.stalledRepaths = 0;
            }
        } else {
            this.stalledRepaths = 0;
        }
        this.lastProgressSample = entityPos;
        this.lastProgressTick = this.f_26494_.f_19797_;
    }

    private void nudgeSideways(Vec3 current, Vec3 target) {
        Vec3 direction = target.m_82546_(current);
        if (direction.m_82556_() <= 1.0E-4) {
            return;
        }
        Vec3 flatDir = new Vec3(direction.f_82479_, 0.0, direction.f_82481_);
        if (flatDir.m_82556_() <= 1.0E-4) {
            return;
        }
        Vec3 perpendicular = new Vec3(-flatDir.f_82481_, 0.0, flatDir.f_82479_).m_82541_();
        double offset = Math.max(1.5, (double)this.f_26494_.m_20205_());
        double side = this.f_26494_.m_217043_().m_188499_() ? offset : -offset;
        BlockPos sidePos = BlockPos.m_274561_((double)(current.f_82479_ + perpendicular.f_82479_ * side), (double)current.f_82480_, (double)(current.f_82481_ + perpendicular.f_82481_ * side));
        if (this.m_6342_(sidePos)) {
            this.m_26519_((double)sidePos.m_123341_() + 0.5, sidePos.m_123342_(), (double)sidePos.m_123343_() + 0.5, Math.max(1.0, this.f_26497_));
        }
    }

    private boolean hasLineOfSight(Vec3 from, Vec3 to) {
        if (this.f_26508_ == null) {
            return false;
        }
        Vec3 delta = to.m_82546_(from);
        double maxT = delta.m_82553_();
        if (maxT < 1.0E-6) {
            return true;
        }
        double dx = delta.f_82479_ / maxT;
        double dy = delta.f_82480_ / maxT;
        double dz = delta.f_82481_ / maxT;
        int currentX = Mth.m_14107_((double)from.f_82479_);
        int currentY = Mth.m_14107_((double)from.f_82480_);
        int currentZ = Mth.m_14107_((double)from.f_82481_);
        double nextX = this.computeNextBoundary(from.f_82479_, dx);
        double nextY = this.computeNextBoundary(from.f_82480_, dy);
        double nextZ = this.computeNextBoundary(from.f_82481_, dz);
        double deltaX = dx == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dx);
        double deltaY = dy == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dy);
        double deltaZ = dz == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(dz);
        double t = 0.0;
        while (t <= maxT) {
            BlockPathTypes type = this.f_26508_.m_7209_((BlockGetter)this.f_26495_, currentX, currentY, currentZ, this.f_26494_);
            float malus = this.f_26494_.m_21439_(type);
            if (malus < 0.0f || malus >= 8.0f || type == BlockPathTypes.DAMAGE_FIRE || type == BlockPathTypes.DAMAGE_OTHER) {
                return false;
            }
            if (nextX < nextY) {
                if (nextX < nextZ) {
                    currentX += dx > 0.0 ? 1 : -1;
                    t = nextX;
                    nextX += deltaX;
                    continue;
                }
                currentZ += dz > 0.0 ? 1 : -1;
                t = nextZ;
                nextZ += deltaZ;
                continue;
            }
            if (nextY < nextZ) {
                currentY += dy > 0.0 ? 1 : -1;
                t = nextY;
                nextY += deltaY;
                continue;
            }
            currentZ += dz > 0.0 ? 1 : -1;
            t = nextZ;
            nextZ += deltaZ;
        }
        return true;
    }

    private double computeNextBoundary(double start, double direction) {
        if (direction == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double boundary = direction > 0.0 ? (double)(Mth.m_14107_((double)start) + 1) : (double)Mth.m_14107_((double)start);
        return (boundary - start) / direction;
    }

    public void m_26573_() {
        super.m_26573_();
        this.stalledRepaths = 0;
        this.lastProgressSample = this.m_7475_();
        this.lastProgressTick = this.f_26494_.f_19797_;
    }
}

