/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.stegonaut;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StegonautPassiveBuffAbility {
    private static final double BUFF_RANGE = 8.0;
    private static final int UPDATE_INTERVAL = 20;
    private static final int BUFF_DURATION_TICKS = 40;
    private static final int RESISTANCE_AMPLIFIER = 0;
    private static final int ABSORPTION_AMPLIFIER = 0;
    private final Stegonaut drake;
    private final Level level;
    private int tickCounter = 0;
    private Set<UUID> buffedEntityIds = new HashSet<UUID>();

    public StegonautPassiveBuffAbility(Stegonaut drake) {
        this.drake = drake;
        this.level = drake.m_9236_();
    }

    public void tick() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (++this.tickCounter < 20) {
            return;
        }
        this.tickCounter = 0;
        if (!this.drake.m_6084_() || this.drake.isPlayingDead()) {
            this.clearTrackedBuffs(serverLevel);
            return;
        }
        this.applyBuffs(serverLevel);
    }

    private void applyBuffs(ServerLevel serverLevel) {
        List nearbyEntities = serverLevel.m_6443_(LivingEntity.class, this.drake.m_20191_().m_82400_(8.0), this::isEligibleForBuff);
        HashSet<UUID> currentNearby = new HashSet<UUID>();
        for (LivingEntity entity : nearbyEntities) {
            this.applyResistance(entity);
            this.applyAbsorption(entity);
            currentNearby.add(entity.m_20148_());
        }
        if (!this.buffedEntityIds.isEmpty()) {
            for (UUID uuid : new HashSet<UUID>(this.buffedEntityIds)) {
                Entity entity;
                if (currentNearby.contains(uuid) || !((entity = serverLevel.m_8791_(uuid)) instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_21195_(MobEffects.f_19606_);
                livingEntity.m_21195_(MobEffects.f_19617_);
            }
        }
        this.buffedEntityIds = currentNearby;
    }

    private boolean isEligibleForBuff(LivingEntity entity) {
        OwnableEntity ownable;
        LivingEntity owner;
        if (entity == this.drake || !entity.m_6084_()) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return this.isPlayerEligible(player);
        }
        if (entity instanceof DragonEntity) {
            DragonEntity dragon = (DragonEntity)entity;
            return this.isDragonEligible(dragon);
        }
        if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            Player ownerPlayer = (Player)owner;
            if (!this.drake.m_21824_()) {
                return false;
            }
            LivingEntity drakeOwner = this.drake.m_269323_();
            if (drakeOwner instanceof Player) {
                Player drakeOwnerPlayer = (Player)drakeOwner;
                if (drakeOwnerPlayer.m_20148_().equals(ownerPlayer.m_20148_())) {
                    return true;
                }
                return this.drake.allyManager.isAlly(ownerPlayer);
            }
        }
        return false;
    }

    private boolean isPlayerEligible(Player player) {
        if (!this.drake.m_21824_()) {
            return false;
        }
        LivingEntity owner = this.drake.m_269323_();
        if (!(owner instanceof Player)) {
            return false;
        }
        Player ownerPlayer = (Player)owner;
        if (ownerPlayer.m_20148_().equals(player.m_20148_())) {
            return true;
        }
        return this.drake.allyManager.isAlly(player);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isDragonEligible(DragonEntity dragon) {
        if (!this.drake.m_21824_()) {
            return false;
        }
        LivingEntity owner = this.drake.m_269323_();
        if (!(owner instanceof Player)) return false;
        Player ownerPlayer = (Player)owner;
        if (dragon.m_21830_((LivingEntity)ownerPlayer)) {
            return true;
        }
        if (!(dragon instanceof Stegonaut)) return false;
        Stegonaut alliedDrake = (Stegonaut)dragon;
        if (!alliedDrake.allyManager.isAlly(ownerPlayer)) return false;
        return true;
    }

    private void applyResistance(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 40, 0, false, false, true));
    }

    private void applyAbsorption(LivingEntity entity) {
        entity.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 40, 0, false, false, true));
    }

    public void cleanup() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.clearTrackedBuffs(serverLevel);
        } else {
            this.buffedEntityIds.clear();
        }
    }

    private void clearTrackedBuffs(ServerLevel serverLevel) {
        for (UUID uuid : this.buffedEntityIds) {
            Entity entity = serverLevel.m_8791_(uuid);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.m_21195_(MobEffects.f_19606_);
            livingEntity.m_21195_(MobEffects.f_19617_);
        }
        this.buffedEntityIds.clear();
    }

    public static double getBuffRange() {
        return 8.0;
    }

    public static int getResistanceAmplifier() {
        return 0;
    }

    public static int getAbsorptionAmplifier() {
        return 0;
    }
}

