/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.base;

import com.leon.saintsdragons.common.network.DragonAnimTickets;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.leon.saintsdragons.server.entity.handler.DragonAllyManager;
import com.leon.saintsdragons.server.entity.handler.DragonCombatHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class DragonEntity
extends TamableAnimal
implements GeoEntity {
    protected static final EntityDataAccessor<Integer> DATA_COMMAND = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DATA_SIT_PROGRESS = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> DATA_GENDER = SynchedEntityData.m_135353_(DragonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private DragonAbility<?> activeAbility = null;
    public final DragonCombatHandler combatManager = new DragonCombatHandler(this);
    public final DragonAllyManager allyManager = new DragonAllyManager(this);
    public float sitProgress = 0.0f;
    public float prevSitProgress = 0.0f;
    private boolean dying = false;
    private boolean genderInitialized = false;
    private boolean isRideable = false;

    protected DragonEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void setRideable() {
        this.isRideable = true;
    }

    public boolean isRideableDragon() {
        return this.isRideable;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COMMAND, (Object)0);
        this.f_19804_.m_135372_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_GENDER, (Object)DragonGender.MALE.getId());
    }

    public DragonGender getGender() {
        return DragonGender.fromId((Byte)this.f_19804_.m_135370_(DATA_GENDER));
    }

    public void setGender(@Nullable DragonGender gender) {
        DragonGender resolved = gender == null ? DragonGender.MALE : gender;
        this.f_19804_.m_135381_(DATA_GENDER, (Object)resolved.getId());
        this.genderInitialized = true;
    }

    public boolean isFemale() {
        return this.getGender() == DragonGender.FEMALE;
    }

    public void setFemale(boolean female) {
        this.setGender(female ? DragonGender.FEMALE : DragonGender.MALE);
    }

    public boolean hasGender() {
        return this.genderInitialized;
    }

    protected void ensureGenderInitialized() {
        Level level = this.m_9236_();
        if (level != null && level.f_46443_) {
            return;
        }
        if (!this.genderInitialized) {
            this.setGender(this.f_19796_.m_188499_() ? DragonGender.FEMALE : DragonGender.MALE);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public abstract void registerControllers(AnimatableManager.ControllerRegistrar var1);

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().f_46443_) {
            this.ensureGenderInitialized();
        }
    }

    public void syncAnimState(int groundState, int flightMode) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.setAnimData(DragonAnimTickets.GROUND_STATE, groundState);
        this.setAnimData(DragonAnimTickets.FLIGHT_MODE, flightMode);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag spawnTag) {
        SpawnGroupData data = super.m_6518_(levelAccessor, difficulty, reason, spawnData, spawnTag);
        this.ensureGenderInitialized();
        return data;
    }

    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.activeAbility;
    }

    public void setActiveAbility(DragonAbility<?> ability) {
        this.activeAbility = ability;
    }

    public boolean canUseAbility() {
        return this.combatManager.canUseAbility();
    }

    public boolean areAbilitiesLocked() {
        return this.combatManager.isGlobalCooldownActive();
    }

    public void lockAbilities(int ticks) {
        this.combatManager.lockGlobalCooldown(ticks);
    }

    public <T extends DragonEntity> void tryActivateAbility(DragonAbilityType<T, ?> abilityType) {
        if (abilityType == null || this.m_9236_().f_46443_) {
            return;
        }
        this.combatManager.tryUseAbility(abilityType);
    }

    public Map<String, VocalEntry> getVocalEntries() {
        return Collections.emptyMap();
    }

    public DragonSoundProfile getSoundProfile() {
        return DragonSoundProfile.EMPTY;
    }

    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return null;
    }

    protected void onSuccessfulDamage(DamageSource source, float amount) {
        if (this.m_9236_().f_46443_ || this.isDying()) {
            return;
        }
        DragonAbilityType<?, ?> hurtAbility = this.getHurtAbilityType();
        if (hurtAbility != null) {
            this.combatManager.tryUseAbility(hurtAbility);
        }
    }

    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (result) {
            this.onSuccessfulDamage(source, amount);
        }
        return result;
    }

    public abstract DragonAbilityType<?, ?> getPrimaryAttackAbility();

    public DragonAbilityType<?, ?> getRoaringAbility() {
        return null;
    }

    public DragonAbilityType<?, ?> getChannelingAbility() {
        return null;
    }

    public boolean isDying() {
        return this.dying;
    }

    public void onDeathAbilityStarted() {
    }

    public int getDeathAnimationDurationTicks() {
        return 62;
    }

    protected final void beginStandardDeathSequence(DragonAbilityType<?, ?> deathAbility) {
        if (this.m_9236_().f_46443_ || this.dying) {
            return;
        }
        this.m_20331_(true);
        this.dying = true;
        if (!this.canUseAbility()) {
            this.combatManager.forceEndActiveAbility();
        }
        this.tryActivateAbilityUnchecked(deathAbility);
    }

    protected final void completeStandardDeathSequence() {
        this.dying = false;
        this.m_20331_(false);
    }

    private void tryActivateAbilityUnchecked(DragonAbilityType<?, ?> type) {
        this.combatManager.tryUseAbility(type);
    }

    protected final boolean handleLethalDamage(DamageSource source, float amount, DragonAbilityType<?, ?> deathAbility) {
        if (this.m_9236_().f_46443_ || this.dying) {
            return false;
        }
        if (this.m_21223_() - amount > 0.0f) {
            return false;
        }
        this.beginStandardDeathSequence(deathAbility);
        boolean abilityStarted = this.combatManager.isAbilityActive(deathAbility);
        if (!abilityStarted) {
            this.completeStandardDeathSequence();
            return false;
        }
        return true;
    }

    protected final void registerBiteSoundKey(AnimationController<?> controller, String speciesId) {
        controller.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation." + speciesId + ".bite"));
    }

    public boolean isStayOrSitMuted() {
        return false;
    }

    public boolean isSleepTransitioning() {
        return false;
    }

    public boolean isFlying() {
        return false;
    }

    public boolean isRunning() {
        return false;
    }

    public boolean isWalking() {
        return false;
    }

    public boolean isActuallyRunning() {
        return false;
    }

    public double getCachedHorizontalSpeed() {
        return 0.0;
    }

    public boolean areRiderControlsLocked() {
        return false;
    }

    public Vec3 getClientLocatorPosition(String locator) {
        return null;
    }

    public float maxSitTicks() {
        return 15.0f;
    }

    public float getSitProgress() {
        return ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
    }

    public boolean isGoingUp() {
        return false;
    }

    public void setGoingUp(boolean goingUp) {
    }

    public boolean isGoingDown() {
        return false;
    }

    public void setGoingDown(boolean goingDown) {
    }

    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    protected void tickAbilities() {
        if (!this.m_9236_().f_46443_) {
            this.combatManager.tick();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.tickAbilities();
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(DATA_COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(DATA_COMMAND, (Object)command);
        if (this.m_21824_()) {
            this.m_21839_(command == 1);
        }
    }

    public boolean canOwnerCommand(Player player) {
        return player != null && player.m_6047_();
    }

    public boolean canOwnerMount(Player player) {
        return !this.m_6162_();
    }

    public boolean isAlly(Entity entity) {
        OwnableEntity ownable;
        LivingEntity owner;
        TamableAnimal tamable;
        Player player;
        if (entity == null) {
            return false;
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return true;
            }
        }
        if (entity instanceof DragonEntity) {
            DragonEntity otherDragon = (DragonEntity)entity;
            if (this.m_21824_() && otherDragon.m_21824_()) {
                LivingEntity owner2 = this.m_269323_();
                if (owner2 instanceof Player) {
                    Player ownerPlayer = (Player)owner2;
                    if (otherDragon.m_21830_((LivingEntity)ownerPlayer)) {
                        return true;
                    }
                    LivingEntity otherOwner = otherDragon.m_269323_();
                    if (otherOwner instanceof Player) {
                        Player otherPlayer = (Player)otherOwner;
                        return this.allyManager.isAlly(otherPlayer);
                    }
                }
                return false;
            }
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            return this.allyManager.isAlly(player);
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && (owner = tamable.m_269323_()) instanceof Player) {
            Player playerOwner = (Player)owner;
            return this.m_21824_() && this.m_21830_((LivingEntity)playerOwner) || this.allyManager.isAlly(playerOwner);
        }
        if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            Player playerOwner = (Player)owner;
            return this.m_21824_() && this.m_21830_((LivingEntity)playerOwner) || this.allyManager.isAlly(playerOwner);
        }
        return false;
    }

    public boolean canTarget(Entity entity) {
        OwnableEntity ownable;
        Player playerOwner;
        LivingEntity owner;
        TamableAnimal tamable;
        if (entity == null) {
            return false;
        }
        if (this.isAlly(entity)) {
            return false;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && (owner = tamable.m_269323_()) instanceof Player) {
            playerOwner = (Player)owner;
            if (this.m_21824_() && this.m_21830_((LivingEntity)playerOwner)) {
                return false;
            }
        }
        if (entity instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player) {
            playerOwner = (Player)owner;
            if (this.m_21824_() && this.m_21830_((LivingEntity)playerOwner)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && this.canOwnerCommand(player) && hand == InteractionHand.MAIN_HAND && player.m_21120_(hand).m_41619_()) {
            int next = (this.getCommand() + 1) % 3;
            this.setCommand(next);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Command", this.getCommand());
        tag.m_128344_("Gender", this.getGender().getId());
        tag.m_128379_("IsFemale", this.isFemale());
        this.allyManager.saveToNBT(tag);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Command")) {
            this.setCommand(tag.m_128451_("Command"));
        }
        if (tag.m_128425_("Gender", 1)) {
            this.setGender(DragonGender.fromId(tag.m_128445_("Gender")));
        } else if (tag.m_128441_("IsFemale")) {
            this.setFemale(tag.m_128471_("IsFemale"));
        } else {
            this.genderInitialized = false;
            this.ensureGenderInitialized();
        }
        this.allyManager.loadFromNBT(tag);
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21827_() && !this.m_20160_() && !this.m_20159_()) {
            this.m_20256_(Vec3.f_82478_);
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        super.m_7023_(travelVector);
    }

    public abstract Vec3 getHeadPosition();

    public abstract Vec3 getMouthPosition();

    public static final class VocalEntryBuilder {
        private final Map<String, VocalEntry> entries = new HashMap<String, VocalEntry>();

        public VocalEntryBuilder add(String key, String controller, String animation, Supplier<SoundEvent> sound, float volume, float basePitch, float variance, boolean allowWhenSitting, boolean allowDuringSleep, boolean preventOverlap) {
            this.entries.put(key, new VocalEntry(controller, animation, sound, volume, basePitch, variance, allowWhenSitting, allowDuringSleep, preventOverlap));
            return this;
        }

        public VocalEntryBuilder add(String key, String controller, String animation, Supplier<SoundEvent> sound) {
            return this.add(key, controller, animation, sound, 1.0f, 1.0f, 0.0f, false, false, false);
        }

        public Map<String, VocalEntry> build() {
            return Map.copyOf(this.entries);
        }
    }

    public record VocalEntry(String controllerId, String animationId, Supplier<SoundEvent> soundSupplier, float volume, float basePitch, float pitchVariance, boolean allowWhenSitting, boolean allowDuringSleep, boolean preventOverlap) {
    }
}

