/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxConstantsHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class RaevyxPhysicsController {
    private final Raevyx wyvern;
    private static final int TAKEOFF_ANIM_MAX_TICKS = 24;
    private static final int TAKEOFF_ANIM_EARLY_TICKS = 16;
    private final Envelope01 glideEnv = new Envelope01(0.25f, 0.25f);
    private final Envelope01 flapEnv = new Envelope01(0.25f, 0.18f);
    private final Envelope01 hoverEnv = new Envelope01(0.4f, 0.15f);
    public float glidingFraction = 0.0f;
    public float prevGlidingFraction = 0.0f;
    public float flappingFraction = 0.0f;
    public float prevFlappingFraction = 0.0f;
    public float hoveringFraction = 0.0f;
    public float prevHoveringFraction = 0.0f;
    private RawAnimation currentFlightAnimation = RaevyxConstantsHandler.FLY_GLIDE;
    private static final float MASS = 1.3f;
    private static final float LIFT_K = 11.0f;
    private static final float CLIMB_COST = 6.0f;
    private static final float RESPONSE = 1.5f;

    public RaevyxPhysicsController(Raevyx wyvern) {
        this.wyvern = wyvern;
    }

    public void tick() {
        this.prevGlidingFraction = this.glidingFraction;
        this.prevFlappingFraction = this.flappingFraction;
        this.prevHoveringFraction = this.hoveringFraction;
        this.updatePhysicsEnvelopes();
    }

    public int computeFlightModeForSync() {
        boolean hovering;
        if (!this.wyvern.m_29443_()) {
            return -1;
        }
        if (this.shouldPlayTakeoff()) {
            return 3;
        }
        float hoverWeight = this.hoveringFraction;
        float flapWeight = this.flappingFraction;
        boolean bl = hovering = hoverWeight > 0.35f;
        if (hovering) {
            return 2;
        }
        boolean flap = flapWeight > 0.4f;
        return flap ? 1 : 0;
    }

    public PlayState handleMovementAnimation(AnimationState<Raevyx> state) {
        state.getController().transitionLength(6);
        if (this.wyvern.m_6162_()) {
            if (this.wyvern.isActuallyRunning()) {
                state.getController().transitionLength(3);
                state.setAndContinue(RaevyxConstantsHandler.BABY_RUN);
            } else if (this.wyvern.isWalking()) {
                state.getController().transitionLength(3);
                state.setAndContinue(RaevyxConstantsHandler.BABY_WALK);
            } else {
                state.getController().transitionLength(4);
                state.setAndContinue(RaevyxConstantsHandler.BABY_IDLE);
            }
            return PlayState.CONTINUE;
        }
        if (this.wyvern.isDying() || this.wyvern.m_5803_() || this.wyvern.isSleepingEntering() || this.wyvern.isSleepingExiting()) {
            return PlayState.STOP;
        }
        float maxSit = this.wyvern.maxSitTicks();
        float sitProgress = this.wyvern.getSitProgress();
        if (sitProgress >= maxSit) {
            state.setAndContinue(RaevyxConstantsHandler.SIT);
        } else {
            if (sitProgress > 0.0f) {
                return PlayState.STOP;
            }
            if (this.wyvern.isDodging()) {
                state.setAndContinue(RaevyxConstantsHandler.DODGE);
            } else if (this.wyvern.isLanding()) {
                state.setAndContinue(RaevyxConstantsHandler.LANDING);
            } else if (this.wyvern.m_29443_()) {
                boolean manualRiderControl;
                int syncedMode = this.wyvern.getSyncedFlightMode();
                Vec3 vNow = this.wyvern.m_20184_();
                if (syncedMode == 3) {
                    state.getController().transitionLength(4);
                    state.setAndContinue(RaevyxConstantsHandler.TAKEOFF);
                    return PlayState.CONTINUE;
                }
                if (this.wyvern.isRiderLandingBlendActive()) {
                    state.getController().transitionLength(4);
                    this.currentFlightAnimation = RaevyxConstantsHandler.LANDING;
                    state.setAndContinue(RaevyxConstantsHandler.LANDING);
                    return PlayState.CONTINUE;
                }
                boolean bl = manualRiderControl = this.wyvern.m_21824_() && this.wyvern.m_20160_();
                if (manualRiderControl) {
                    if (this.wyvern.isGoingUp()) {
                        RawAnimation upward = RaevyxConstantsHandler.FLAP;
                        if (this.currentFlightAnimation != upward) {
                            state.getController().transitionLength(4);
                            this.currentFlightAnimation = upward;
                        }
                        state.setAndContinue(upward);
                        return PlayState.CONTINUE;
                    }
                    if (this.wyvern.isGoingDown() && !this.wyvern.isRiderLandingBlendActive()) {
                        RawAnimation descend = RaevyxConstantsHandler.GLIDE_DOWN;
                        if (this.currentFlightAnimation != descend) {
                            state.getController().transitionLength(6);
                            this.currentFlightAnimation = descend;
                        }
                        state.setAndContinue(descend);
                        return PlayState.CONTINUE;
                    }
                }
                if (syncedMode == 2) {
                    state.getController().transitionLength(6);
                    state.setAndContinue(RaevyxConstantsHandler.FLAP);
                    return PlayState.CONTINUE;
                }
                if (syncedMode == 1) {
                    state.getController().transitionLength(4);
                    state.setAndContinue(RaevyxConstantsHandler.FLAP);
                    return PlayState.CONTINUE;
                }
                if (syncedMode == 0) {
                    state.getController().transitionLength(12);
                    state.setAndContinue(this.resolveGlideAnimation(vNow));
                    return PlayState.CONTINUE;
                }
                if (this.shouldPlayTakeoff()) {
                    state.getController().transitionLength(4);
                    state.setAndContinue(RaevyxConstantsHandler.TAKEOFF);
                } else {
                    boolean ascendingNow;
                    boolean shouldFlapBase;
                    boolean descendingNow;
                    float hoverWeight = this.hoveringFraction;
                    float flapWeight = this.flappingFraction;
                    boolean bl2 = descendingNow = vNow.f_82480_ < -0.03;
                    descendingNow = this.wyvern.m_20160_() ? (descendingNow |= this.wyvern.isGoingDown()) : (descendingNow |= this.wyvern.getPitchDirection() > 0);
                    boolean bl3 = this.currentFlightAnimation == RaevyxConstantsHandler.FLAP ? flapWeight > 0.55f || hoverWeight > 0.65f : (shouldFlapBase = flapWeight > 0.22f || hoverWeight > 0.28f);
                    if (hoverWeight > 0.45f) {
                        state.getController().transitionLength(6);
                        this.currentFlightAnimation = RaevyxConstantsHandler.FLAP;
                        state.setAndContinue(RaevyxConstantsHandler.FLAP);
                        return PlayState.CONTINUE;
                    }
                    boolean bl4 = ascendingNow = this.wyvern.isGoingUp() || vNow.f_82480_ > 0.02;
                    if (ascendingNow) {
                        if (this.currentFlightAnimation != RaevyxConstantsHandler.FLAP) {
                            state.getController().transitionLength(4);
                            this.currentFlightAnimation = RaevyxConstantsHandler.FLAP;
                        }
                        state.setAndContinue(RaevyxConstantsHandler.FLAP);
                    } else if (shouldFlapBase) {
                        if (this.currentFlightAnimation != RaevyxConstantsHandler.FLAP) {
                            state.getController().transitionLength(4);
                            this.currentFlightAnimation = RaevyxConstantsHandler.FLAP;
                        }
                        state.setAndContinue(RaevyxConstantsHandler.FLAP);
                    } else {
                        RawAnimation glideAnimation = this.resolveGlideAnimation(vNow);
                        if (this.currentFlightAnimation != glideAnimation) {
                            state.getController().transitionLength(8);
                            this.currentFlightAnimation = glideAnimation;
                        }
                        state.setAndContinue(glideAnimation);
                    }
                }
            } else if (this.wyvern.isActuallyRunning()) {
                state.getController().transitionLength(3);
                state.setAndContinue(RaevyxConstantsHandler.GROUND_RUN);
            } else if (this.wyvern.isWalking()) {
                state.getController().transitionLength(3);
                state.setAndContinue(RaevyxConstantsHandler.GROUND_WALK);
            } else {
                state.getController().transitionLength(4);
                state.setAndContinue(RaevyxConstantsHandler.GROUND_IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    private boolean shouldPlayTakeoff() {
        if (this.wyvern.timeFlying < 16) {
            return true;
        }
        boolean airborne = !this.wyvern.m_20096_();
        boolean ascending = this.wyvern.m_20184_().f_82480_ > 0.08;
        return this.wyvern.timeFlying < 24 && (airborne || ascending);
    }

    private void updatePhysicsEnvelopes() {
        Vec3 v = this.wyvern.m_20184_();
        float vH = (float)Math.hypot(v.f_82479_, v.f_82481_);
        float vY = (float)v.f_82480_;
        float glideLift = 11.0f * vH * vH;
        float climbNeed = vY > 0.0f ? vY * 6.0f : 0.0f;
        float need = 1.3f + climbNeed - glideLift;
        float flapTarget = need <= 0.0f ? 0.0f : need / (need + 1.5f);
        flapTarget = Mth.m_14036_((float)flapTarget, (float)0.0f, (float)1.0f);
        float hoverTarget = this.wyvern.isHovering() || this.wyvern.isLanding() || this.wyvern.isBeaming() || vH < 0.02f && Math.abs(vY) < 0.02f ? 1.0f : 0.0f;
        float glideTarget = Mth.m_14036_((float)(1.0f - flapTarget), (float)0.15f, (float)1.0f);
        if (this.wyvern.m_29443_()) {
            if (this.wyvern.m_6688_() != null && this.wyvern.isGoingUp()) {
                flapTarget = Math.max(flapTarget, 0.6f);
            } else if (vY > 0.06f) {
                float ascentBias = Mth.m_14036_((float)((vY - 0.02f) * 3.0f), (float)0.2f, (float)0.8f);
                flapTarget = Math.max(flapTarget, ascentBias);
            }
            glideTarget = Mth.m_14036_((float)(1.0f - flapTarget), (float)0.15f, (float)1.0f);
        }
        this.flapEnv.tickToward(flapTarget);
        this.hoverEnv.tickToward(hoverTarget);
        this.glideEnv.tickToward(glideTarget);
        this.glidingFraction = this.glideEnv.raw();
        this.flappingFraction = this.flapEnv.raw();
        this.hoveringFraction = this.hoverEnv.raw();
    }

    private RawAnimation resolveGlideAnimation(Vec3 velocity) {
        boolean hasForwardSpeed;
        if (!this.wyvern.m_21824_()) {
            return RaevyxConstantsHandler.FLY_GLIDE;
        }
        Vec3 motion = velocity == null ? Vec3.f_82478_ : velocity;
        double verticalSpeed = motion.f_82480_;
        double horizontalSpeedSqr = motion.m_165925_();
        boolean riderDescending = this.wyvern.m_20160_() && this.wyvern.isGoingDown();
        boolean pitchingDown = !this.wyvern.m_20160_() && this.wyvern.getPitchDirection() > 0;
        boolean fallingFast = verticalSpeed < -0.06;
        boolean moderateDescent = verticalSpeed < -0.025;
        boolean sustainedGlide = this.glidingFraction > 0.18f || this.flapEnv.raw() < 0.35f;
        boolean bl = hasForwardSpeed = horizontalSpeedSqr > 9.0E-4;
        if ((pitchingDown || riderDescending || fallingFast || moderateDescent) && sustainedGlide && hasForwardSpeed) {
            return RaevyxConstantsHandler.GLIDE_DOWN;
        }
        return RaevyxConstantsHandler.FLY_GLIDE;
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128350_("GlideVal", this.glideEnv.raw());
        tag.m_128350_("FlapVal", this.flapEnv.raw());
        tag.m_128350_("HoverVal", this.hoverEnv.raw());
    }

    public void readFromNBT(CompoundTag tag) {
        if (tag.m_128441_("GlideVal")) {
            this.glideEnv.setRaw(tag.m_128457_("GlideVal"));
            this.flapEnv.setRaw(tag.m_128457_("FlapVal"));
            this.hoverEnv.setRaw(tag.m_128457_("HoverVal"));
        }
        this.glidingFraction = this.glideEnv.raw();
        this.flappingFraction = this.flapEnv.raw();
        this.hoveringFraction = this.hoverEnv.raw();
        this.prevGlidingFraction = this.glidingFraction;
        this.prevFlappingFraction = this.flappingFraction;
        this.prevHoveringFraction = this.hoveringFraction;
    }

    public static class Envelope01 {
        private float val = 0.0f;
        private float prev = 0.0f;
        private final float upRate;
        private final float downRate;

        public Envelope01(float upRate, float downRate) {
            this.upRate = upRate;
            this.downRate = downRate;
        }

        public void tickToward(float target) {
            this.prev = this.val;
            float rate = target > this.val ? this.upRate : this.downRate;
            this.val += (target - this.val) * rate;
            if (this.val < 0.0f) {
                this.val = 0.0f;
            } else if (this.val > 1.0f) {
                this.val = 1.0f;
            }
        }

        public float raw() {
            return this.val;
        }

        public float get(float pt) {
            return Mth.m_14179_((float)pt, (float)this.prev, (float)this.val);
        }

        public void setRaw(float v) {
            this.prev = this.val = Mth.m_14036_((float)v, (float)0.0f, (float)1.0f);
        }
    }
}

