/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.nulljaw.NulljawAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawAttackGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawCombatGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawFindWaterGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawLeaveWaterGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawMoveGoal;
import com.leon.saintsdragons.server.ai.goals.nulljaw.NulljawRandomSwimGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonAmphibiousNavigation;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.ai.navigation.DragonSwimMoveControl;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.base.RideableDragonData;
import com.leon.saintsdragons.server.entity.controller.nulljaw.NulljawRiderController;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers.NulljawAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers.NulljawInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers.NulljawSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonKeybindHandler;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.AquaticDragon;
import com.leon.saintsdragons.server.entity.interfaces.DragonControlStateHolder;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Nulljaw
extends RideableDragonBase
implements AquaticDragon,
DragonControlStateHolder,
ShakesScreen,
SoundHandledDragon {
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "ambient", "animation.nulljaw.grumble1", (Supplier<SoundEvent>)ModSounds.NULLJAW_GRUMBLE_1, 0.8f, 0.95f, 0.1f, false, false, true).add("grumble2", "ambient", "animation.nulljaw.grumble2", (Supplier<SoundEvent>)ModSounds.NULLJAW_GRUMBLE_2, 0.8f, 0.95f, 0.1f, false, false, true).add("grumble3", "ambient", "animation.nulljaw.grumble3", (Supplier<SoundEvent>)ModSounds.NULLJAW_GRUMBLE_3, 0.8f, 0.95f, 0.1f, false, false, true).build();
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private static final int MIN_AMBIENT_DELAY = 200;
    private static final int MAX_AMBIENT_DELAY = 600;
    private static final EntityDataAccessor<Integer> DATA_GROUND_MOVE_STATE = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_RIDER_FORWARD = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_RIDER_STRAFE = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DATA_ACCELERATING = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SWIMMING = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SWIM_TURN = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_SWIM_PITCH = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_PHASE_TWO = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_RIDER_LOCKED = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_SCREEN_SHAKE_AMOUNT = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_FLIGHT_MODE = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_GOING_UP = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_GOING_DOWN = SynchedEntityData.m_135353_(Nulljaw.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DragonSoundHandler soundHandler = new DragonSoundHandler(this);
    private final DragonKeybindHandler keybindHandler = new DragonKeybindHandler(this);
    private final NulljawAnimationHandler animationHandler = new NulljawAnimationHandler(this);
    private final NulljawInteractionHandler interactionHandler = new NulljawInteractionHandler(this);
    private final NulljawRiderController riderController;
    private final PathNavigation groundNavigation;
    private final DragonAmphibiousNavigation waterNavigation;
    private final MoveControl landMoveControl;
    private final DragonSwimMoveControl swimMoveControl;
    private final RiftDrakeLookController landLookControl;
    private int riderControlLockTicks = 0;
    private NulljawRandomSwimGoal waterSwimGoal;
    private NulljawGroundWanderGoal groundWanderGoal;
    private boolean swimming;
    private int swimTicks;
    private int ticksInWater;
    private int ticksOutOfWater;
    private float swimTurnSmoothedYaw;
    private int swimTurnState;
    private int swimPitchStateTicks;
    private float swimRollAngle = 0.0f;
    private float prevSwimRollAngle = 0.0f;
    private byte controlState = 0;
    private boolean useLeftClawNext = true;
    private static final float SHAKE_DECAY_PER_TICK = 0.02f;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    private final Map<String, Vec3> clientLocatorCache = new ConcurrentHashMap<String, Vec3>();

    public Nulljaw(EntityType<? extends Nulljaw> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.m_274367_(1.4f);
        this.groundNavigation = new DragonPathNavigateGround((Mob)this, level);
        this.waterNavigation = new DragonAmphibiousNavigation((Mob)this, level);
        this.landMoveControl = new RiftDrakeMoveControl(this);
        this.swimMoveControl = new DragonSwimMoveControl((Mob)this, 6.0f, 0.08, 0.12);
        this.landLookControl = new RiftDrakeLookController(this);
        this.f_21344_ = this.groundNavigation;
        this.f_21342_ = this.landMoveControl;
        this.f_21365_ = this.landLookControl;
        this.riderController = new NulljawRiderController(this);
        this.setRideable();
        RandomSource rng = this.m_217043_();
        this.ambientSoundTimer = rng.m_188503_(80);
        this.nextAmbientSoundDelay = 200 + rng.m_188503_(400);
    }

    private void tickRiderControlLock() {
        if (this.riderControlLockTicks > 0) {
            --this.riderControlLockTicks;
            if (this.riderControlLockTicks <= 0) {
                this.f_19804_.m_135381_(DATA_RIDER_LOCKED, (Object)false);
            }
        }
    }

    @Override
    protected float getRiderLockYawBlend() {
        return this.isPhaseTwoActive() ? 0.25f : 0.18f;
    }

    @Override
    protected float getRiderLockPitchBlend() {
        return this.isPhaseTwoActive() ? 0.25f : 0.18f;
    }

    @Override
    public boolean areRiderControlsLocked() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(DATA_RIDER_LOCKED) : this.riderControlLockTicks > 0;
    }

    public void lockRiderControls(int ticks) {
        this.riderControlLockTicks = Math.max(this.riderControlLockTicks, Math.max(0, ticks));
        this.f_19804_.m_135381_(DATA_RIDER_LOCKED, (Object)true);
        this.setAccelerating(false);
        this.setLastRiderForward(0.0f);
        this.setLastRiderStrafe(0.0f);
        this.setGroundMoveStateFromRider(0);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.m_20256_(Vec3.f_82478_);
        if (!this.m_9236_().f_46443_) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
        }
    }

    @Override
    public void lockAbilities(int ticks) {
        this.combatManager.lockGlobalCooldown(ticks);
    }

    @Override
    protected boolean isRiderInputLocked(Player player) {
        return this.areRiderControlsLocked();
    }

    @Override
    protected void applyRiderVerticalInput(Player player, boolean goingUp, boolean goingDown, boolean locked) {
        if (locked) {
            this.setGoingUp(false);
            this.setGoingDown(false);
            return;
        }
        boolean inWater = this.m_6069_() || this.m_20072_();
        this.setGoingUp(inWater && goingUp);
        this.setGoingDown(inWater && goingDown);
    }

    @Override
    protected void applyRiderMovementInput(Player player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = locked ? 0.0f : this.applyInputDeadzone(forward);
        float str = locked ? 0.0f : this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        int moveState = 0;
        float magnitude = Math.abs(fwd) + Math.abs(str);
        if (magnitude > 0.05f) {
            moveState = this.isAccelerating() ? 2 : 1;
        }
        this.setGroundMoveStateFromRider(moveState);
    }

    @Override
    protected void handleRiderAction(ServerPlayer player, DragonRiderAction action, String abilityName, boolean locked) {
        if (locked || action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                this.handleJumpRequest();
                break;
            }
            case ACCELERATE: {
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.forceEndActiveAbility();
                break;
            }
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21183_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22281_, 10.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_GROUND_MOVE_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ACCELERATING, (Object)false);
        this.f_19804_.m_135372_(DATA_SWIMMING, (Object)false);
        this.f_19804_.m_135372_(DATA_SWIM_TURN, (Object)0);
        this.f_19804_.m_135372_(DATA_SWIM_PITCH, (Object)0);
        this.f_19804_.m_135372_(DATA_PHASE_TWO, (Object)false);
        this.f_19804_.m_135372_(DATA_FLIGHT_MODE, (Object)-1);
        this.f_19804_.m_135372_(DATA_GOING_UP, (Object)false);
        this.f_19804_.m_135372_(DATA_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(DATA_RIDER_LOCKED, (Object)false);
        this.f_19804_.m_135372_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void defineRideableDragonData() {
    }

    @Override
    protected EntityDataAccessor<Float> getRiderForwardAccessor() {
        return DATA_RIDER_FORWARD;
    }

    @Override
    protected EntityDataAccessor<Float> getRiderStrafeAccessor() {
        return DATA_RIDER_STRAFE;
    }

    @Override
    protected EntityDataAccessor<Integer> getGroundMoveStateAccessor() {
        return DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected EntityDataAccessor<Integer> getFlightModeAccessor() {
        return DATA_FLIGHT_MODE;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingUpAccessor() {
        return DATA_GOING_UP;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingDownAccessor() {
        return DATA_GOING_DOWN;
    }

    @Override
    protected EntityDataAccessor<Boolean> getAcceleratingAccessor() {
        return DATA_ACCELERATING;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new NulljawAttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new NulljawCombatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new NulljawMoveGoal(this, true, 1.3));
        this.f_21345_.m_25352_(4, (Goal)new NulljawLeaveWaterGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new NulljawFindWaterGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new NulljawFollowOwnerGoal(this));
        this.waterSwimGoal = new NulljawRandomSwimGoal(this, 1.2, 30);
        this.f_21345_.m_25352_(7, (Goal)this.waterSwimGoal);
        this.groundWanderGoal = new NulljawGroundWanderGoal(this, 1.0, 100);
        this.f_21345_.m_25352_(8, (Goal)this.groundWanderGoal);
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new DragonOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 5, this.animationHandler::movementPredicate);
        AnimationController swimController = new AnimationController((GeoAnimatable)this, "swim_direction", 4, this.animationHandler::swimDirectionPredicate);
        AnimationController actions = new AnimationController((GeoAnimatable)this, "action", 10, this.animationHandler::actionPredicate);
        AnimationController ambient = new AnimationController((GeoAnimatable)this, "ambient", 3, this.animationHandler::ambientPredicate);
        this.animationHandler.configureMovementBlend((AnimationController<Nulljaw>)movementController);
        this.animationHandler.configureSwimBlend((AnimationController<Nulljaw>)swimController);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        swimController.setSoundKeyframeHandler(this::onAnimationSound);
        actions.setSoundKeyframeHandler(this::onAnimationSound);
        ambient.setSoundKeyframeHandler(this::onAnimationSound);
        this.animationHandler.setupActionController((AnimationController<Nulljaw>)actions);
        this.animationHandler.setupAmbientController((AnimationController<Nulljaw>)ambient);
        controllers.add(new AnimationController[]{movementController});
        controllers.add(new AnimationController[]{swimController});
        controllers.add(new AnimationController[]{actions});
        controllers.add(new AnimationController[]{ambient});
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return NulljawSoundProfile.INSTANCE;
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
    }

    public DragonKeybindHandler getKeybindHandler() {
        return this.keybindHandler;
    }

    private void playCustomAmbientSound() {
        RandomSource random = this.m_217043_();
        if (this.isDying() || this.m_5448_() != null || this.getActiveAbility() != null) {
            return;
        }
        String vocalKey = null;
        float moodRoll = random.m_188501_();
        vocalKey = moodRoll < 0.4f ? "grumble1" : (moodRoll < 0.7f ? "grumble2" : "grumble3");
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.isDying() || this.m_21827_()) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void resetAmbientSoundTimer() {
        RandomSource random = this.m_217043_();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.m_188503_(400);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.soundHandler.tick();
        this.tickScreenShake();
        this.tickSittingState();
        this.updateSittingProgress();
        this.tickClientSideUpdates();
        if (!this.m_9236_().f_46443_) {
            this.handleAmbientSounds();
        }
        if (!this.m_9236_().f_46443_) {
            this.tickRiderControlLock();
            boolean inWater = this.m_20069_();
            if (inWater) {
                this.m_20301_(this.m_6062_());
                this.swimTicks = Math.min(this.swimTicks + 1, 200);
                this.ticksInWater = Math.min(this.ticksInWater + 1, 1200);
                this.ticksOutOfWater = 0;
            } else {
                this.swimTicks = Math.max(this.swimTicks - 1, 0);
                this.ticksOutOfWater = Math.min(this.ticksOutOfWater + 1, 1200);
                this.ticksInWater = 0;
            }
            if (inWater && !this.swimming) {
                this.enterSwimState();
            } else if (!inWater && this.swimming) {
                this.exitSwimState();
            }
            if (this.m_6688_() != null && this.f_21365_ != this.landLookControl) {
                this.f_21365_ = this.landLookControl;
            }
            this.tickAnimationStates();
            this.updateSwimOrientationState();
        }
    }

    @Override
    public void m_7023_(@NotNull Vec3 motion) {
        LivingEntity livingEntity;
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.areRiderControlsLocked()) {
                this.m_20256_(Vec3.f_82478_);
                return;
            }
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            if (this.m_20072_()) {
                this.handleRiddenSwimming(motion);
            } else {
                this.setGoingUp(false);
                this.setGoingDown(false);
                super.m_7023_(motion);
            }
        } else {
            super.m_7023_(motion);
        }
    }

    @NotNull
    public PathNavigation m_21573_() {
        return this.swimming ? this.waterNavigation : this.groundNavigation;
    }

    @Override
    public PathNavigation getAquaticNavigation() {
        return this.waterNavigation;
    }

    @Override
    public double getSwimSpeed() {
        double baseSpeed = 1.45;
        if (this.m_20160_()) {
            baseSpeed += 0.2;
        }
        return baseSpeed;
    }

    @Override
    public void onEnterWater() {
        this.m_20256_(this.m_20184_());
        this.tickAnimationStates();
    }

    @Override
    public void onExitWater() {
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        this.tickAnimationStates();
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult handlerResult = this.interactionHandler.handleInteraction(player, hand);
        if (handlerResult != InteractionResult.PASS) {
            return handlerResult;
        }
        return super.m_6071_(player, hand);
    }

    public InteractionResult superMobInteract(Player player, InteractionHand hand) {
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_150930_(Items.f_42526_) || stack.m_150930_(Items.f_42527_) || stack.m_150930_(Items.f_42528_);
    }

    @Override
    public void setLastRiderForward(float forward) {
        this.f_19804_.m_135381_(DATA_RIDER_FORWARD, (Object)Float.valueOf(forward));
    }

    @Override
    public void setLastRiderStrafe(float strafe) {
        this.f_19804_.m_135381_(DATA_RIDER_STRAFE, (Object)Float.valueOf(strafe));
    }

    public float getLastRiderForward() {
        return ((Float)this.f_19804_.m_135370_(DATA_RIDER_FORWARD)).floatValue();
    }

    public float getLastRiderStrafe() {
        return ((Float)this.f_19804_.m_135370_(DATA_RIDER_STRAFE)).floatValue();
    }

    @Override
    public boolean isAccelerating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACCELERATING);
    }

    @Override
    public void setAccelerating(boolean accelerating) {
        this.f_19804_.m_135381_(DATA_ACCELERATING, (Object)accelerating);
    }

    public void setGroundMoveStateFromRider(int state) {
        int s = Mth.m_14045_((int)state, (int)0, (int)2);
        if ((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE) != s) {
            this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)s);
        }
        this.syncAnimState(s, this.getSyncedFlightMode());
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void setRunning(boolean running) {
    }

    @Override
    public boolean isDragonFlying() {
        return false;
    }

    @Override
    public boolean isHovering() {
        return false;
    }

    @Override
    public boolean isTakeoff() {
        return false;
    }

    @Override
    public boolean isLanding() {
        return false;
    }

    @Override
    public int getFlightMode() {
        return -1;
    }

    public void handleJumpRequest() {
        if (this.areRiderControlsLocked()) {
            return;
        }
        if (this.m_20069_()) {
            Vec3 jump = new Vec3(0.0, 0.6, 0.0);
            this.m_20256_(this.m_20184_().m_82549_(jump));
            this.f_19812_ = true;
        } else if (this.m_20096_()) {
            Vec3 movement = this.m_20184_();
            this.m_20334_(movement.f_82479_, 0.42, movement.f_82481_);
            this.f_19812_ = true;
        }
    }

    @Override
    @NotNull
    public Vec3 m_274312_(@NotNull Player player, @NotNull Vec3 deltaIn) {
        if (this.areRiderControlsLocked()) {
            return Vec3.f_82478_;
        }
        Vec3 input = this.riderController.getRiddenInput(player, deltaIn);
        if (!this.m_9236_().f_46443_) {
            float fwd = (float)Mth.m_14008_((double)input.f_82481_, (double)-1.0, (double)1.0);
            float str = (float)Mth.m_14008_((double)input.f_82479_, (double)-1.0, (double)1.0);
            this.setLastRiderForward(RideableDragonData.applyInputThreshold(fwd));
            this.setLastRiderStrafe(RideableDragonData.applyInputThreshold(str));
        }
        return input;
    }

    protected float m_245547_(@Nonnull @NotNull Player rider) {
        if (this.areRiderControlsLocked()) {
            return 0.0f;
        }
        return this.riderController.getRiddenSpeed(rider);
    }

    protected void m_274498_(@NotNull Player player, @NotNull Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        if (this.areRiderControlsLocked()) {
            player.f_19789_ = 0.0f;
            this.f_19789_ = 0.0f;
            this.m_6710_(null);
            this.copyRiderLook(player);
            this.setAccelerating(false);
            this.setGoingUp(false);
            this.setGoingDown(false);
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        this.riderController.tickRidden(player, travelVector);
    }

    @Override
    public void m_20351_(@NotNull Entity passenger) {
        super.m_20351_(passenger);
        if (!this.m_9236_().f_46443_) {
            this.setAccelerating(false);
            this.setLastRiderForward(0.0f);
            this.setLastRiderStrafe(0.0f);
            this.setGroundMoveStateFromRider(0);
        }
    }

    public void m_6135_() {
        super.m_6135_();
        this.setGroundMoveStateFromRider(1);
    }

    public void initializeRiderState() {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DATA_GROUND_MOVE_STATE, (Object)0);
            this.f_19804_.m_135381_(DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
            this.f_19804_.m_135381_(DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
            this.setAccelerating(false);
        }
    }

    @Override
    public Vec3 getHeadPosition() {
        return this.m_146892_();
    }

    @Override
    public Vec3 getMouthPosition() {
        return this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.8, 0.0);
    }

    public void useRidingAbility(String abilityName) {
        Player player;
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        if (this.areRiderControlsLocked()) {
            return;
        }
        LivingEntity rider = this.m_6688_();
        if (!(rider instanceof LivingEntity)) {
            return;
        }
        if (this.m_21824_() && rider instanceof Player && !this.m_21830_((LivingEntity)(player = (Player)rider))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type != null) {
            this.combatManager.tryUseAbility(type);
        }
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
    }

    public double m_6048_() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void m_19956_(@Nonnull @NotNull Entity passenger, @Nonnull @NotNull Entity.MoveFunction moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.riderController.getControllingPassenger();
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob other) {
        return null;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        boolean useHornGore;
        boolean bl = useHornGore = this.f_19797_ / 40 % 2 == 1;
        if (this.isPhaseTwoActive()) {
            return useHornGore ? NulljawAbilities.NULLJAW_HORN_GORE : NulljawAbilities.NULLJAW_BITE2;
        }
        return useHornGore ? NulljawAbilities.NULLJAW_HORN_GORE : NulljawAbilities.NULLJAW_BITE;
    }

    public boolean isAbilityActive(DragonAbilityType<?, ?> abilityType) {
        return this.combatManager.isAbilityActive(abilityType);
    }

    public void forceEndAbility(DragonAbilityType<?, ?> abilityType) {
        this.combatManager.forceEndAbility(abilityType);
    }

    public static boolean canSpawn(EntityType<Nulljaw> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_6425_(pos).m_76170_() || level.m_6425_(pos.m_7495_()).m_76170_();
    }

    private void enterSwimState() {
        this.swimming = true;
        this.f_21344_ = this.waterNavigation;
        this.f_21342_ = this.swimMoveControl;
        this.f_19804_.m_135381_(DATA_SWIMMING, (Object)true);
        if (this.waterSwimGoal != null) {
            this.waterSwimGoal.forceTrigger();
        }
    }

    private void exitSwimState() {
        this.swimming = false;
        this.f_21344_ = this.groundNavigation;
        this.f_21342_ = this.landMoveControl;
        this.f_21365_ = this.landLookControl;
        this.waterNavigation.m_26573_();
        Vec3 delta = this.m_20184_();
        this.m_20256_(new Vec3(delta.f_82479_, 0.0, delta.f_82481_));
        if (this.groundWanderGoal != null) {
            this.groundWanderGoal.forceTrigger();
        }
        this.f_19804_.m_135381_(DATA_SWIMMING, (Object)false);
        this.f_19804_.m_135381_(DATA_SWIM_TURN, (Object)0);
        this.f_19804_.m_135381_(DATA_SWIM_PITCH, (Object)0);
        this.swimTurnSmoothedYaw = 0.0f;
        this.swimTurnState = 0;
        this.swimPitchStateTicks = 0;
        this.swimRollAngle = 0.0f;
        this.prevSwimRollAngle = 0.0f;
    }

    private void updateSwimOrientationState() {
        Player player;
        LivingEntity livingEntity;
        boolean riderControlled;
        if (this.m_9236_().f_46443_) {
            return;
        }
        int desiredTurn = (Integer)this.f_19804_.m_135370_(DATA_SWIM_TURN);
        int desiredPitchState = (Integer)this.f_19804_.m_135370_(DATA_SWIM_PITCH);
        boolean bl = riderControlled = this.m_21824_() && this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player && this.m_21830_((LivingEntity)(player = (Player)livingEntity)) && this.m_20072_();
        if (riderControlled) {
            float yawDelta = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
            this.swimTurnSmoothedYaw = this.swimTurnSmoothedYaw * 0.6f + yawDelta * 0.4f;
            float enter = 0.35f;
            float exit = 0.12f;
            int targetState = this.swimTurnState;
            if (this.swimTurnSmoothedYaw > enter) {
                targetState = -1;
            } else if (this.swimTurnSmoothedYaw < -enter) {
                targetState = 1;
            } else if (Math.abs(this.swimTurnSmoothedYaw) < exit) {
                targetState = 0;
            }
            desiredTurn = this.swimTurnState = targetState;
            if (this.isGoingUp()) {
                desiredPitchState = -1;
                this.swimPitchStateTicks = 6;
            } else if (this.isGoingDown()) {
                desiredPitchState = 1;
                this.swimPitchStateTicks = 6;
            } else if (desiredPitchState != 0) {
                if (this.swimPitchStateTicks > 0) {
                    --this.swimPitchStateTicks;
                } else {
                    desiredPitchState = 0;
                }
            }
        } else {
            this.swimTurnSmoothedYaw *= 0.5f;
            if (Math.abs(this.swimTurnSmoothedYaw) < 0.05f) {
                this.swimTurnState = 0;
            }
            desiredTurn = this.swimTurnState;
            if (desiredPitchState != 0) {
                if (++this.swimPitchStateTicks > 4) {
                    desiredPitchState = 0;
                    this.swimPitchStateTicks = 0;
                }
            } else {
                this.swimPitchStateTicks = 0;
            }
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_SWIM_TURN) != desiredTurn) {
            this.f_19804_.m_135381_(DATA_SWIM_TURN, (Object)desiredTurn);
        }
        if ((Integer)this.f_19804_.m_135370_(DATA_SWIM_PITCH) != desiredPitchState) {
            this.f_19804_.m_135381_(DATA_SWIM_PITCH, (Object)desiredPitchState);
        }
        this.prevSwimRollAngle = this.swimRollAngle;
        if (!this.m_6069_() || this.areRiderControlsLocked()) {
            this.swimRollAngle = 0.0f;
            this.prevSwimRollAngle = 0.0f;
            return;
        }
        float targetAngle = Mth.m_14036_((float)(this.swimTurnSmoothedYaw * 40.0f), (float)-60.0f, (float)60.0f);
        this.swimRollAngle = Mth.m_14179_((float)0.25f, (float)this.swimRollAngle, (float)targetAngle);
        if (Math.abs(this.swimRollAngle) < 0.01f) {
            this.swimRollAngle = 0.0f;
        }
    }

    public boolean m_6069_() {
        if (this.m_9236_().f_46443_) {
            return (Boolean)this.f_19804_.m_135370_(DATA_SWIMMING);
        }
        return this.swimming;
    }

    public int getSwimTurnDirection() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(DATA_SWIM_TURN)), (int)-1, (int)1);
    }

    public boolean isSwimmingDown() {
        return this.m_6069_() && (Integer)this.f_19804_.m_135370_(DATA_SWIM_PITCH) > 0;
    }

    public boolean isSwimmingUp() {
        return this.m_6069_() && (Integer)this.f_19804_.m_135370_(DATA_SWIM_PITCH) < 0;
    }

    public boolean isSwimmingMoving() {
        if (!this.m_6069_()) {
            return false;
        }
        if (this.m_21573_().m_26572_() && this.m_21573_().m_26570_() != null) {
            return true;
        }
        if (this.m_20160_()) {
            float fwd = Math.abs(((Float)this.f_19804_.m_135370_(DATA_RIDER_FORWARD)).floatValue());
            float str = Math.abs(((Float)this.f_19804_.m_135370_(DATA_RIDER_STRAFE)).floatValue());
            if (fwd > 0.03f || str > 0.03f) {
                return true;
            }
        }
        return this.m_20184_().m_165925_() > 0.0025;
    }

    public float getSwimRollAngleDegrees() {
        return this.swimRollAngle;
    }

    public float getSwimRollAngleDegrees(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevSwimRollAngle, (float)this.swimRollAngle);
    }

    public boolean isPhaseTwoActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PHASE_TWO);
    }

    public void setPhaseTwoActive(boolean active, boolean syncAnim) {
        this.f_19804_.m_135381_(DATA_PHASE_TWO, (Object)active);
        if (syncAnim) {
            this.syncAnimState((Integer)this.f_19804_.m_135370_(DATA_GROUND_MOVE_STATE), this.getSyncedFlightMode());
        }
    }

    public boolean shouldUseLeftClaw() {
        return this.useLeftClawNext;
    }

    public void toggleClawSide() {
        this.useLeftClawNext = !this.useLeftClawNext;
    }

    @Override
    public byte getControlState() {
        return this.controlState;
    }

    @Override
    public void setControlState(byte controlState) {
        this.controlState = controlState;
        if (!this.m_9236_().f_46443_) {
            this.keybindHandler.setControlState(controlState);
        }
    }

    @Override
    public boolean canPlayerModifyControlState(Player player) {
        return player != null && this.m_21830_((LivingEntity)player);
    }

    @Override
    public byte buildClientControlState(boolean ascendDown, boolean descendDown, boolean attackDown, boolean primaryDown, boolean secondaryDown, boolean sneakDown) {
        byte state = 0;
        if (ascendDown) {
            state = (byte)(state | 1);
        }
        if (descendDown) {
            state = (byte)(state | 2);
        }
        if (attackDown) {
            state = (byte)(state | 4);
        }
        if (primaryDown) {
            state = (byte)(state | 8);
        }
        if (secondaryDown) {
            state = (byte)(state | 0x10);
        }
        if (sneakDown) {
            state = (byte)(state | 0x20);
        }
        return state;
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getAttackRiderAbility() {
        if (this.isPhaseTwoActive()) {
            return new RideableDragonBase.RiderAbilityBinding("nulljaw_bite2", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
        }
        return new RideableDragonBase.RiderAbilityBinding("nulljaw_bite", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("nulljaw_roar", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding("nulljaw_phase_shift", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        if (this.isPhaseTwoActive()) {
            return new RideableDragonBase.RiderAbilityBinding("nulljaw_claw", RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
        }
        return null;
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return NulljawAbilities.NULLJAW_PHASE_SHIFT;
    }

    public void onAnimationSound(SoundKeyframeEvent<Nulljaw> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    private void handleRiddenSwimming(Vec3 input) {
        Vec3 velocity = this.m_20184_();
        double swimSpeed = this.getSwimSpeed();
        if (this.isAccelerating()) {
            swimSpeed *= 1.6;
        }
        Vec3 desired = this.getVec3(input, swimSpeed, velocity);
        Vec3 blended = velocity.m_82549_(desired.m_82546_(velocity).m_82490_(0.28));
        double dragFactor = this.m_6109_() ? 0.92 : 0.94;
        blended = blended.m_82542_(dragFactor, 0.96, dragFactor);
        if (!this.isGoingUp() && !this.isGoingDown() && this.m_6688_() != null) {
            blended = blended.m_82542_(1.0, 0.0, 1.0);
        } else if (!this.isGoingUp() && !this.isGoingDown() && this.m_5448_() == null) {
            blended = blended.m_82520_(0.0, -0.01, 0.0);
        }
        this.m_20256_(blended);
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    @NotNull
    private Vec3 getVec3(Vec3 wishDir, double swimSpeed, Vec3 velocity) {
        double strafe = wishDir.f_82479_;
        double forward = wishDir.f_82481_;
        float yawRad = this.m_146908_() * ((float)Math.PI / 180);
        double sin = Math.sin(yawRad);
        double cos = Math.cos(yawRad);
        double worldX = strafe * cos - forward * sin;
        double worldZ = forward * cos + strafe * sin;
        double dx = worldX * 0.85 * swimSpeed;
        double dz = worldZ * 0.85 * swimSpeed;
        double dy = velocity.f_82480_;
        dy = this.isGoingUp() ? Math.min(swimSpeed, dy + 0.12 * swimSpeed) : (this.isGoingDown() ? Math.max(-swimSpeed, dy - 0.12 * swimSpeed) : (dy *= 0.9));
        Vec3 desired = new Vec3(dx, dy, dz);
        return desired;
    }

    @Override
    public boolean isDying() {
        return this.m_21223_() < this.m_21233_() * 0.1f;
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.f_19804_.m_135370_(DATA_GOING_UP);
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.f_19804_.m_135381_(DATA_GOING_UP, (Object)goingUp);
    }

    @Override
    public boolean isGoingDown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_GOING_DOWN);
    }

    @Override
    public void setGoingDown(boolean goingDown) {
        this.f_19804_.m_135381_(DATA_GOING_DOWN, (Object)goingDown);
    }

    private void tickSittingState() {
        if (!this.m_9236_().f_46443_ && this.m_20160_() && this.m_21827_()) {
            this.m_21839_(false);
        }
    }

    private void updateSittingProgress() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_21827_()) {
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else if (this.m_20160_()) {
            if (this.sitProgress != 0.0f) {
                this.sitProgress = 0.0f;
                this.prevSitProgress = 0.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
            }
        } else if (this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
            if (this.sitProgress < 0.0f) {
                this.sitProgress = 0.0f;
            }
            this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        }
    }

    private void tickClientSideUpdates() {
        if (this.m_9236_().f_46443_) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
        }
    }

    private void tickScreenShake() {
        if (this.m_9236_().f_46443_) {
            this.prevScreenShakeAmount = this.screenShakeAmount;
            this.screenShakeAmount = ((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
            return;
        }
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            float newAmount;
            this.screenShakeAmount = newAmount = Math.max(0.0f, this.screenShakeAmount - 0.02f);
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(newAmount));
        } else if (((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue() != 0.0f) {
            this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("PhaseTwo", this.isPhaseTwoActive());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("PhaseTwo")) {
            this.setPhaseTwoActive(tag.m_128471_("PhaseTwo"), false);
        }
    }

    public void m_7822_(byte eventId) {
        if (eventId == 6) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(eventId);
        }
    }

    public void setClientLocatorPosition(String name, Vec3 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public Vec3 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float currentAmount = ((Float)this.f_19804_.m_135370_(DATA_SCREEN_SHAKE_AMOUNT)).floatValue();
        return this.prevScreenShakeAmount + (currentAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 18.0;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        float clamped = Math.max(0.0f, intensity);
        if (clamped <= 0.0f) {
            return;
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.screenShakeAmount = Math.max(this.screenShakeAmount, clamped);
        this.f_19804_.m_135381_(DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    public boolean canBeBound() {
        return !this.isDying() && !this.isAccelerating() && !this.areRiderControlsLocked() && !this.isAbilityActive(NulljawAbilities.NULLJAW_PHASE_SHIFT);
    }

    @Override
    public boolean shouldEnterWater() {
        if (this.m_21827_() || this.m_20160_()) {
            return false;
        }
        if (this.m_6060_()) {
            return true;
        }
        if (this.m_21223_() < this.m_21233_() * 0.5f && this.m_5448_() != null) {
            return true;
        }
        return this.ticksOutOfWater > 1000 && this.m_217043_().m_188501_() < 0.08f;
    }

    @Override
    public boolean shouldLeaveWater() {
        LivingEntity owner;
        if (this.m_21827_()) {
            return false;
        }
        if (this.m_21824_() && this.m_269323_() != null && !(owner = this.m_269323_()).m_20069_() && this.m_20280_((Entity)owner) > 100.0) {
            return true;
        }
        return this.ticksInWater > 1200 && this.m_217043_().m_188501_() < 0.08f;
    }

    private static class RiftDrakeMoveControl
    extends MoveControl {
        public RiftDrakeMoveControl(Nulljaw drake) {
            super((Mob)drake);
        }

        public void m_8126_() {
            super.m_8126_();
        }
    }

    public static class RiftDrakeLookController
    extends LookControl {
        private final Nulljaw dragon;

        public RiftDrakeLookController(Nulljaw dragon) {
            super((Mob)dragon);
            this.dragon = dragon;
        }

        public void m_8128_() {
            if (!this.dragon.m_6084_()) {
                return;
            }
            LivingEntity rider = this.dragon.m_6688_();
            if (this.dragon.m_20160_() && rider != null) {
                if (this.dragon.m_6109_()) {
                    boolean allowRiderPitch;
                    float bodyYaw = rider.m_146908_();
                    this.dragon.m_146922_(bodyYaw);
                    this.dragon.m_5616_(bodyYaw);
                    this.dragon.f_20886_ = bodyYaw;
                    this.dragon.f_20883_ = bodyYaw;
                    this.dragon.f_20884_ = bodyYaw;
                    boolean bl = allowRiderPitch = !this.dragon.isPhaseTwoActive() || !this.dragon.areRiderControlsLocked();
                    if (allowRiderPitch) {
                        float pitch = Mth.m_14036_((float)rider.m_146909_(), (float)-45.0f, (float)45.0f);
                        this.dragon.m_146926_(pitch);
                        this.dragon.f_19860_ = pitch;
                    } else {
                        float eased = Mth.m_14148_((float)this.dragon.m_146909_(), (float)0.0f, (float)6.0f);
                        this.dragon.m_146926_(eased);
                        this.dragon.f_19860_ = eased;
                    }
                } else {
                    float serverPitch;
                    this.dragon.f_19860_ = serverPitch = this.dragon.m_146909_();
                }
                return;
            }
            super.m_8128_();
        }
    }
}

