/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.nulljaw.handlers;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public record NulljawAnimationHandler(Nulljaw drake) {
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.nulljaw.idle");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("animation.nulljaw.walk");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("animation.nulljaw.run");
    private static final RawAnimation IDLE2 = RawAnimation.begin().thenLoop("animation.nulljaw.idle2");
    private static final RawAnimation WALK2 = RawAnimation.begin().thenLoop("animation.nulljaw.walk2");
    private static final RawAnimation RUN2 = RawAnimation.begin().thenLoop("animation.nulljaw.run2");
    private static final RawAnimation SWIM_IDLE = RawAnimation.begin().thenLoop("animation.nulljaw.swim_idle");
    private static final RawAnimation SWIM_CRUISE = RawAnimation.begin().thenLoop("animation.nulljaw.swim_move");
    private static final RawAnimation SWIM_UP = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_up");
    private static final RawAnimation SWIM_DOWN = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_down");
    private static final RawAnimation SWIM_LEFT = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_left");
    private static final RawAnimation SWIM_RIGHT = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_right");
    private static final RawAnimation SWIM_NEUTRAL = RawAnimation.begin().thenLoop("animation.nulljaw.swimming_off");
    private static final RawAnimation SIT = RawAnimation.begin().thenLoop("animation.nulljaw.sit");
    private static final int MOVEMENT_TRANSITION_TICKS = 6;
    private static final int SWIM_TRANSITION_TICKS = 7;

    public void setupActionController(AnimationController<Nulljaw> actionController) {
        actionController.triggerableAnim("phase1", RawAnimation.begin().thenPlay("animation.nulljaw.phase1"));
        actionController.triggerableAnim("phase2", RawAnimation.begin().thenPlay("animation.nulljaw.phase2"));
        actionController.triggerableAnim("bite", RawAnimation.begin().thenPlay("animation.nulljaw.bite"));
        actionController.triggerableAnim("bite2", RawAnimation.begin().thenPlay("animation.nulljaw.bite2"));
        actionController.triggerableAnim("claw_left", RawAnimation.begin().thenPlay("animation.nulljaw.claw_left"));
        actionController.triggerableAnim("claw_right", RawAnimation.begin().thenPlay("animation.nulljaw.claw_right"));
        actionController.triggerableAnim("horn_gore", RawAnimation.begin().thenPlay("animation.nulljaw.horn_gore"));
        actionController.triggerableAnim("roar", RawAnimation.begin().thenPlay("animation.nulljaw.roar"));
        actionController.triggerableAnim("roar2", RawAnimation.begin().thenPlay("animation.nulljaw.roar2"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.nulljaw.eat"));
    }

    public void setupAmbientController(AnimationController<Nulljaw> ambientController) {
        ambientController.triggerableAnim("grumble1", RawAnimation.begin().thenPlay("animation.nulljaw.grumble1"));
        ambientController.triggerableAnim("grumble2", RawAnimation.begin().thenPlay("animation.nulljaw.grumble2"));
        ambientController.triggerableAnim("grumble3", RawAnimation.begin().thenPlay("animation.nulljaw.grumble3"));
    }

    public PlayState movementPredicate(AnimationState<Nulljaw> state) {
        boolean isSwimming = this.drake.m_6069_();
        boolean isInWater = this.drake.m_20069_();
        boolean isNavigating = this.drake.m_21573_().m_26572_() && this.drake.m_21573_().m_26570_() != null;
        double horizontalSpeedSq = this.drake.m_20184_().m_165925_();
        double totalSpeedSq = this.drake.m_20184_().m_82556_();
        boolean isMovingLand = state.isMoving() || horizontalSpeedSq > 0.008;
        AnimationController controller = state.getController();
        controller.setAnimationSpeed(1.0);
        if (isSwimming || isInWater) {
            boolean isSwimmingMoving;
            controller.transitionLength(7);
            if (this.drake.m_20160_() && this.drake.m_6688_() != null) {
                float riderFwd = Math.abs(this.drake.getLastRiderForward());
                float riderStr = Math.abs(this.drake.getLastRiderStrafe());
                boolean riderMoving = riderFwd > 0.05f || riderStr > 0.05f;
                isSwimmingMoving = riderMoving || totalSpeedSq > 0.004;
            } else {
                isSwimmingMoving = this.drake.isSwimmingMoving() || isNavigating || totalSpeedSq > 0.002 || Math.abs(this.drake.f_20902_) > 0.01f || Math.abs(this.drake.f_20901_) > 0.01f;
            }
            RawAnimation swimAnim = isSwimmingMoving ? SWIM_CRUISE : SWIM_IDLE;
            state.setAnimation(swimAnim);
        } else if (this.drake.getSitProgress() > 0.5f) {
            controller.transitionLength(4);
            state.setAnimation(SIT);
        } else {
            Player player;
            LivingEntity livingEntity;
            int groundState = this.drake.getEffectiveGroundState();
            boolean phaseTwo = this.drake.isPhaseTwoActive();
            boolean abilityActive = this.drake.getActiveAbility() != null;
            boolean riderControlled = this.drake.m_20160_() && (livingEntity = this.drake.m_6688_()) instanceof Player && this.drake.m_21830_((LivingEntity)(player = (Player)livingEntity));
            int baseTransition = 6;
            if (riderControlled) {
                baseTransition = Math.max(3, baseTransition - 2);
            }
            if (abilityActive) {
                baseTransition = Math.max(2, baseTransition - 1);
            }
            if (groundState == 2) {
                controller.transitionLength(baseTransition);
                state.setAnimation(phaseTwo ? RUN2 : RUN);
            } else if (groundState == 1 || isMovingLand) {
                controller.transitionLength(Math.max(3, baseTransition + 1));
                state.setAnimation(phaseTwo ? WALK2 : WALK);
            } else {
                controller.transitionLength(Math.max(3, baseTransition + (abilityActive ? 2 : 0)));
                state.setAnimation(phaseTwo ? IDLE2 : IDLE);
            }
        }
        return PlayState.CONTINUE;
    }

    public PlayState swimDirectionPredicate(AnimationState<Nulljaw> state) {
        AnimationController controller = state.getController();
        controller.transitionLength(7);
        if (!this.drake.m_6069_()) {
            state.setAndContinue(SWIM_NEUTRAL);
            return PlayState.CONTINUE;
        }
        if (this.drake.isSwimmingUp()) {
            state.setAndContinue(SWIM_UP);
            return PlayState.CONTINUE;
        }
        if (this.drake.isSwimmingDown()) {
            state.setAndContinue(SWIM_DOWN);
            return PlayState.CONTINUE;
        }
        int yawDir = this.drake.getSwimTurnDirection();
        if (yawDir < 0) {
            state.setAndContinue(SWIM_LEFT);
        } else if (yawDir > 0) {
            state.setAndContinue(SWIM_RIGHT);
        } else {
            state.setAndContinue(SWIM_NEUTRAL);
        }
        return PlayState.CONTINUE;
    }

    public PlayState actionPredicate(AnimationState<Nulljaw> state) {
        state.getController().transitionLength(5);
        return PlayState.STOP;
    }

    public PlayState ambientPredicate(AnimationState<Nulljaw> state) {
        state.getController().transitionLength(3);
        return PlayState.STOP;
    }

    public void configureMovementBlend(AnimationController<Nulljaw> controller) {
        controller.transitionLength(6);
    }

    public void configureSwimBlend(AnimationController<Nulljaw> controller) {
        controller.transitionLength(7);
    }
}

