/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.raevyx;

import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningArcData;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.common.registry.raevyx.RaevyxAbilities;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtByTargetGoal;
import com.leon.saintsdragons.server.ai.goals.base.DragonOwnerHurtTargetGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxAttackGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxBreedGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxCombatGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxDodgeGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFlightGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFollowOwnerGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxFollowParentGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxGroundWanderGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxMoveGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxPanicGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxRestGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxSleepGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxStateGoal;
import com.leon.saintsdragons.server.ai.goals.raevyx.RaevyxTemptGoal;
import com.leon.saintsdragons.server.ai.navigation.DragonFlightMoveHelper;
import com.leon.saintsdragons.server.ai.navigation.DragonPathNavigateGround;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.DragonGender;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityProfile;
import com.leon.saintsdragons.server.entity.conductivity.ElectricalConductivityState;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxFlightController;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxPhysicsController;
import com.leon.saintsdragons.server.entity.controller.raevyx.RaevyxRiderController;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxAnimationHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxConstantsHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxInteractionHandler;
import com.leon.saintsdragons.server.entity.dragons.raevyx.handlers.RaevyxSoundProfile;
import com.leon.saintsdragons.server.entity.handler.DragonKeybindHandler;
import com.leon.saintsdragons.server.entity.handler.DragonSoundHandler;
import com.leon.saintsdragons.server.entity.interfaces.DragonCombatCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonControlStateHolder;
import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSleepCapable;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import com.leon.saintsdragons.server.entity.interfaces.ElectricalConductivityCapable;
import com.leon.saintsdragons.server.entity.interfaces.ShakesScreen;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;

public class Raevyx
extends RideableDragonBase
implements FlyingAnimal,
RangedAttackMob,
DragonCombatCapable,
DragonFlightCapable,
DragonSleepCapable,
ShakesScreen,
SoundHandledDragon,
DragonControlStateHolder,
ElectricalConductivityCapable {
    public static final float MAX_BEAM_YAW_DEG = 40.0f;
    public static final float MAX_BEAM_PITCH_DEG = 50.0f;
    public static final float[] IDLE_NECK_WEIGHTS = new float[]{0.1f, 0.15f, 0.2f, 0.25f};
    public static final float[] BEAM_NECK_WEIGHTS = new float[]{0.18f, 0.22f, 0.26f, 0.3f};
    private double cachedOwnerDistance = Double.MAX_VALUE;
    private int ownerDistanceCacheTime = -1;
    private List<Projectile> cachedNearbyProjectiles = new CopyOnWriteArrayList<Projectile>();
    private int nearbyProjectilesCacheTime = -1;
    private int projectileCacheIntervalTicks = 3;
    private int emptyProjectileScans = 0;
    private double cachedHorizontalSpeed = 0.0;
    private int horizontalSpeedCacheTime = -1;
    private static final double RIDER_GLIDE_ALTITUDE_THRESHOLD = 40.0;
    private static final double RIDER_GLIDE_ALTITUDE_EXIT = 30.0;
    private static final double RIDER_LANDING_BLEND_ALTITUDE = 8.5;
    private static final int RIDER_LANDING_BLEND_DURATION = 5;
    private boolean inHighAltitudeGlide = false;
    private static final Map<String, DragonEntity.VocalEntry> VOCAL_ENTRIES = new DragonEntity.VocalEntryBuilder().add("grumble1", "action", "animation.raevyx.grumble1", (Supplier<SoundEvent>)ModSounds.RAEVYX_GRUMBLE_1, 0.8f, 0.95f, 0.1f, false, false, false).add("grumble2", "action", "animation.raevyx.grumble2", (Supplier<SoundEvent>)ModSounds.RAEVYX_GRUMBLE_2, 0.8f, 0.95f, 0.1f, false, false, false).add("grumble3", "action", "animation.raevyx.grumble3", (Supplier<SoundEvent>)ModSounds.RAEVYX_GRUMBLE_3, 0.8f, 0.95f, 0.1f, false, false, false).add("purr", "action", "animation.raevyx.purr", (Supplier<SoundEvent>)ModSounds.RAEVYX_PURR, 0.8f, 1.05f, 0.05f, true, false, true).add("snort", "action", "animation.raevyx.snort", (Supplier<SoundEvent>)ModSounds.RAEVYX_SNORT, 0.9f, 0.9f, 0.2f, false, false, false).add("chuff", "action", "animation.raevyx.chuff", (Supplier<SoundEvent>)ModSounds.RAEVYX_CHUFF, 0.9f, 0.9f, 0.2f, false, false, false).add("content", "action", "animation.raevyx.content", (Supplier<SoundEvent>)ModSounds.RAEVYX_CONTENT, 0.8f, 1.0f, 0.1f, true, false, true).add("excited", "action", "", (Supplier<SoundEvent>)ModSounds.RAEVYX_EXCITED, 1.0f, 1.0f, 0.3f, false, false, false).add("annoyed", "action", "animation.raevyx.annoyed", (Supplier<SoundEvent>)ModSounds.RAEVYX_ANNOYED, 1.0f, 0.9f, 0.2f, false, false, false).add("growl_warning", "action", "", (Supplier<SoundEvent>)ModSounds.RAEVYX_GROWL_WARNING, 1.2f, 0.8f, 0.4f, false, false, false).add("roar", "action", "animation.raevyx.roar", (Supplier<SoundEvent>)ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("roar_ground", "action", "animation.raevyx.roar_ground", (Supplier<SoundEvent>)ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("roar_air", "action", "animation.raevyx.roar_air", (Supplier<SoundEvent>)ModSounds.RAEVYX_ROAR, 1.4f, 0.9f, 0.15f, false, false, false).add("raevyx_hurt", "hurt", "animation.raevyx.hurt", (Supplier<SoundEvent>)ModSounds.RAEVYX_HURT, 1.2f, 0.95f, 0.1f, true, true, true).add("raevyx_die", "action", "animation.raevyx.die", (Supplier<SoundEvent>)ModSounds.RAEVYX_DIE, 1.5f, 0.95f, 0.1f, false, true, true).build();
    private boolean manualSitCommand = false;
    private boolean commandChangeManual = false;
    private int riderLandingBlendTicks = 0;
    private int ambientSoundTimer;
    private int nextAmbientSoundDelay;
    private float prevScreenShakeAmount = 0.0f;
    private float screenShakeAmount = 0.0f;
    public int timeFlying = 0;
    public boolean landingFlag = false;
    public int landingTimer = 0;
    int runningTicks = 0;
    private float bankSmoothedYaw = 0.0f;
    private int bankHoldTicks = 0;
    private int bankDir = 0;
    private float bankAngle = 0.0f;
    private float prevBankAngle = 0.0f;
    private float pitchSmoothedPitch = 0.0f;
    private int pitchHoldTicks = 0;
    private int pitchDir = 0;
    boolean dodging = false;
    int dodgeTicksLeft = 0;
    Vec3 dodgeVec = Vec3.f_82478_;
    public int attackTicks = 0;
    public int attackCooldown = 0;
    private boolean allowGroundBeamDuringStorm = false;
    private int sitTransitionTicks = 0;
    private boolean isSittingDown = false;
    private boolean isStandingUp = false;
    private int sleepTransitionTicks = 0;
    private int sleepAmbientCooldownTicks = 0;
    private int sleepReentryCooldownTicks = 0;
    private int sleepCancelTicks = 0;
    private boolean sleepLocked = false;
    private int sleepCommandSnapshot = -1;
    private int postLoadAirStabilizeTicks = 0;
    private int followFailsafeCooldown = 0;
    private int postStandUnlockTicks = 0;
    private int riderTakeoffTicks = 0;
    private long lastLandingGameTime = Long.MIN_VALUE;
    public final GroundPathNavigation groundNav;
    public final FlyingPathNavigation airNav;
    public boolean usingAirNav = false;
    public final RaevyxFlightController flightController;
    private final RaevyxInteractionHandler lightningInteractionHandler;
    private final RaevyxAnimationHandler animationHandler;
    private final DragonKeybindHandler keybindHandler;
    private final RaevyxRiderController riderController;
    private final DragonSoundHandler soundHandler;
    private final Map<String, Vec3> clientLocatorCache = new ConcurrentHashMap<String, Vec3>();
    private final RaevyxPhysicsController animationController = new RaevyxPhysicsController(this);
    private int hurtSoundCooldown = 0;
    private Vec3 prevClientBeamEnd = null;
    private Vec3 clientBeamEnd = null;
    private Vec3 beamLookLerp = null;
    private Vec3 beamAimDir = null;
    private float beamYawOffsetRad = 0.0f;
    private float beamPitchOffsetRad = 0.0f;
    private byte controlState = 0;
    private boolean wasVehicleLastTick = false;
    private int superchargeTicks = 0;
    private int tempInvulnTicks = 0;
    private int superchargeVfxCooldown = 0;
    private int riderControlLockTicks = 0;
    private int takeoffLockTicks = 0;
    private final Map<Integer, Long> recentAggroIds = new ConcurrentHashMap<Integer, Long>();
    private int aggroGrowlCooldown = 0;
    private static final ElectricalConductivityProfile CONDUCTIVITY_PROFILE = new ElectricalConductivityProfile(1.0f, 0.5f, 0.0f, 1.0, 0.3, 0.0);

    @Override
    public void setCommand(int command) {
        int previous = super.getCommand();
        super.setCommand(command);
        this.manualSitCommand = command == 1 ? this.commandChangeManual || this.manualSitCommand : false;
        this.commandChangeManual = false;
    }

    public void setCommandManual(int command) {
        this.commandChangeManual = true;
        this.setCommand(command);
    }

    public void setCommandAuto(int command) {
        this.commandChangeManual = false;
        this.setCommand(command);
    }

    private boolean getBooleanData(EntityDataAccessor<Boolean> accessor) {
        return (Boolean)this.f_19804_.m_135370_(accessor);
    }

    private void setBooleanData(EntityDataAccessor<Boolean> accessor, boolean value) {
        this.f_19804_.m_135381_(accessor, (Object)value);
    }

    private int getIntegerData(EntityDataAccessor<Integer> accessor) {
        return (Integer)this.f_19804_.m_135370_(accessor);
    }

    private void setIntegerData(EntityDataAccessor<Integer> accessor, int value) {
        this.f_19804_.m_135381_(accessor, (Object)value);
    }

    private float getFloatData(EntityDataAccessor<Float> accessor) {
        return ((Float)this.f_19804_.m_135370_(accessor)).floatValue();
    }

    private void setFloatData(EntityDataAccessor<Float> accessor, float value) {
        this.f_19804_.m_135381_(accessor, (Object)Float.valueOf(value));
    }

    public long getLastLandingGameTime() {
        return this.lastLandingGameTime;
    }

    @Override
    public void markLandedNow() {
        if (!this.m_9236_().f_46443_) {
            this.lastLandingGameTime = this.m_9236_().m_46467_();
        }
    }

    public boolean m_21825_() {
        return super.m_21825_() && !this.m_20160_() && !this.m_20159_() && !this.m_29443_();
    }

    public float getGlidingFraction() {
        return this.animationController.glidingFraction;
    }

    public float getFlappingFraction() {
        return this.animationController.flappingFraction;
    }

    public float getHoveringFraction() {
        return this.animationController.hoveringFraction;
    }

    public Raevyx(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.m_274367_(1.25f);
        this.groundNav = new DragonPathNavigateGround((Mob)this, level);
        this.airNav = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(@Nonnull BlockPos pos) {
                return !this.f_26495_.m_8055_(pos.m_7495_()).m_60795_();
            }
        };
        this.airNav.m_26440_(false);
        this.airNav.m_7008_(false);
        this.airNav.m_26443_(false);
        this.f_21344_ = this.groundNav;
        this.f_21342_ = new MoveControl((Mob)this);
        this.f_21365_ = new DragonLookController(this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.flightController = new RaevyxFlightController(this);
        this.lightningInteractionHandler = new RaevyxInteractionHandler(this);
        this.animationHandler = new RaevyxAnimationHandler(this);
        this.keybindHandler = new DragonKeybindHandler(this);
        this.riderController = new RaevyxRiderController(this);
        this.soundHandler = new DragonSoundHandler(this);
        RandomSource rng = this.m_217043_();
        this.ambientSoundTimer = rng.m_188503_(80);
        this.nextAmbientSoundDelay = 200 + rng.m_188503_(400);
    }

    @Override
    public DragonSoundHandler getSoundHandler() {
        return this.soundHandler;
    }

    public void setClientLocatorPosition(String name, Vec3 pos) {
        if (name == null || pos == null) {
            return;
        }
        this.clientLocatorCache.put(name, pos);
    }

    @Override
    public Vec3 getClientLocatorPosition(String name) {
        if (name == null) {
            return null;
        }
        return this.clientLocatorCache.get(name);
    }

    @Override
    public boolean isStayOrSitMuted() {
        return this.m_21827_() || this.m_21825_();
    }

    protected void m_7355_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 180.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 8.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.defineRideableDragonData();
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAMING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_RIDER_LANDING_BLEND, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_RIDER_LOCKED, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_SLEEPING_ENTERING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_SLEEPING_EXITING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_END_SET, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_END_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_END_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_END_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_START_SET, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_START_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_START_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_BEAM_START_Z, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_SLEEPING, (Object)false);
    }

    @Override
    protected void defineRideableDragonData() {
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_FLYING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_TAKEOFF, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_HOVERING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_LANDING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_RUNNING, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE, (Object)0);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_FLIGHT_MODE, (Object)-1);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_RIDER_FORWARD, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_RIDER_STRAFE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_GOING_UP, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_GOING_DOWN, (Object)false);
        this.f_19804_.m_135372_(RaevyxConstantsHandler.DATA_ACCELERATING, (Object)false);
    }

    @Override
    protected EntityDataAccessor<Float> getRiderForwardAccessor() {
        return RaevyxConstantsHandler.DATA_RIDER_FORWARD;
    }

    @Override
    protected EntityDataAccessor<Float> getRiderStrafeAccessor() {
        return RaevyxConstantsHandler.DATA_RIDER_STRAFE;
    }

    @Override
    protected EntityDataAccessor<Integer> getGroundMoveStateAccessor() {
        return RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE;
    }

    @Override
    protected EntityDataAccessor<Integer> getFlightModeAccessor() {
        return RaevyxConstantsHandler.DATA_FLIGHT_MODE;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingUpAccessor() {
        return RaevyxConstantsHandler.DATA_GOING_UP;
    }

    @Override
    protected EntityDataAccessor<Boolean> getGoingDownAccessor() {
        return RaevyxConstantsHandler.DATA_GOING_DOWN;
    }

    @Override
    protected EntityDataAccessor<Boolean> getAcceleratingAccessor() {
        return RaevyxConstantsHandler.DATA_ACCELERATING;
    }

    @Override
    public <T extends DragonEntity> DragonAbility<T> getActiveAbility() {
        return this.combatManager.getActiveAbility();
    }

    @Override
    public boolean canUseAbility() {
        return !this.m_6162_() && this.combatManager.canUseAbility();
    }

    public void useRidingAbility(String abilityName) {
        Player p;
        if (this.m_6162_()) {
            return;
        }
        if (abilityName == null || abilityName.isEmpty()) {
            return;
        }
        LivingEntity cp = this.m_6688_();
        if (!(cp instanceof LivingEntity)) {
            return;
        }
        if (this.areRiderControlsLocked()) {
            return;
        }
        if (this.m_21824_() && cp instanceof Player && !this.m_21830_((LivingEntity)(p = (Player)cp))) {
            return;
        }
        DragonAbilityType<?, ?> type = AbilityRegistry.get(abilityName);
        if (type != null) {
            this.combatManager.tryUseAbility(type);
        }
    }

    @Override
    public <T extends DragonEntity> void tryActivateAbility(DragonAbilityType<T, ?> abilityType) {
        if (this.m_6162_()) {
            return;
        }
        super.tryActivateAbility(abilityType);
    }

    @Override
    protected boolean isRiderInputLocked(Player player) {
        return this.areRiderControlsLocked();
    }

    @Override
    protected void applyRiderVerticalInput(Player player, boolean goingUp, boolean goingDown, boolean locked) {
        if (this.m_29443_()) {
            this.setGoingUp(goingUp);
            this.setGoingDown(goingDown);
        } else {
            this.setGoingUp(false);
            this.setGoingDown(false);
        }
    }

    @Override
    protected void applyRiderMovementInput(Player player, float forward, float strafe, float yaw, boolean locked) {
        float fwd = this.applyInputDeadzone(forward);
        float str = this.applyInputDeadzone(strafe);
        this.setLastRiderForward(fwd);
        this.setLastRiderStrafe(str);
        if (!this.m_29443_()) {
            int moveState = 0;
            float magnitude = Math.abs(fwd) + Math.abs(str);
            if (magnitude > 0.05f) {
                int n = moveState = this.isAccelerating() ? 2 : 1;
            }
            if ((Integer)this.m_20088_().m_135370_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE) != moveState) {
                this.m_20088_().m_135381_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE, (Object)moveState);
                this.syncAnimState(moveState, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    protected void handleRiderAction(ServerPlayer player, DragonRiderAction action, String abilityName, boolean locked) {
        if (action == null) {
            return;
        }
        switch (action) {
            case TAKEOFF_REQUEST: {
                if (locked) break;
                this.requestRiderTakeoff();
                break;
            }
            case ACCELERATE: {
                if (locked) break;
                this.setAccelerating(true);
                break;
            }
            case STOP_ACCELERATE: {
                this.setAccelerating(false);
                break;
            }
            case ABILITY_USE: {
                if (abilityName == null || abilityName.isEmpty()) break;
                this.useRidingAbility(abilityName);
                break;
            }
            case ABILITY_STOP: {
                DragonAbility active;
                if (abilityName == null || abilityName.isEmpty() || (active = this.getActiveAbility()) == null) break;
                this.forceEndActiveAbility();
                break;
            }
        }
    }

    public void requestRiderTakeoff() {
        this.riderController.requestRiderTakeoff();
    }

    @Override
    public Vec3 getHeadPosition() {
        return this.m_146892_();
    }

    @Override
    public Vec3 getMouthPosition() {
        Vec3 mouthLoc = this.getClientLocatorPosition("mouth_origin");
        if (mouthLoc != null) {
            return mouthLoc;
        }
        return this.computeHeadMouthOrigin(1.0f);
    }

    public Vec3 computeHeadMouthOrigin(float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)this.f_19854_, (double)this.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)this.f_19855_, (double)this.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)this.f_19856_, (double)this.m_20189_());
        float yawDeg = Mth.m_14179_((float)partialTicks, (float)this.f_20886_, (float)this.f_20885_);
        float pitchDeg = Mth.m_14179_((float)partialTicks, (float)this.f_19860_, (float)this.m_146909_());
        double yaw = Math.toRadians(yawDeg);
        double pitch = Math.toRadians(pitchDeg);
        double R = -0.03125;
        double U = 0.4125;
        double F = 0.915625;
        double cp = Math.cos(pitch);
        double sp = Math.sin(pitch);
        double up = U * cp - F * sp;
        double fwd = U * sp + F * cp;
        double cy = Math.cos(yaw);
        double sy = Math.sin(yaw);
        double offX = R * cy - fwd * sy;
        double offZ = R * sy + fwd * cy;
        return new Vec3(x + offX, y + up, z + offZ);
    }

    public void forceEndActiveAbility() {
        this.combatManager.forceEndActiveAbility();
    }

    public boolean isBeaming() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_BEAMING);
    }

    public void setBeaming(boolean beaming) {
        boolean wasBeaming = this.getBooleanData(RaevyxConstantsHandler.DATA_BEAMING);
        this.setBooleanData(RaevyxConstantsHandler.DATA_BEAMING, beaming);
        if (!beaming || !wasBeaming) {
            this.resetBeamAim();
        }
    }

    public void setBeamEndPosition(@Nullable Vec3 pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_END_SET, (Object)false);
        } else {
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_END_SET, (Object)true);
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_END_X, (Object)Float.valueOf((float)pos.f_82479_));
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_END_Y, (Object)Float.valueOf((float)pos.f_82480_));
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_END_Z, (Object)Float.valueOf((float)pos.f_82481_));
        }
    }

    public Vec3 getBeamEndPosition() {
        if (!this.getBooleanData(RaevyxConstantsHandler.DATA_BEAM_END_SET)) {
            return null;
        }
        return new Vec3((double)this.getFloatData(RaevyxConstantsHandler.DATA_BEAM_END_X), (double)this.getFloatData(RaevyxConstantsHandler.DATA_BEAM_END_Y), (double)this.getFloatData(RaevyxConstantsHandler.DATA_BEAM_END_Z));
    }

    public Vec3 getClientBeamEndPosition(float partialTicks) {
        if (this.clientBeamEnd != null && this.prevClientBeamEnd != null) {
            Vec3 d = this.clientBeamEnd.m_82546_(this.prevClientBeamEnd);
            return this.prevClientBeamEnd.m_82549_(d.m_82490_((double)partialTicks));
        }
        Vec3 serverPos = this.getBeamEndPosition();
        return this.clientBeamEnd != null ? this.clientBeamEnd : (serverPos != null ? serverPos : Vec3.f_82478_);
    }

    public void setBeamStartPosition(@Nullable Vec3 pos) {
        if (pos == null) {
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_START_SET, (Object)false);
        } else {
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_START_SET, (Object)true);
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_START_X, (Object)Float.valueOf((float)pos.f_82479_));
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_START_Y, (Object)Float.valueOf((float)pos.f_82480_));
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_BEAM_START_Z, (Object)Float.valueOf((float)pos.f_82481_));
        }
    }

    public Vec3 getBeamStartPosition() {
        if (!this.getBooleanData(RaevyxConstantsHandler.DATA_BEAM_START_SET)) {
            return null;
        }
        return new Vec3((double)this.getFloatData(RaevyxConstantsHandler.DATA_BEAM_START_X), (double)this.getFloatData(RaevyxConstantsHandler.DATA_BEAM_START_Y), (double)this.getFloatData(RaevyxConstantsHandler.DATA_BEAM_START_Z));
    }

    public void switchToAirNavigation() {
        if (!this.usingAirNav) {
            this.f_21344_ = this.airNav;
            this.f_21342_ = new DragonFlightMoveHelper(this);
            this.usingAirNav = true;
        }
    }

    public void switchToGroundNavigation() {
        if (this.usingAirNav) {
            this.f_21344_ = this.groundNav;
            this.f_21342_ = new MoveControl((Mob)this);
            this.usingAirNav = false;
        }
    }

    @NotNull
    protected PathNavigation m_6037_(@Nonnull Level level) {
        return new DragonPathNavigateGround((Mob)this, level);
    }

    @Override
    public void setFlying(boolean flying) {
        if (flying && this.m_6162_()) {
            flying = false;
        }
        if (!flying && this.m_20160_() && !this.m_21827_() && !this.m_20096_()) {
            return;
        }
        boolean wasFlying = this.m_29443_();
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_FLYING, (Object)flying);
        if (wasFlying != flying) {
            this.setAccelerating(false);
        }
        if (wasFlying != flying) {
            if (flying) {
                this.switchToAirNavigation();
                this.setRunning(false);
            } else {
                this.switchToGroundNavigation();
            }
        }
    }

    @Override
    public void setTakeoff(boolean takeoff) {
        if (takeoff && this.m_6162_()) {
            takeoff = false;
        }
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_TAKEOFF, (Object)takeoff);
    }

    @Override
    public void setHovering(boolean hovering) {
        if (hovering && this.m_6162_()) {
            hovering = false;
        }
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_HOVERING, (Object)hovering);
    }

    @Override
    public boolean isWalking() {
        int s;
        if (this.m_29443_()) {
            return false;
        }
        int n = s = this.m_9236_().f_46443_ ? this.getEffectiveGroundState() : ((Integer)this.f_19804_.m_135370_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE)).intValue();
        if (s == 1) {
            return true;
        }
        if (s == 2) {
            return false;
        }
        if (this.m_9236_().f_46443_ && super.getEffectiveGroundState() < 0) {
            double speed = this.m_20184_().m_165925_();
            return speed > 0.004 && speed <= 0.1;
        }
        return false;
    }

    @Override
    public boolean isActuallyRunning() {
        int s;
        if (this.m_29443_()) {
            return false;
        }
        int n = s = this.m_9236_().f_46443_ ? this.getEffectiveGroundState() : ((Integer)this.f_19804_.m_135370_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE)).intValue();
        if (s == 2) {
            return true;
        }
        if (s == 1) {
            return false;
        }
        return this.getBooleanData(RaevyxConstantsHandler.DATA_RUNNING);
    }

    @Override
    public void setLanding(boolean landing) {
        if (landing && this.m_20160_()) {
            return;
        }
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_LANDING, (Object)landing);
        if (landing) {
            this.landingTimer = 0;
            this.m_21573_().m_26573_();
            this.setTakeoff(true);
            this.landingFlag = true;
            if (!this.m_9236_().f_46443_) {
                this.flightController.planSmartLanding();
            }
        } else {
            this.landingFlag = false;
        }
    }

    public int getAttackState() {
        return this.getIntegerData(RaevyxConstantsHandler.DATA_ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.attackTicks = 0;
        this.setIntegerData(RaevyxConstantsHandler.DATA_ATTACK_STATE, state);
        this.m_9236_().m_7605_((Entity)this, (byte)(-state));
    }

    public boolean isInAttackState() {
        return this.getAttackState() != 0;
    }

    public boolean canAttack() {
        return !this.m_6162_() && this.attackCooldown <= 0 && !this.isInAttackState();
    }

    @Override
    public int getSyncedFlightMode() {
        return this.getIntegerData(RaevyxConstantsHandler.DATA_FLIGHT_MODE);
    }

    @Override
    public int getGroundMoveState() {
        return this.getIntegerData(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE);
    }

    @Override
    protected int getFlightMode() {
        if (!this.m_29443_()) {
            this.inHighAltitudeGlide = false;
            return -1;
        }
        if (this.isTakeoff()) {
            return 3;
        }
        if (this.isHovering()) {
            return 2;
        }
        if (this.isLanding()) {
            return 2;
        }
        if (this.m_21824_() && this.m_20160_()) {
            Player player;
            LivingEntity rider = this.m_6688_();
            if (rider instanceof Player && this.m_21830_((LivingEntity)(player = (Player)rider))) {
                int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mth.m_14107_((double)this.m_20185_()), Mth.m_14107_((double)this.m_20189_()));
                double altitudeAboveTerrain = this.m_20186_() - (double)groundY;
                if (this.inHighAltitudeGlide) {
                    if (altitudeAboveTerrain > 30.0) {
                        return 0;
                    }
                    this.inHighAltitudeGlide = false;
                    return 1;
                }
                if (altitudeAboveTerrain > 40.0) {
                    this.inHighAltitudeGlide = true;
                    return 0;
                }
                return 1;
            }
        } else {
            this.inHighAltitudeGlide = false;
        }
        double horizontalSpeedSqr = this.m_20184_().m_165925_();
        double yDelta = this.m_20186_() - this.f_19855_;
        if (Math.abs(yDelta) < 0.06 && horizontalSpeedSqr > 0.01) {
            return 0;
        }
        return 1;
    }

    @Override
    protected boolean isDragonFlying() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_FLYING);
    }

    @Override
    public boolean isTakeoff() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_TAKEOFF);
    }

    @Override
    public boolean isLanding() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_LANDING);
    }

    @Override
    public boolean isHovering() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_HOVERING);
    }

    @Override
    public boolean isRunning() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_RUNNING);
    }

    @Override
    public void setRunning(boolean running) {
        this.setBooleanData(RaevyxConstantsHandler.DATA_RUNNING, running);
        if (running) {
            this.runningTicks = 0;
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.45);
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22279_)).m_22100_(0.25);
        }
    }

    @Override
    public void tickAnimationStates() {
    }

    @Override
    public int getEffectiveGroundState() {
        return super.getEffectiveGroundState();
    }

    public double getYDelta() {
        return this.m_20186_() - this.f_19855_;
    }

    public void setGroundMoveStateFromAI(int state) {
        if (!this.m_9236_().f_46443_) {
            int s = Math.max(0, Math.min(2, state));
            if ((Integer)this.f_19804_.m_135370_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE) != s) {
                this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_GROUND_MOVE_STATE, (Object)s);
                this.syncAnimState(s, this.getSyncedFlightMode());
            }
        }
    }

    @Override
    public byte getControlState() {
        return this.controlState;
    }

    @Override
    public void setControlState(byte controlState) {
        this.controlState = controlState;
        if (!this.m_9236_().f_46443_) {
            this.keybindHandler.setControlState(controlState);
        }
    }

    @Override
    public boolean canPlayerModifyControlState(Player player) {
        return player != null && this.m_21830_((LivingEntity)player);
    }

    @Override
    @Nullable
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    @Override
    public boolean canOwnerCommand(Player ownerPlayer) {
        return ownerPlayer.m_6047_();
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getTertiaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_LIGHTNING_BEAM.getName(), RideableDragonBase.RiderAbilityBinding.Activation.HOLD);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getPrimaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_ROAR.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public RideableDragonBase.RiderAbilityBinding getSecondaryRiderAbility() {
        return new RideableDragonBase.RiderAbilityBinding(RaevyxAbilities.RAEVYX_SUMMON_STORM.getName(), RideableDragonBase.RiderAbilityBinding.Activation.PRESS);
    }

    @Override
    public byte buildClientControlState(boolean ascendDown, boolean descendDown, boolean attackDown, boolean primaryDown, boolean secondaryDown, boolean sneakDown) {
        byte state = 0;
        if (ascendDown) {
            state = (byte)(state | 1);
        }
        if (descendDown) {
            state = (byte)(state | 2);
        }
        if (attackDown) {
            state = (byte)(state | 4);
        }
        if (primaryDown) {
            state = (byte)(state | 8);
        }
        if (secondaryDown) {
            state = (byte)(state | 0x10);
        }
        if (sneakDown) {
            state = (byte)(state | 0x20);
        }
        return state;
    }

    public double m_6048_() {
        return this.riderController.getPassengersRidingOffset();
    }

    protected void m_19956_(@Nonnull Entity passenger, @Nonnull Entity.MoveFunction moveFunction) {
        this.riderController.positionRider(passenger, moveFunction);
    }

    @NotNull
    public Vec3 m_7688_(@Nonnull LivingEntity passenger) {
        return this.riderController.getDismountLocationForPassenger(passenger);
    }

    public boolean isDodging() {
        return this.dodging;
    }

    public void beginDodge(Vec3 vec, int ticks) {
        this.dodging = true;
        this.dodgeVec = vec;
        this.dodgeTicksLeft = Math.max(1, ticks);
        this.m_21573_().m_26573_();
        this.f_19812_ = true;
    }

    @Override
    public void m_8119_() {
        this.animationController.tick();
        super.m_8119_();
        this.tickScreenShake();
        this.tickSittingState();
        this.tickSound();
        this.tickPostLoadStabilization();
        this.tickRiderTakeoff();
        this.tickControllers();
        this.tickHurtSoundCooldown();
        this.tickAttackState();
        if (!this.m_9236_().f_46443_) {
            if (this.m_29443_() && this.m_6688_() != null && !this.isLanding() && !this.isBeaming() && !this.isTakeoff() && this.isHovering()) {
                this.setHovering(false);
            }
            this.tickRiderControlLock();
            this.tickRiderControlLockMovement();
            this.handleAmbientSounds();
        }
        if (!this.m_9236_().f_46443_) {
            this.tickSuperchargeTimer();
            this.tickTempInvulnTimer();
            this.tickSuperchargeVfx();
            this.tickSleepTransition();
            this.tickSleepCooldowns();
            this.tickMountingState();
            this.tickFollowFailsafe();
            if (this.postStandUnlockTicks > 0) {
                --this.postStandUnlockTicks;
            }
        }
        this.tickBankingLogic();
        this.tickPitchingLogic();
        if (!this.m_9236_().f_46443_ && (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting())) {
            if (this.m_20160_()) {
                this.wakeUpImmediately();
                this.clearAllStatesWhenMounted();
            } else if (this.m_5448_() != null || this.m_5912_()) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            } else if (this.m_20072_() || this.m_20077_()) {
                this.wakeUpImmediately();
                this.suppressSleep(200);
            }
            super.tickAnimationStates();
        }
        if (!(this.m_9236_().f_46443_ || this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting())) {
            super.tickAnimationStates();
        }
        if (!this.m_9236_().f_46443_ && this.isDodging()) {
            this.handleDodgeMovement();
            return;
        }
        this.tickRunningTime();
        this.tickBeamLook();
        if (!this.m_9236_().f_46443_ && this.m_6162_()) {
            if (this.m_5448_() != null) {
                super.m_6710_(null);
            }
            if (this.getActiveAbility() != null) {
                this.combatManager.forceEndActiveAbility();
            }
            this.m_21561_(false);
        }
        this.tickClientSideUpdates();
    }

    private void tickScreenShake() {
        this.prevScreenShakeAmount = this.screenShakeAmount;
        if (this.screenShakeAmount > 0.0f) {
            this.screenShakeAmount = Math.max(0.0f, this.screenShakeAmount - 0.34f);
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
        }
    }

    private void tickHurtSoundCooldown() {
        if (this.hurtSoundCooldown > 0) {
            --this.hurtSoundCooldown;
        }
    }

    private void tickAttackState() {
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    private void tickSound() {
        this.getSoundHandler().tick();
    }

    private void tickSittingState() {
        if (!this.m_9236_().f_46443_ && this.m_20160_() && this.m_21827_()) {
            this.m_21839_(false);
        }
    }

    private void tickMountingState() {
        if (!this.m_9236_().f_46443_ && this.m_20160_() && !this.wasVehicleLastTick) {
            this.clearAllStatesWhenMounted();
        }
        this.wasVehicleLastTick = this.m_20160_();
    }

    private void clearAllStatesWhenMounted() {
        if (!this.m_9236_().f_46443_ && this.m_20160_()) {
            this.wakeUpImmediately();
            if (this.m_21827_()) {
                this.m_21839_(false);
                if (this.getCommand() == 1) {
                    this.setCommandAuto(0);
                }
            }
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            this.suppressSleep(300);
        }
    }

    private void tickRunningTime() {
        this.runningTicks = this.isRunning() ? ++this.runningTicks : Math.max(0, this.runningTicks - 2);
    }

    private void tickBeamLook() {
        if (!this.isBeaming()) {
            this.resetBeamAim();
            return;
        }
        Vec3 start = this.getBeamStartPosition();
        if (start == null) {
            start = this.computeHeadMouthOrigin(1.0f);
        }
        if (start == null) {
            this.resetBeamAim();
            return;
        }
        Vec3 aimDir = this.refreshBeamAimDirection(start, true);
        if (aimDir == null) {
            aimDir = this.beamAimDir = Vec3.m_82498_((float)this.m_146909_(), (float)this.f_20885_).m_82541_();
            this.updateBeamOffsets(aimDir);
        }
        Vec3 desiredLook = start.m_82549_(aimDir.m_82490_(6.0));
        double alpha = 0.35;
        this.beamLookLerp = this.beamLookLerp == null ? desiredLook : this.beamLookLerp.m_82549_(desiredLook.m_82546_(this.beamLookLerp).m_82490_(alpha));
        float yawSpeed = Math.max(90.0f, (float)this.m_21529_());
        float pitchRange = this.m_8132_();
        this.m_21563_().m_24950_(this.beamLookLerp.f_82479_, this.beamLookLerp.f_82480_, this.beamLookLerp.f_82481_, yawSpeed, pitchRange);
    }

    public Vec3 getBeamAimDirection() {
        return this.beamAimDir;
    }

    public float getBeamYawOffsetRad() {
        return this.beamYawOffsetRad;
    }

    public float getBeamPitchOffsetRad() {
        return this.beamPitchOffsetRad;
    }

    public Vec3 refreshBeamAimDirection(Vec3 start, boolean smooth) {
        Vec3 desiredDir = this.computeRawBeamAimDirection(start);
        if (desiredDir == null) {
            this.updateBeamOffsets(null);
            return null;
        }
        Vec3 clamped = this.clampBeamDirection(desiredDir);
        if (clamped == null) {
            this.updateBeamOffsets(null);
            return null;
        }
        if (this.beamAimDir == null) {
            this.beamAimDir = clamped;
        } else if (smooth) {
            double blend = 0.35;
            this.beamAimDir = this.beamAimDir.m_82549_(clamped.m_82546_(this.beamAimDir).m_82490_(blend));
            double len = this.beamAimDir.m_82553_();
            this.beamAimDir = len > 1.0E-6 ? this.beamAimDir.m_82490_(1.0 / len) : clamped;
        } else {
            this.beamAimDir = clamped;
        }
        this.updateBeamOffsets(this.beamAimDir);
        return this.beamAimDir;
    }

    private Vec3 computeRawBeamAimDirection(Vec3 start) {
        Vec3 aimPoint;
        Vec3 towardTarget;
        LivingEntity rider;
        Vec3 riderLook;
        LivingEntity cp = this.m_6688_();
        if (cp instanceof LivingEntity && (riderLook = (rider = cp).m_20154_()).m_82556_() > 1.0E-6) {
            return riderLook.m_82541_();
        }
        LivingEntity target = this.m_5448_();
        if (target != null && target.m_6084_() && (towardTarget = (aimPoint = target.m_146892_().m_82520_(0.0, -0.25, 0.0)).m_82546_(start)).m_82556_() > 1.0E-6) {
            return towardTarget.m_82541_();
        }
        Vec3 fallbackDir = Vec3.m_82498_((float)this.m_146909_(), (float)this.f_20885_);
        return fallbackDir.m_82556_() > 1.0E-6 ? fallbackDir.m_82541_() : Vec3.f_82478_;
    }

    private Vec3 clampBeamDirection(Vec3 desiredDir) {
        float finalYaw;
        if (desiredDir == null || desiredDir.m_82556_() < 1.0E-6) {
            this.updateBeamOffsets(null);
            return null;
        }
        Vec3 dir = desiredDir.m_82541_();
        float desiredYawDeg = (float)(Math.atan2(-dir.f_82479_, dir.f_82481_) * 57.29577951308232);
        float desiredPitchDeg = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 57.29577951308232);
        float headYaw = this.f_20885_;
        float headPitch = this.m_146909_();
        float yawErrDeg = Mth.m_14118_((float)headYaw, (float)desiredYawDeg);
        float pitchErrDeg = desiredPitchDeg - headPitch;
        float clampedYawErr = Mth.m_14036_((float)yawErrDeg, (float)-40.0f, (float)40.0f);
        float clampedPitchErr = Mth.m_14036_((float)pitchErrDeg, (float)-50.0f, (float)50.0f);
        float finalPitch = headPitch + clampedPitchErr;
        Vec3 finalDir = Vec3.m_82498_((float)finalPitch, (float)(finalYaw = headYaw + clampedYawErr));
        return finalDir.m_82556_() > 1.0E-6 ? finalDir.m_82541_() : null;
    }

    private void resetBeamAim() {
        this.beamLookLerp = null;
        this.beamAimDir = null;
        this.beamYawOffsetRad = 0.0f;
        this.beamPitchOffsetRad = 0.0f;
    }

    private void updateBeamOffsets(@Nullable Vec3 direction) {
        if (direction == null || direction.m_82556_() < 1.0E-6) {
            this.beamYawOffsetRad = 0.0f;
            this.beamPitchOffsetRad = 0.0f;
            return;
        }
        Vec3 dir = direction.m_82541_();
        float finalYawDeg = (float)(Math.atan2(-dir.f_82479_, dir.f_82481_) * 57.29577951308232);
        float finalPitchDeg = (float)(-Math.atan2(dir.f_82480_, Math.sqrt(dir.f_82479_ * dir.f_82479_ + dir.f_82481_ * dir.f_82481_)) * 57.29577951308232);
        float headYaw = this.f_20885_;
        float headPitch = this.m_146909_();
        float yawOffsetDeg = Mth.m_14118_((float)headYaw, (float)finalYawDeg);
        float pitchOffsetDeg = finalPitchDeg - headPitch;
        this.beamYawOffsetRad = yawOffsetDeg * ((float)Math.PI / 180);
        this.beamPitchOffsetRad = pitchOffsetDeg * ((float)Math.PI / 180);
    }

    private void tickClientSideUpdates() {
        if (this.m_9236_().f_46443_) {
            this.prevSitProgress = this.sitProgress;
            this.sitProgress = ((Float)this.f_19804_.m_135370_(DATA_SIT_PROGRESS)).floatValue();
            this.prevClientBeamEnd = this.clientBeamEnd;
            this.clientBeamEnd = this.getBeamEndPosition();
        }
    }

    private void tickRiderTakeoff() {
        if (!this.m_9236_().f_46443_ && this.riderTakeoffTicks > 0 && !this.isDying()) {
            --this.riderTakeoffTicks;
        }
    }

    private void tickPostLoadStabilization() {
        if (!this.m_9236_().f_46443_ && this.postLoadAirStabilizeTicks > 0) {
            if (!this.m_29443_()) {
                this.setFlying(true);
            }
            if (!this.isTakeoff()) {
                this.setTakeoff(true);
            }
            this.setLanding(false);
            this.setHovering(true);
            this.switchToAirNavigation();
            this.timeFlying = Math.min(this.timeFlying, 5);
            this.landingFlag = false;
            this.landingTimer = 0;
            Vec3 v = this.m_20184_();
            if (v.f_82480_ < 0.05) {
                this.m_20334_(v.f_82479_ * 0.95, Math.max(0.05, v.f_82480_ + 0.02), v.f_82481_ * 0.95);
            }
            --this.postLoadAirStabilizeTicks;
        }
    }

    private void tickControllers() {
        if (!this.isDying()) {
            this.flightController.handleFlightLogic();
        }
        this.updateSittingProgress();
    }

    private void updateSittingProgress() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.sitTransitionTicks > 0) {
            --this.sitTransitionTicks;
            if (this.sitTransitionTicks == 0) {
                this.isSittingDown = false;
                this.isStandingUp = false;
            }
        }
        if (this.m_21827_()) {
            if ((this.sitProgress == 0.0f || this.isStandingUp) && !this.isSittingDown) {
                this.animationHandler.triggerSitDownAnimation();
                this.isSittingDown = true;
                this.isStandingUp = false;
                this.sitTransitionTicks = 93;
            }
            if (this.sitProgress < this.maxSitTicks()) {
                this.sitProgress += 1.0f;
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        } else {
            if (!this.m_9236_().f_46443_ && super.m_21825_()) {
                this.m_21837_(false);
            }
            if (this.m_20160_()) {
                if (this.sitProgress != 0.0f) {
                    this.sitProgress = 0.0f;
                    this.prevSitProgress = 0.0f;
                    this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(0.0f));
                    this.isSittingDown = false;
                    this.isStandingUp = false;
                    this.sitTransitionTicks = 0;
                }
            } else if (this.sitProgress > 0.0f) {
                if ((this.sitProgress == this.maxSitTicks() || this.isSittingDown) && !this.isStandingUp) {
                    this.animationHandler.triggerSitUpAnimation();
                    this.isStandingUp = true;
                    this.isSittingDown = false;
                    this.sitTransitionTicks = 23;
                }
                this.sitProgress -= 1.0f;
                if (this.sitProgress < 0.0f) {
                    this.sitProgress = 0.0f;
                }
                this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
            }
        }
    }

    private void tickRiderControlLockMovement() {
        if (!this.areRiderControlsLocked()) {
            return;
        }
        if (this.m_6688_() == null) {
            this.riderControlLockTicks = 0;
            return;
        }
        this.m_21573_().m_26573_();
        this.m_6710_(null);
        this.m_20334_(0.0, 0.0, 0.0);
    }

    private void tickFollowFailsafe() {
        double speed;
        LivingEntity owner;
        if (this.followFailsafeCooldown > 0) {
            --this.followFailsafeCooldown;
            return;
        }
        this.followFailsafeCooldown = 20;
        if (this.isSleepLocked() || this.m_21827_() || this.m_20159_() || this.m_20160_() || this.isDying()) {
            return;
        }
        if (this.getCommand() == 1 && !this.m_21827_()) {
            this.setCommandAuto(0);
        }
        if ((owner = this.m_269323_()) == null || !owner.m_6084_()) {
            return;
        }
        if (owner.m_9236_() != this.m_9236_()) {
            return;
        }
        if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
            return;
        }
        if (this.m_29443_()) {
            return;
        }
        double distSq = this.m_20280_((Entity)owner);
        if (distSq < 324.0) {
            if (!this.m_21573_().m_26572_() && this.getCommand() == 0 && !this.m_21827_()) {
                this.m_21573_().m_5624_((Entity)owner, 0.8);
            }
            return;
        }
        boolean moveGoalActive = this.f_21345_.m_25386_().anyMatch(wrapped -> {
            Goal goal = wrapped.m_26015_();
            return goal instanceof RaevyxFollowOwnerGoal || goal instanceof RaevyxMoveGoal;
        });
        if (moveGoalActive) {
            return;
        }
        this.switchToGroundNavigation();
        boolean shouldRun = distSq > 625.0;
        this.setRunning(shouldRun);
        this.setGroundMoveStateFromAI(shouldRun ? 2 : 1);
        double d = speed = shouldRun ? 1.35 : 0.9;
        if (!this.m_21573_().m_5624_((Entity)owner, speed)) {
            this.m_21573_().m_26573_();
            this.attemptOwnerTeleport(owner);
        }
    }

    private void attemptOwnerTeleport(LivingEntity owner) {
        BlockPos ownerPos = owner.m_20183_();
        for (int i = 0; i < 8; ++i) {
            int dz;
            int dx = this.f_19796_.m_188503_(7) - 3;
            BlockPos candidate = ownerPos.m_7918_(dx, 0, dz = this.f_19796_.m_188503_(7) - 3);
            if (!this.isTeleportFriendlyBlock(candidate)) continue;
            this.m_6021_((double)candidate.m_123341_() + 0.5, candidate.m_123342_(), (double)candidate.m_123343_() + 0.5);
            this.m_21573_().m_26573_();
            return;
        }
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        BlockPos below = pos.m_7495_();
        BlockState floor = this.m_9236_().m_8055_(below);
        BlockState body = this.m_9236_().m_8055_(pos);
        BlockState above = this.m_9236_().m_8055_(pos.m_7494_());
        return floor.m_60804_((BlockGetter)this.m_9236_(), below) && body.m_60795_() && above.m_60795_();
    }

    private void tickSuperchargeTimer() {
        if (this.superchargeTicks > 0) {
            --this.superchargeTicks;
            if (this.superchargeTicks == 0) {
                Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(180.0);
                if (this.m_21223_() > this.m_21233_()) {
                    this.m_21153_(this.m_21233_());
                }
                this.allowGroundBeamDuringStorm = false;
            }
        }
    }

    private void tickTempInvulnTimer() {
        if (this.tempInvulnTicks > 0) {
            --this.tempInvulnTicks;
            if (this.tempInvulnTicks == 0 && !this.isDying()) {
                this.m_20331_(false);
            }
        }
    }

    private void tickSuperchargeVfx() {
        if ((this.isSupercharged() || this.m_9236_().m_46470_()) && this.superchargeVfxCooldown-- <= 0) {
            this.spawnSuperchargeVfx();
            this.superchargeVfxCooldown = 6 + this.f_19796_.m_188503_(6);
        }
    }

    private void tickSleepTransition() {
        if (this.isSleepingEntering() && !this.m_9236_().f_46443_ && this.getSitProgress() >= this.maxSitTicks() && this.sleepTransitionTicks == 50) {
            this.animationHandler.triggerFallAsleepAnimation();
        }
        if (this.sleepTransitionTicks > 0) {
            --this.sleepTransitionTicks;
            if (this.sleepTransitionTicks == 0) {
                if (this.isSleepingEntering()) {
                    this.setSleeping(true);
                    this.setSleepingEntering(false);
                    this.animationHandler.triggerSleepAnimation();
                } else if (this.isSleepingExiting()) {
                    this.setSleepingExiting(false);
                    this.sleepAmbientCooldownTicks = 10;
                }
            }
        }
    }

    private void tickSleepCooldowns() {
        if (this.sleepAmbientCooldownTicks > 0) {
            --this.sleepAmbientCooldownTicks;
        }
        if (this.sleepReentryCooldownTicks > 0) {
            --this.sleepReentryCooldownTicks;
        }
        if (this.sleepCancelTicks > 0) {
            --this.sleepCancelTicks;
        }
    }

    private void tickBankingLogic() {
        this.prevBankAngle = this.bankAngle;
        if (this.areRiderControlsLocked() || !this.m_29443_() || this.m_21827_()) {
            if (this.bankDir != 0 || this.bankAngle != 0.0f || this.bankSmoothedYaw != 0.0f) {
                this.bankDir = 0;
                this.bankSmoothedYaw = 0.0f;
                this.bankHoldTicks = 0;
                this.bankAngle = 0.0f;
                this.prevBankAngle = 0.0f;
            }
            return;
        }
        float yawChange = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.bankSmoothedYaw = this.bankSmoothedYaw * 0.75f + yawChange * 0.25f;
        float targetAngle = Mth.m_14036_((float)(this.bankSmoothedYaw * 5.0f), (float)-90.0f, (float)90.0f);
        this.bankAngle = Mth.m_14179_((float)0.28f, (float)this.bankAngle, (float)targetAngle);
        if (Math.abs(this.bankAngle) < 0.01f) {
            this.bankAngle = 0.0f;
        }
        float enter = 10.0f;
        float exit = 4.0f;
        int desiredDir = this.bankDir;
        if (this.bankAngle > enter) {
            desiredDir = 1;
        } else if (this.bankAngle < -enter) {
            desiredDir = -1;
        } else if (Math.abs(this.bankAngle) < exit) {
            desiredDir = 0;
        }
        if (desiredDir != this.bankDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.bankHoldTicks >= holdTime) {
                this.bankDir = desiredDir;
                this.bankHoldTicks = 0;
            } else {
                ++this.bankHoldTicks;
            }
        } else {
            this.bankHoldTicks = Math.min(this.bankHoldTicks + 1, 10);
        }
    }

    private void tickRiderLandingBlendTimer() {
        if (!this.m_20160_() || !this.m_29443_() || this.m_20096_()) {
            this.riderLandingBlendTicks = 0;
            if (!this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_RIDER_LANDING_BLEND, (Object)false);
            }
            return;
        }
        if (this.riderLandingBlendTicks > 0) {
            --this.riderLandingBlendTicks;
            if (this.riderLandingBlendTicks == 0 && !this.m_9236_().f_46443_) {
                this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_RIDER_LANDING_BLEND, (Object)false);
            }
        }
    }

    private void triggerRiderLandingBlend() {
        this.riderLandingBlendTicks = 5;
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_RIDER_LANDING_BLEND, (Object)true);
        }
    }

    public boolean isRiderLandingBlendActive() {
        return (Boolean)this.f_19804_.m_135370_(RaevyxConstantsHandler.DATA_RIDER_LANDING_BLEND);
    }

    private double getAltitudeAboveTerrain() {
        BlockPos pos = this.m_20183_();
        if (!this.m_9236_().m_46805_(pos)) {
            return Double.POSITIVE_INFINITY;
        }
        int groundY = this.m_9236_().m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.m_123341_(), pos.m_123343_());
        return this.m_20186_() - (double)groundY;
    }

    private void tickPitchingLogic() {
        this.tickRiderLandingBlendTimer();
        if (this.areRiderControlsLocked() || !this.m_29443_() || this.m_21827_()) {
            if (this.pitchDir != 0) {
                this.pitchDir = 0;
                this.pitchSmoothedPitch = 0.0f;
                this.pitchHoldTicks = 0;
            }
            return;
        }
        int desiredDir = this.pitchDir;
        if (this.m_20160_() && this.m_6688_() instanceof Player) {
            double altitude;
            desiredDir = this.isGoingUp() ? -1 : (this.isGoingDown() ? 1 : 0);
            if (this.isGoingDown() && (altitude = this.getAltitudeAboveTerrain()) != Double.POSITIVE_INFINITY && altitude >= -0.25 && altitude <= 8.5) {
                desiredDir = 0;
                this.triggerRiderLandingBlend();
            }
        } else {
            float pitchChange = this.m_146909_() - this.f_19860_;
            this.pitchSmoothedPitch = this.pitchSmoothedPitch * 0.85f + pitchChange * 0.15f;
            float enter = 3.0f;
            float exit = 3.0f;
            if (this.pitchSmoothedPitch > enter) {
                desiredDir = 1;
            } else if (this.pitchSmoothedPitch < -enter) {
                desiredDir = -1;
            } else if (Math.abs(this.pitchSmoothedPitch) < exit) {
                desiredDir = 0;
            }
        }
        if (desiredDir != this.pitchDir) {
            int holdTime;
            int n = holdTime = desiredDir == 0 ? 1 : 2;
            if (this.pitchHoldTicks >= holdTime) {
                this.pitchDir = desiredDir;
                this.pitchHoldTicks = 0;
            } else {
                ++this.pitchHoldTicks;
            }
        } else {
            this.pitchHoldTicks = Math.min(this.pitchHoldTicks + 1, 20);
        }
    }

    protected void m_6677_(@Nonnull DamageSource source) {
    }

    @Override
    protected DragonAbilityType<?, ?> getHurtAbilityType() {
        return RaevyxAbilities.HURT;
    }

    @Override
    protected void onSuccessfulDamage(DamageSource source, float amount) {
        if (this.isDying()) {
            return;
        }
        if (this.hurtSoundCooldown > 0) {
            return;
        }
        super.onSuccessfulDamage(source, amount);
        this.hurtSoundCooldown = this.m_20160_() ? 15 : 8;
    }

    private void playCustomAmbientSound() {
        if (this.m_6162_()) {
            return;
        }
        RandomSource random = this.m_217043_();
        if (this.isDying() || this.m_5912_() || this.isBeaming() || this.getActiveAbility() != null) {
            return;
        }
        String vocalKey = null;
        if (this.m_21827_()) {
            vocalKey = random.m_188501_() < 0.6f ? "content" : "purr";
        } else if (this.m_29443_()) {
            if (random.m_188501_() < 0.3f) {
                vocalKey = "chuff";
            }
        } else {
            float grumbleChance;
            vocalKey = !(this.m_29443_() || this.isTakeoff() || this.isLanding() || this.isHovering() || !this.isWalking() && !this.isRunning()) ? (this.isRunning() ? "snort" : "chuff") : ((grumbleChance = random.m_188501_()) < 0.4f ? "grumble1" : (grumbleChance < 0.7f ? "grumble2" : (grumbleChance < 0.9f ? "grumble3" : "purr")));
        }
        if (vocalKey != null) {
            this.getSoundHandler().playVocal(vocalKey);
        }
    }

    private void handleAmbientSounds() {
        if (this.m_6162_() || this.isDying() || this.m_5803_() || this.isSleepTransitioning() || this.isInSitTransition() || this.sleepAmbientCooldownTicks > 0) {
            return;
        }
        ++this.ambientSoundTimer;
        if (this.ambientSoundTimer >= this.nextAmbientSoundDelay) {
            this.playCustomAmbientSound();
            this.resetAmbientSoundTimer();
        }
    }

    private void suppressAmbientSounds(int ticks) {
        this.sleepAmbientCooldownTicks = Math.max(this.sleepAmbientCooldownTicks, ticks);
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = Math.max(this.nextAmbientSoundDelay, ticks);
    }

    private void resetAmbientSoundTimer() {
        RandomSource random = this.m_217043_();
        this.ambientSoundTimer = 0;
        this.nextAmbientSoundDelay = 200 + random.m_188503_(400);
    }

    public void playExcitedSound() {
        this.getSoundHandler().playVocal("excited");
    }

    public void playAnnoyedSound() {
        this.getSoundHandler().playVocal("annoyed");
    }

    private void handleDodgeMovement() {
        Vec3 current = this.m_20184_();
        Vec3 boosted = current.m_82549_(this.dodgeVec.m_82490_(0.25));
        this.m_20256_(boosted.m_82542_(0.92, 0.95, 0.92));
        this.f_19812_ = true;
        if (--this.dodgeTicksLeft <= 0) {
            this.dodging = false;
            this.dodgeVec = Vec3.f_82478_;
        }
    }

    @Override
    public void m_7023_(@NotNull Vec3 motion) {
        LivingEntity livingEntity;
        boolean sittingLocked;
        boolean bl = sittingLocked = (this.m_21827_() || this.m_21825_()) && this.postStandUnlockTicks <= 0;
        if (sittingLocked || this.isDodging() || this.isDying() || this.m_5803_() || this.isSleepTransitioning()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            motion = Vec3.f_82478_;
            super.m_7023_(motion);
            return;
        }
        if (this.dodging) {
            super.m_7023_(motion);
            return;
        }
        if (this.m_20160_() && (livingEntity = this.m_6688_()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            if (this.m_29443_()) {
                this.riderController.handleRiderMovement(player, motion);
            } else {
                super.m_7023_(motion);
            }
        } else if (this.m_29443_()) {
            this.flightController.handleFlightTravel(motion);
        } else {
            super.m_7023_(motion);
        }
    }

    public void m_6504_(@Nonnull LivingEntity target, float distanceFactor) {
    }

    public boolean isFlightControllerStuck() {
        MoveControl moveControl = this.f_21342_;
        if (moveControl instanceof DragonFlightMoveHelper) {
            DragonFlightMoveHelper flightHelper = (DragonFlightMoveHelper)moveControl;
            return flightHelper.hasGivenUp();
        }
        return false;
    }

    public static boolean canSpawnHere(EntityType<Raevyx> type, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        BlockPos below = pos.m_7495_();
        if (!level.m_6425_(pos).m_76178_()) {
            return false;
        }
        if (!level.m_6425_(below).m_76178_()) {
            return false;
        }
        boolean solidGround = level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
        boolean feetFree = level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
        boolean headFree = level.m_8055_(pos.m_7494_()).m_60812_((BlockGetter)level, pos.m_7494_()).m_83281_();
        return solidGround && feetFree && headFree;
    }

    public int m_8132_() {
        return this.isBeaming() ? 50 : 180;
    }

    public int m_8085_() {
        return this.isBeaming() ? 40 : 180;
    }

    public int m_21529_() {
        return this.isBeaming() ? 90 : 180;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new RaevyxPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new RaevyxDodgeGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(6, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new RaevyxFollowParentGoal(this, 1.15));
        this.f_21345_.m_25352_(7, (Goal)new RaevyxBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RaevyxCombatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new RaevyxMoveGoal(this, true, 1.4));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxAttackGoal(this, 1, 1, 15, 10, 4.0f));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxAttackGoal(this, 3, 3, 11, 8, 3.0f));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxAttackGoal(this, 2, 2, 5, 5, 4.0f));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxAttackGoal(this, 4, 4, 3, 3, 3.0f));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxAttackGoal(this, 5, 5, 5, 5, 4.0f));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxStateGoal(this, 1, 1, 2, 10, 10));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxStateGoal(this, 3, 3, 4, 8, 8));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxStateGoal(this, 2, 2, 5, 5, 5));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxStateGoal(this, 4, 4, 5, 3, 3));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxStateGoal(this, 5, 5, 0, 5, 5));
        this.f_21345_.m_25352_(0, (Goal)new RaevyxSleepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RaevyxRestGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RaevyxFollowOwnerGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new RaevyxGroundWanderGoal(this, 1.0, 60));
        this.f_21345_.m_25352_(10, (Goal)new RaevyxTemptGoal(this, 1.2, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42527_, Items.f_42526_, Items.f_42528_, Items.f_42529_}), false));
        this.f_21345_.m_25352_(11, (Goal)new RaevyxFlightGoal(this));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new DragonOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new DragonOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    public boolean m_6469_(@Nonnull DamageSource damageSource, float amount) {
        if (this.isDying()) {
            if (damageSource.m_276093_(DamageTypes.f_286979_)) {
                return super.m_6469_(damageSource, amount);
            }
            return false;
        }
        if (damageSource.m_276093_(DamageTypes.f_268450_)) {
            return false;
        }
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        if (damageSource.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        if (this.handleLethalDamage(damageSource, amount, RaevyxAbilities.DIE)) {
            return true;
        }
        boolean wasFlying = this.m_29443_();
        boolean wasRidden = this.m_20160_();
        boolean result = super.m_6469_(damageSource, amount);
        if (result && wasRidden && wasFlying && this.m_20160_()) {
            this.setFlying(true);
            this.setLanding(false);
            this.switchToAirNavigation();
        }
        return result;
    }

    public boolean m_6673_(@Nonnull DamageSource source) {
        if (source.m_276093_(DamageTypes.f_268450_)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public int m_6062_() {
        return 3600;
    }

    public int m_7305_(int currentAir) {
        int refillPerTick = 50;
        return Math.min(this.m_6062_(), currentAir + refillPerTick);
    }

    public void m_8038_(@Nonnull ServerLevel level, @Nonnull LightningBolt lightning) {
        if (this.m_6060_()) {
            this.m_20095_();
        }
    }

    public int getBankDirection() {
        return this.bankDir;
    }

    public float getBankAngleDegrees() {
        return this.bankAngle;
    }

    public float getBankAngleDegrees(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.prevBankAngle, (float)this.bankAngle);
    }

    public int getPitchDirection() {
        return this.pitchDir;
    }

    public boolean isSummoning() {
        return false;
    }

    public void startSupercharge(int ticks) {
        boolean wasNotSupercharged = !this.isSupercharged();
        this.superchargeTicks = Math.max(this.superchargeTicks, Math.max(0, ticks));
        if (wasNotSupercharged && this.isSupercharged()) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_(360.0);
            this.m_21153_(this.m_21233_());
            this.allowGroundBeamDuringStorm = true;
        }
    }

    public boolean isSupercharged() {
        return this.superchargeTicks > 0;
    }

    public float getDamageMultiplier() {
        return this.isSupercharged() ? 2.0f : 1.0f;
    }

    public void startTemporaryInvuln(int ticks) {
        this.tempInvulnTicks = Math.max(this.tempInvulnTicks, Math.max(0, ticks));
        this.m_20331_(true);
    }

    private void spawnSuperchargeVfx() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 center = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.6, 0.0);
        double radius = Math.max(this.m_20191_().m_82362_(), this.m_20191_().m_82385_()) * 0.55;
        int bursts = 2 + this.f_19796_.m_188503_(3);
        for (int i = 0; i < bursts; ++i) {
            Vec3 dir = Raevyx.randomUnit(this.f_19796_);
            double length = 0.4 + this.f_19796_.m_188500_() * 0.7;
            Vec3 offset = Raevyx.randomUnit(this.f_19796_).m_82490_(radius * 0.35);
            Vec3 from = center.m_82549_(offset);
            Vec3 to = from.m_82549_(dir.m_82490_(length));
            float size = 0.5f + this.f_19796_.m_188501_() * 0.25f;
            this.emitMicroArc(server, from, to, size);
        }
        server.m_8767_((ParticleOptions)ParticleTypes.f_175830_, center.f_82479_, center.f_82480_, center.f_82481_, 3, radius * 0.15, radius * 0.15, radius * 0.15, 0.0);
    }

    private void emitMicroArc(ServerLevel server, Vec3 from, Vec3 to, float size) {
        Vec3 delta = to.m_82546_(from);
        int steps = 2 + this.f_19796_.m_188503_(3);
        Vec3 step = delta.m_82490_(1.0 / (double)steps);
        Vec3 pos = from;
        Vec3 dir = step.m_82556_() > 1.0E-6 ? step.m_82541_() : Raevyx.randomUnit(this.f_19796_);
        boolean female = this.isFemale();
        for (int i = 0; i <= steps; ++i) {
            if (this.f_19796_.m_188501_() < 0.7f) {
                if (this.f_19796_.m_188499_()) {
                    server.m_8767_((ParticleOptions)new RaevyxLightningArcData(size, female), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, dir.f_82479_, dir.f_82480_, dir.f_82481_, 0.0);
                } else {
                    server.m_8767_((ParticleOptions)new RaevyxLightningStormData(size, female), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, dir.f_82479_, dir.f_82480_, dir.f_82481_, 0.0);
                }
            }
            pos = pos.m_82549_(step);
        }
    }

    private static Vec3 randomUnit(RandomSource rnd) {
        double u = rnd.m_188500_();
        double v = rnd.m_188500_();
        double theta = Math.PI * 2 * u;
        double z = 2.0 * v - 1.0;
        double r = Math.sqrt(1.0 - z * z);
        return new Vec3(r * Math.cos(theta), z, r * Math.sin(theta));
    }

    public boolean isInSitTransition() {
        return this.isSittingDown || this.isStandingUp;
    }

    public boolean isSittingDownAnimation() {
        return this.isSittingDown;
    }

    public boolean isStandingUpAnimation() {
        return this.isStandingUp;
    }

    @Override
    public boolean m_5803_() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.setBooleanData(RaevyxConstantsHandler.DATA_SLEEPING, sleeping);
    }

    @Override
    public boolean isSleepTransitioning() {
        return this.isSleepingEntering() || this.isSleepingExiting();
    }

    public boolean isSleepingEntering() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_SLEEPING_ENTERING);
    }

    public void setSleepingEntering(boolean entering) {
        this.setBooleanData(RaevyxConstantsHandler.DATA_SLEEPING_ENTERING, entering);
    }

    public boolean isSleepingExiting() {
        return this.getBooleanData(RaevyxConstantsHandler.DATA_SLEEPING_EXITING);
    }

    public void setSleepingExiting(boolean exiting) {
        this.setBooleanData(RaevyxConstantsHandler.DATA_SLEEPING_EXITING, exiting);
    }

    public boolean isSleepLocked() {
        return this.sleepLocked || this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting();
    }

    private void enterSleepLock() {
        int snapshot = this.getCommand();
        if (!this.sleepLocked) {
            this.sleepLocked = true;
            this.sleepCommandSnapshot = snapshot;
        }
        if (snapshot == 1) {
            this.setCommandManual(1);
        } else {
            this.setCommandAuto(1);
        }
        this.m_21839_(true);
        this.m_21573_().m_26573_();
        this.m_6710_(null);
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
        this.m_20256_(Vec3.f_82478_);
        this.setFlying(false);
        this.setLanding(false);
        this.setTakeoff(false);
        this.setHovering(false);
    }

    private void releaseSleepLock() {
        if (this.sleepLocked) {
            int desired = this.sleepCommandSnapshot;
            this.sleepCommandSnapshot = -1;
            this.sleepLocked = false;
            if (desired == 1) {
                this.setCommandManual(1);
                this.m_21839_(true);
            } else {
                this.setCommandAuto(desired);
                this.m_21839_(false);
            }
        }
        this.m_21573_().m_26573_();
        this.setRunning(false);
        this.setGroundMoveStateFromAI(0);
    }

    @Override
    public void startSleepEnter() {
        if (this.m_5803_() || this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.setSleepingEntering(true);
        this.sleepTransitionTicks = 50;
        this.animationHandler.triggerSitDownAnimation();
        if (!this.m_9236_().f_46443_) {
            this.enterSleepLock();
        }
    }

    @Override
    public void startSleepExit() {
        if (!this.m_5803_() && !this.isSleepingEntering() || this.isSleepingExiting()) {
            return;
        }
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(true);
        this.sleepTransitionTicks = 153;
        this.animationHandler.triggerWakeUpAnimation();
        if (!this.m_9236_().f_46443_) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void wakeUpImmediately() {
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_SLEEPING, (Object)false);
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.sleepCancelTicks = 2;
        if (!this.m_9236_().f_46443_) {
            this.suppressSleep(20);
            this.releaseSleepLock();
        }
    }

    public void suppressSleep(int ticks) {
        this.sleepReentryCooldownTicks = Math.max(this.sleepReentryCooldownTicks, ticks);
    }

    @Override
    public boolean isSleepSuppressed() {
        return this.sleepReentryCooldownTicks > 0;
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        InteractionResult result = this.lightningInteractionHandler.handleInteraction(player, hand);
        if (result == InteractionResult.PASS) {
            return super.m_6071_(player, hand);
        }
        return result;
    }

    public void m_21839_(boolean sitting) {
        super.m_21839_(sitting);
        if (sitting) {
            if (this.m_29443_()) {
                this.setLanding(true);
            }
            this.setRunning(false);
            this.m_21573_().m_26573_();
        } else {
            if (!this.m_9236_().f_46443_) {
                this.switchToGroundNavigation();
                if (this.m_29443_()) {
                    this.setFlying(false);
                }
                this.setTakeoff(false);
                this.setLanding(false);
                this.setHovering(false);
                this.usingAirNav = false;
                this.postStandUnlockTicks = Math.max(this.postStandUnlockTicks, 20);
            }
            if (this.getCommand() == 1) {
                this.setCommandAuto(0);
            }
            if (!this.m_9236_().f_46443_) {
                this.followFailsafeCooldown = 0;
                this.m_21573_().m_26573_();
                this.tickFollowFailsafe();
            }
        }
    }

    public void m_7822_(byte eventId) {
        if (eventId <= 0) {
            this.attackTicks = 0;
            return;
        }
        if (eventId == 6) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else if (eventId == 7) {
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(eventId);
        }
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return stack.m_150930_(Items.f_42527_) || stack.m_150930_(Items.f_42526_);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Flying", this.m_29443_());
        tag.m_128379_("Takeoff", this.isTakeoff());
        tag.m_128379_("Hovering", this.isHovering());
        tag.m_128379_("Landing", this.isLanding());
        tag.m_128379_("Running", this.isRunning());
        tag.m_128405_("TimeFlying", this.timeFlying);
        tag.m_128379_("UsingAirNav", this.usingAirNav);
        tag.m_128350_("SitProgress", this.sitProgress);
        tag.m_128405_("RiderTakeoffTicks", this.riderTakeoffTicks);
        tag.m_128356_("LastLandingGameTime", this.lastLandingGameTime);
        tag.m_128379_("LandingFlag", this.landingFlag);
        tag.m_128405_("LandingTimer", this.landingTimer);
        this.combatManager.saveToNBT(tag);
        tag.m_128405_("SuperchargeTicks", Math.max(0, this.superchargeTicks));
        tag.m_128405_("TempInvulnTicks", Math.max(0, this.tempInvulnTicks));
        tag.m_128379_("AllowGroundBeamStorm", this.allowGroundBeamDuringStorm);
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128405_("SleepTransitionTicks", Math.max(0, this.sleepTransitionTicks));
        tag.m_128405_("SleepAmbientCooldownTicks", Math.max(0, this.sleepAmbientCooldownTicks));
        tag.m_128405_("SleepReentryCooldownTicks", Math.max(0, this.sleepReentryCooldownTicks));
        tag.m_128405_("SleepCancelTicks", Math.max(0, this.sleepCancelTicks));
        tag.m_128379_("SleepLock", this.sleepLocked);
        tag.m_128405_("SleepCommandSnapshot", this.sleepCommandSnapshot);
        tag.m_128379_("ManualSitCommand", this.manualSitCommand);
        this.animationController.writeToNBT(tag);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_("Flying"));
        this.setTakeoff(tag.m_128471_("Takeoff"));
        this.setHovering(tag.m_128471_("Hovering"));
        this.setLanding(tag.m_128471_("Landing"));
        this.setRunning(tag.m_128471_("Running"));
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.usingAirNav = tag.m_128471_("UsingAirNav");
        this.prevSitProgress = this.sitProgress = tag.m_128457_("SitProgress");
        this.f_19804_.m_135381_(DATA_SIT_PROGRESS, (Object)Float.valueOf(this.sitProgress));
        this.riderTakeoffTicks = tag.m_128441_("RiderTakeoffTicks") ? tag.m_128451_("RiderTakeoffTicks") : 0;
        this.lastLandingGameTime = tag.m_128441_("LastLandingGameTime") ? tag.m_128454_("LastLandingGameTime") : Long.MIN_VALUE;
        this.landingFlag = tag.m_128441_("LandingFlag") && tag.m_128471_("LandingFlag");
        this.landingTimer = tag.m_128441_("LandingTimer") ? tag.m_128451_("LandingTimer") : 0;
        this.riderControlLockTicks = 0;
        this.takeoffLockTicks = 0;
        this.combatManager.loadFromNBT(tag);
        if (tag.m_128441_("SuperchargeTicks")) {
            this.superchargeTicks = Math.max(0, tag.m_128451_("SuperchargeTicks"));
        }
        if (tag.m_128441_("TempInvulnTicks")) {
            this.tempInvulnTicks = Math.max(0, tag.m_128451_("TempInvulnTicks"));
            if (this.tempInvulnTicks > 0) {
                this.m_20331_(true);
            }
        }
        if (tag.m_128441_("AllowGroundBeamStorm")) {
            this.allowGroundBeamDuringStorm = tag.m_128471_("AllowGroundBeamStorm");
        }
        if (tag.m_128441_("Sleeping")) {
            this.setSleeping(tag.m_128471_("Sleeping"));
        }
        this.sleepTransitionTicks = Math.max(0, tag.m_128451_("SleepTransitionTicks"));
        this.sleepAmbientCooldownTicks = Math.max(0, tag.m_128451_("SleepAmbientCooldownTicks"));
        this.sleepReentryCooldownTicks = Math.max(0, tag.m_128451_("SleepReentryCooldownTicks"));
        this.sleepCancelTicks = Math.max(0, tag.m_128451_("SleepCancelTicks"));
        this.sleepLocked = tag.m_128471_("SleepLock");
        this.sleepCommandSnapshot = tag.m_128451_("SleepCommandSnapshot");
        this.animationController.readFromNBT(tag);
        boolean bl = this.manualSitCommand = tag.m_128441_("ManualSitCommand") && tag.m_128471_("ManualSitCommand");
        if (this.usingAirNav) {
            this.switchToAirNavigation();
        } else {
            this.switchToGroundNavigation();
        }
        if (this.getCommand() != 1 && this.m_21827_()) {
            this.m_21839_(false);
        }
        if (this.sleepLocked || this.isSleepingEntering() || this.isSleepingExiting() || ((Boolean)this.f_19804_.m_135370_(RaevyxConstantsHandler.DATA_SLEEPING)).booleanValue()) {
            this.releaseSleepLock();
            this.wakeUpImmediately();
            this.suppressSleep(200);
        }
        this.setSleepingEntering(false);
        this.setSleepingExiting(false);
        this.sleepTransitionTicks = 0;
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_SLEEPING, (Object)false);
        this.sleepCommandSnapshot = -1;
        this.followFailsafeCooldown = 0;
        if (tag.m_128471_("Flying")) {
            this.postLoadAirStabilizeTicks = 60;
            this.riderTakeoffTicks = Math.max(this.riderTakeoffTicks, 40);
            if (!this.m_9236_().f_46443_) {
                this.flightController.shouldTakeoff();
                this.setFlying(true);
                this.setTakeoff(true);
                this.setHovering(true);
                this.setLanding(false);
                this.switchToAirNavigation();
            }
        }
        if (this.m_21827_()) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
            this.m_21561_(false);
        }
        if (this.getCommand() == 1 && !this.manualSitCommand) {
            this.setCommandAuto(0);
            this.m_21839_(false);
        }
    }

    public int getRiderTakeoffTicks() {
        return this.riderTakeoffTicks;
    }

    public void setRiderTakeoffTicks(int ticks) {
        this.riderTakeoffTicks = Math.max(0, ticks);
    }

    public void clearAllStatesForMounting() {
        this.m_6710_(null);
        this.setAttacking(false);
        this.setBeaming(false);
        this.setRunning(false);
        this.m_21573_().m_26573_();
        this.setTakeoff(false);
        this.setLanding(false);
        this.setHovering(false);
        if (this.m_21827_()) {
            this.m_21839_(false);
            if (this.getCommand() == 1) {
                this.setCommandAuto(0);
            }
        }
        this.riderTakeoffTicks = 0;
        this.postLoadAirStabilizeTicks = 0;
        this.combatManager.clearAllStates();
        this.sleepReentryCooldownTicks = 0;
        this.sleepAmbientCooldownTicks = 0;
    }

    public void triggerDodgeAnimation() {
        this.animationHandler.triggerDodgeAnimation();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController movementController = new AnimationController((GeoAnimatable)this, "movement", 3, this.animationController::handleMovementAnimation);
        AnimationController actionController = new AnimationController((GeoAnimatable)this, "action", 2, state -> PlayState.STOP);
        movementController.setSoundKeyframeHandler(this::onAnimationSound);
        actionController.setSoundKeyframeHandler(this::onAnimationSound);
        this.animationHandler.setupActionController((AnimationController<Raevyx>)actionController);
        AnimationController HurtController = new AnimationController((GeoAnimatable)this, "hurt", 3, state -> PlayState.STOP);
        HurtController.triggerableAnim("raevyx_hurt", RawAnimation.begin().thenPlay("animation.raevyx.hurt"));
        HurtController.setSoundKeyframeHandler(this::onAnimationSound);
        controllers.add(new AnimationController[]{HurtController});
        if (!this.m_6162_()) {
            AnimationController bankingController = new AnimationController((GeoAnimatable)this, "banking", 8, this.animationHandler::bankingPredicate);
            AnimationController pitchingController = new AnimationController((GeoAnimatable)this, "pitching", 6, this.animationHandler::pitchingPredicate);
            controllers.add(new AnimationController[]{bankingController});
            controllers.add(new AnimationController[]{pitchingController});
        }
        controllers.add(new AnimationController[]{movementController});
        controllers.add(new AnimationController[]{actionController});
    }

    @Override
    public Map<String, DragonEntity.VocalEntry> getVocalEntries() {
        return VOCAL_ENTRIES;
    }

    @Override
    public DragonSoundProfile getSoundProfile() {
        return RaevyxSoundProfile.INSTANCE;
    }

    @Override
    public DragonAbilityType<?, ?> getPrimaryAttackAbility() {
        boolean useHornGore = this.f_19797_ / 40 % 2 == 1;
        return useHornGore ? RaevyxAbilities.RAEVYX_HORN_GORE : RaevyxAbilities.RAEVYX_BITE;
    }

    @Override
    public DragonAbilityType<?, ?> getRoaringAbility() {
        return RaevyxAbilities.RAEVYX_ROAR;
    }

    @Override
    public DragonAbilityType<?, ?> getChannelingAbility() {
        return RaevyxAbilities.RAEVYX_SUMMON_STORM;
    }

    public void onAnimationSound(SoundKeyframeEvent<Raevyx> event) {
        this.getSoundHandler().handleAnimationSound(this, event.getKeyframeData(), event.getController());
    }

    public double getCachedDistanceToOwner() {
        int currentTick = this.f_19797_;
        if (currentTick - this.ownerDistanceCacheTime >= 3) {
            LivingEntity owner = this.m_269323_();
            this.cachedOwnerDistance = owner != null ? this.m_20280_((Entity)owner) : Double.MAX_VALUE;
            this.ownerDistanceCacheTime = currentTick;
        }
        return this.cachedOwnerDistance;
    }

    public List<Projectile> getCachedNearbyProjectiles() {
        if (!(this.m_9236_() instanceof ServerLevel)) {
            return Collections.emptyList();
        }
        if (this.f_19797_ - this.nearbyProjectilesCacheTime >= this.projectileCacheIntervalTicks) {
            List<Projectile> found = DragonMathUtil.getEntitiesNearby((Entity)this, Projectile.class, 30.0);
            this.cachedNearbyProjectiles = found;
            this.nearbyProjectilesCacheTime = this.f_19797_;
            if (found.isEmpty()) {
                this.emptyProjectileScans = Math.min(this.emptyProjectileScans + 1, 4);
                this.projectileCacheIntervalTicks = 3 + this.emptyProjectileScans * 2;
            } else {
                this.emptyProjectileScans = 0;
                this.projectileCacheIntervalTicks = 3;
            }
        }
        return this.cachedNearbyProjectiles;
    }

    @Override
    public boolean areRiderControlsLocked() {
        return this.m_9236_().f_46443_ ? (Boolean)this.f_19804_.m_135370_(RaevyxConstantsHandler.DATA_RIDER_LOCKED) : this.riderControlLockTicks > 0;
    }

    private void tickRiderControlLock() {
        if (this.riderControlLockTicks > 0) {
            --this.riderControlLockTicks;
            if (this.riderControlLockTicks <= 0) {
                this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_RIDER_LOCKED, (Object)false);
            }
        }
    }

    public void lockRiderControls(int ticks) {
        this.riderControlLockTicks = Math.max(this.riderControlLockTicks, Math.max(0, ticks));
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_RIDER_LOCKED, (Object)true);
        this.setAccelerating(false);
        this.setGoingUp(false);
        this.setGoingDown(false);
        this.m_20256_(Vec3.f_82478_);
        if (!this.m_9236_().f_46443_) {
            this.m_21573_().m_26573_();
            this.m_6710_(null);
        }
    }

    public boolean isTakeoffLocked() {
        return this.takeoffLockTicks > 0;
    }

    public void lockTakeoff(int ticks) {
        this.takeoffLockTicks = Math.max(this.takeoffLockTicks, Math.max(0, ticks));
    }

    private void tickTakeoffLock() {
        if (this.takeoffLockTicks > 0) {
            --this.takeoffLockTicks;
        }
    }

    public void noteAggroFrom(LivingEntity target) {
        if (target == null || target.m_9236_().f_46443_) {
            return;
        }
        this.recentAggroIds.put(target.m_19879_(), this.m_9236_().m_46467_() + 200L);
    }

    public List<LivingEntity> getRecentAggro() {
        ArrayList<LivingEntity> out = new ArrayList<LivingEntity>();
        long now = this.m_9236_().m_46467_();
        Iterator<Map.Entry<Integer, Long>> it = this.recentAggroIds.entrySet().iterator();
        while (it.hasNext()) {
            LivingEntity le;
            Map.Entry<Integer, Long> e = it.next();
            if (e.getValue() < now) {
                it.remove();
                continue;
            }
            Entity ent = this.m_9236_().m_6815_(e.getKey().intValue());
            if (ent instanceof LivingEntity && (le = (LivingEntity)ent).m_6084_()) {
                out.add(le);
                continue;
            }
            it.remove();
        }
        return out;
    }

    public float m_20236_(@Nonnull Pose pose) {
        EntityDimensions dimensions = this.m_6972_(pose);
        return dimensions.f_20378_ * 0.6f;
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.6f;
    }

    @Override
    public double getCachedHorizontalSpeed() {
        if (this.f_19797_ != this.horizontalSpeedCacheTime) {
            Vec3 velocity = this.m_20184_();
            this.cachedHorizontalSpeed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
            this.horizontalSpeedCacheTime = this.f_19797_;
        }
        return this.cachedHorizontalSpeed;
    }

    public boolean m_7848_(@Nonnull Animal otherAnimal) {
        if (!this.m_35506_()) {
            return false;
        }
        if (otherAnimal instanceof Raevyx) {
            Raevyx otherDragon = (Raevyx)otherAnimal;
            if (this.isFemale() == otherDragon.isFemale()) {
                return false;
            }
            return otherDragon.m_35506_();
        }
        return false;
    }

    public boolean m_35506_() {
        return !this.m_6162_() && this.m_21223_() >= this.m_21233_() && this.m_27593_();
    }

    @Nullable
    public AgeableMob m_142606_(@Nonnull ServerLevel level, @Nonnull AgeableMob otherParent) {
        Raevyx baby = (Raevyx)((EntityType)ModEntities.RAEVYX.get()).m_20615_((Level)level);
        if (baby != null) {
            baby.setGender(this.f_19796_.m_188499_() ? DragonGender.FEMALE : DragonGender.MALE);
            UUID ownerId = this.m_21805_();
            if (ownerId != null) {
                baby.m_21816_(ownerId);
                baby.m_7105_(true);
            }
            baby.m_146762_(-24000);
        }
        return baby;
    }

    @Override
    @NotNull
    public Vec3 m_274312_(@Nonnull Player player, @Nonnull Vec3 deltaIn) {
        if (this.areRiderControlsLocked()) {
            return Vec3.f_82478_;
        }
        Vec3 input = this.riderController.getRiddenInput(player, deltaIn);
        return super.m_274312_(player, input);
    }

    protected void m_274498_(@Nonnull Player player, @Nonnull Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        if (!this.m_9236_().f_46443_) {
            this.tickTakeoffLock();
        }
        if (!this.areRiderControlsLocked()) {
            this.riderController.tickRidden(player, travelVector);
        } else {
            player.f_19789_ = 0.0f;
            this.f_19789_ = 0.0f;
            this.m_6710_(null);
            this.copyRiderLook(player);
            this.setAccelerating(false);
            if (!this.m_29443_()) {
                this.setGoingUp(false);
                this.setGoingDown(false);
            }
        }
    }

    protected float m_245547_(@Nonnull Player rider) {
        if (this.areRiderControlsLocked()) {
            return 0.0f;
        }
        return this.riderController.getRiddenSpeed(rider);
    }

    @Override
    public void m_20351_(@Nonnull Entity passenger) {
        if (this.areRiderControlsLocked() && passenger == this.m_6688_()) {
            return;
        }
        super.m_20351_(passenger);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (this.m_6162_()) {
            super.m_6710_(null);
            return;
        }
        LivingEntity previousTarget = this.m_5448_();
        super.m_6710_(target);
        if (!this.m_9236_().f_46443_) {
            if (this.aggroGrowlCooldown > 0) {
                --this.aggroGrowlCooldown;
            }
            if (target != null && previousTarget == null && this.aggroGrowlCooldown <= 0) {
                if (!this.m_20160_() && !this.isStayOrSitMuted()) {
                    this.getSoundHandler().playVocal("growl_warning");
                }
                this.aggroGrowlCooldown = this.m_20160_() ? 120 : 80;
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        return this.riderController.getControllingPassenger();
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, @Nonnull DamageSource source) {
        if (!this.m_9236_().f_46443_) {
            this.f_19789_ = 0.0f;
            for (Entity e : this.m_20197_()) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)e;
                le.f_19789_ = 0.0f;
            }
        }
        return false;
    }

    @Override
    public double getMeleeRange() {
        return 3.5;
    }

    @Override
    public float getMeleeDamage() {
        return 8.0f;
    }

    @Override
    public boolean canMeleeAttack() {
        return !this.isBeaming() && !this.isCharging() && this.m_5448_() != null;
    }

    @Override
    public void performMeleeAttack(LivingEntity target) {
        if (target != null && this.canMeleeAttack()) {
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.getMeleeDamage());
            if (this.m_217043_().m_188501_() < 0.3f) {
                this.playLightningEffect(target.m_20182_());
            }
        }
    }

    @Override
    public int getAttackCooldown() {
        return 20;
    }

    @Override
    public boolean isAttacking() {
        return this.isBeaming() || this.isCharging();
    }

    @Override
    public void setAttacking(boolean attacking) {
        this.setBeaming(attacking);
    }

    @Override
    public float getFlightSpeed() {
        return 1.0f;
    }

    @Override
    public double getPreferredFlightAltitude() {
        return 15.0;
    }

    @Override
    public boolean canTakeoff() {
        return !this.m_20072_() && !this.m_20077_() && this.m_20096_();
    }

    @Override
    public DragonSleepCapable.SleepPreferences getSleepPreferences() {
        return new DragonSleepCapable.SleepPreferences(false, true, true, true, true);
    }

    @Override
    public boolean canSleepNow() {
        return !this.isCharging() && !this.isBeaming() && !this.m_20160_();
    }

    public void playLightningEffect(Vec3 position) {
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_7106_((ParticleOptions)new RaevyxLightningStormData(1.0f, this.isFemale()), position.f_82479_, position.f_82480_, position.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public boolean hasEnhancedLineOfSight(Vec3 target) {
        return this.m_20182_().m_82554_(target) < 50.0;
    }

    public float getEnergyLevel() {
        return 0.8f;
    }

    public boolean isCharging() {
        return false;
    }

    @Override
    public ElectricalConductivityProfile getConductivityProfile() {
        return CONDUCTIVITY_PROFILE;
    }

    @Override
    public ElectricalConductivityState getConductivityState() {
        return ElectricalConductivityCapable.super.getConductivityState();
    }

    public Raevyx asConductiveEntity() {
        return this;
    }

    public boolean canBeBound() {
        return !this.m_5803_() && !this.isDying() && !this.isCharging() && !this.isBeaming();
    }

    @Override
    public float getScreenShakeAmount(float partialTicks) {
        float currentAmount = this.getFloatData(RaevyxConstantsHandler.DATA_SCREEN_SHAKE_AMOUNT);
        return this.prevScreenShakeAmount + (currentAmount - this.prevScreenShakeAmount) * partialTicks;
    }

    @Override
    public double getShakeDistance() {
        return 25.0;
    }

    @Override
    public boolean canFeelShake(Entity player) {
        return true;
    }

    public void triggerScreenShake(float intensity) {
        this.screenShakeAmount = Math.max(this.screenShakeAmount, intensity);
        this.f_19804_.m_135381_(RaevyxConstantsHandler.DATA_SCREEN_SHAKE_AMOUNT, (Object)Float.valueOf(this.screenShakeAmount));
    }

    public static class DragonLookController
    extends LookControl {
        private final Raevyx dragon;

        public DragonLookController(Raevyx dragon) {
            super((Mob)dragon);
            this.dragon = dragon;
        }

        public void m_8128_() {
            if (!this.dragon.m_6084_()) {
                return;
            }
            LivingEntity rider = this.dragon.m_6688_();
            if (this.dragon.m_20160_() && rider != null) {
                boolean controlsLocked = this.dragon.areRiderControlsLocked();
                float baseYaw = this.dragon.m_146908_();
                float targetYaw = rider.m_146908_();
                float maxOffsetDeg = (this.dragon.m_29443_() ? 0.9f : 0.6f) * 57.295776f;
                float desiredOffset = Mth.m_14118_((float)baseYaw, (float)targetYaw);
                float clampedOffset = controlsLocked ? Mth.m_14148_((float)0.0f, (float)desiredOffset, (float)6.0f) : Mth.m_14036_((float)desiredOffset, (float)(-maxOffsetDeg), (float)maxOffsetDeg);
                float headYaw = baseYaw + clampedOffset;
                this.dragon.m_5616_(headYaw);
                if (!controlsLocked) {
                    float minPitch = this.dragon.getRiderLockPitchMin();
                    float maxPitch = this.dragon.getRiderLockPitchMax();
                    float targetPitch = Mth.m_14036_((float)rider.m_146909_(), (float)minPitch, (float)maxPitch);
                    float newPitch = Mth.m_14148_((float)this.dragon.m_146909_(), (float)targetPitch, (float)7.0f);
                    this.dragon.m_146926_(newPitch);
                } else {
                    float easedPitch = Mth.m_14148_((float)this.dragon.m_146909_(), (float)0.0f, (float)6.0f);
                    this.dragon.m_146926_(easedPitch);
                }
                return;
            }
            super.m_8128_();
        }
    }
}

