/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.HitResult;

public class DragonKeybindHandler {
    private final DragonEntity dragon;
    private byte controlState = 0;

    public DragonKeybindHandler(DragonEntity dragon) {
        this.dragon = dragon;
    }

    public void setControlState(byte controlState) {
        boolean prevSummon;
        byte previous = this.controlState;
        this.controlState = controlState;
        boolean up = (controlState & 1) != 0;
        boolean down = (controlState & 2) != 0;
        boolean attack = (controlState & 4) != 0;
        boolean roar = (controlState & 8) != 0;
        boolean summon = (controlState & 0x10) != 0;
        this.dragon.setGoingUp(up);
        this.dragon.setGoingDown(down);
        boolean prevAttack = (previous & 4) != 0;
        boolean prevRoar = (previous & 8) != 0;
        boolean bl = prevSummon = (previous & 0x10) != 0;
        if (this.dragon.getRidingPlayer() != null) {
            DragonAbilityType<?, ?> summonAbility;
            DragonAbilityType<?, ?> roarAbility;
            DragonAbilityType<?, ?> chosen;
            HitResult hitResult;
            Player rider = this.dragon.getRidingPlayer();
            if (!prevAttack && attack && (hitResult = rider.m_19907_(6.0, 1.0f, false)).m_6662_() != HitResult.Type.ENTITY && (chosen = this.dragon.getPrimaryAttackAbility()) != null && this.dragon.combatManager.canStart(chosen)) {
                float yaw = rider.m_146908_();
                float pitch = rider.m_146909_();
                if (pitch > 35.0f) {
                    pitch = 35.0f;
                }
                if (pitch < -35.0f) {
                    pitch = -35.0f;
                }
                this.dragon.m_146922_(yaw);
                this.dragon.f_20883_ = yaw;
                this.dragon.f_20885_ = yaw;
                this.dragon.m_146926_(pitch);
                this.dragon.combatManager.tryUseAbility(chosen);
            }
            if (!prevRoar && roar && (roarAbility = this.dragon.getRoaringAbility()) != null && this.dragon.combatManager.canStart(roarAbility)) {
                this.dragon.combatManager.tryUseAbility(roarAbility);
            }
            if (!prevSummon && summon && (summonAbility = this.dragon.getChannelingAbility()) != null && this.dragon.combatManager.canStart(summonAbility)) {
                this.dragon.combatManager.tryUseAbility(summonAbility);
            }
        }
    }

    private void setStateField(int bit, boolean value) {
        this.controlState = value ? (byte)(this.controlState | (byte)(1 << bit)) : (byte)(this.controlState & (byte)(~(1 << bit)));
    }

    public void up(boolean up) {
        this.setStateField(0, up);
    }

    public void down(boolean down) {
        this.setStateField(1, down);
    }
}

