/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animation.AnimationController;

public class DragonSoundHandler {
    private final DragonEntity dragon;
    private final DragonSoundProfile profile;
    private static final int MIN_OVERLAP_GUARD_TICKS = 5;
    private static final Set<String> DEFAULT_NON_OVERLAPPING_KEYS = Set.of("hurt", "stegonaut_hurt", "cindervane_hurt", "primitive_drake_hurt", "die", "raevyx_hurt", "raevyx_die");
    private static final Map<String, Integer> GENERIC_VOCAL_WINDOWS = Map.of("hurt", 20, "die", 62);
    private final Map<String, Integer> vocalCooldowns = new HashMap<String, Integer>();
    private static final int WALK_STEP_SEPARATION_TICKS = 12;
    private static final int RUN_STEP_SEPARATION_TICKS = 10;
    private long lastStep1Tick = Long.MIN_VALUE;
    private long lastStep2Tick = Long.MIN_VALUE;
    private PendingStep pendingStep1 = null;
    private PendingStep pendingStep2 = null;

    public DragonSoundHandler(DragonEntity dragon) {
        this.dragon = dragon;
        DragonSoundProfile providedProfile = dragon.getSoundProfile();
        this.profile = providedProfile != null ? providedProfile : DragonSoundProfile.EMPTY;
    }

    public void tick() {
        if (this.dragon.isDying()) {
            this.pendingStep1 = null;
            this.pendingStep2 = null;
            return;
        }
        if (this.pendingStep1 != null && --this.pendingStep1.ticksLeft <= 0) {
            this.actuallyPlayStep(this.pendingStep1.key, this.pendingStep1.locator);
            this.pendingStep1 = null;
        }
        if (this.pendingStep2 != null && --this.pendingStep2.ticksLeft <= 0) {
            this.actuallyPlayStep(this.pendingStep2.key, this.pendingStep2.locator);
            this.pendingStep2 = null;
        }
    }

    public void handleAnimationSound(DragonEntity entity, Object keyframeData, AnimationController<?> controller) {
        String raw;
        if (this.dragon.isDying()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (keyframeData == null) {
            return;
        }
        String controllerName = null;
        try {
            if (controller != null && controller.getName() != null) {
                controllerName = controller.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean sittingMuted = this.dragon.isStayOrSitMuted();
        boolean sleeping = this.dragon.m_5803_();
        boolean sleepTransitioning = this.dragon.isSleepTransitioning();
        if (sleeping) {
            return;
        }
        if (sleepTransitioning && !"action".equals(controllerName)) {
            return;
        }
        String locator = null;
        try {
            raw = (String)keyframeData.getClass().getMethod("getSound", new Class[0]).invoke(keyframeData, new Object[0]);
            try {
                locator = (String)keyframeData.getClass().getMethod("getLocator", new Class[0]).invoke(keyframeData, new Object[0]);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            return;
        }
        if (raw == null || raw.isEmpty()) {
            return;
        }
        String sound = raw.toLowerCase(Locale.ROOT);
        if (sound.contains(":")) {
            this.handleAutoSoundSpec(sound);
            return;
        }
        String normalizedForFlap = null;
        if (sound.contains("flap")) {
            normalizedForFlap = sound.substring(sound.indexOf("flap"));
        }
        String normalizedForStep = null;
        if (sound.contains("step")) {
            normalizedForStep = sound.substring(sound.indexOf("step"));
        }
        if (this.profile.handleAnimationSound(this, this.dragon, sound, locator)) {
            return;
        }
        if (sittingMuted) {
            return;
        }
        if (normalizedForFlap != null && normalizedForFlap.startsWith("flap")) {
            this.handleWingFlapSound(normalizedForFlap);
            return;
        }
        if (normalizedForStep != null && (normalizedForStep.startsWith("step") || normalizedForStep.startsWith("run_step"))) {
            try {
                String ctrl;
                if (controller != null && controller.getName() != null && !"movement".equals(ctrl = controller.getName())) {
                    return;
                }
            }
            catch (Throwable ctrl) {
                // empty catch block
            }
            String stepLocator = locator != null && !locator.isEmpty() ? locator : this.mapStepKeyToLocator(normalizedForStep);
            this.handleStepSound(normalizedForStep, stepLocator);
            return;
        }
        switch (sound) {
            case "wing_flap": {
                this.handleWingFlapSound(sound);
                break;
            }
            case "dragon_step": {
                this.handleStepSound(sound, null);
                break;
            }
            case "takeoff_whoosh": {
                this.handleTakeoffSound();
                break;
            }
            case "landing_thud": {
                this.handleLandingSound();
                break;
            }
            default: {
                this.handleSoundByName(sound);
            }
        }
    }

    public void handleSoundByName(String soundName) {
        if (this.dragon.isDying()) {
            return;
        }
        if (this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return;
        }
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        String key = soundName.toLowerCase(Locale.ROOT);
        if (this.profile.handleSoundByName(this, this.dragon, key)) {
            return;
        }
        if (key.startsWith("flap")) {
            this.handleWingFlapSound(key);
            return;
        }
        if (key.startsWith("step") || key.startsWith("run_step")) {
            this.handleStepSound(key, null);
            return;
        }
        switch (key) {
            case "wing_flap": {
                this.handleWingFlapSound(key);
                break;
            }
            case "dragon_step": {
                this.handleStepSound(key, null);
                break;
            }
            case "takeoff_whoosh": {
                this.handleTakeoffSound();
                break;
            }
            case "landing_thud": {
                this.handleLandingSound();
                break;
            }
        }
    }

    public void playVocal(String key) {
        boolean hasAnimation;
        Integer guard;
        boolean suppressOverlap;
        DragonEntity.VocalEntry entry2;
        if (key == null || key.isEmpty() || this.dragon.m_9236_().f_46443_) {
            return;
        }
        int currentTick = this.dragon.f_19797_;
        if (!this.vocalCooldowns.isEmpty()) {
            this.vocalCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= currentTick);
        }
        if ((entry2 = this.dragon.getVocalEntries().get(key)) == null) {
            entry2 = this.profile.getFallbackVocalEntry(key);
        }
        boolean bl = suppressOverlap = entry2 != null ? entry2.preventOverlap() : DEFAULT_NON_OVERLAPPING_KEYS.contains(key);
        if (suppressOverlap && (guard = this.vocalCooldowns.get(key)) != null && guard > currentTick) {
            return;
        }
        if (entry2 == null) {
            return;
        }
        if (!entry2.allowDuringSleep() && (this.dragon.m_5803_() || this.dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry2.allowWhenSitting() && this.dragon.isStayOrSitMuted()) {
            return;
        }
        int window = this.getVocalAnimationWindowTicks(key);
        if (suppressOverlap) {
            this.vocalCooldowns.put(key, currentTick + Math.max(window, 5));
        }
        boolean bl2 = hasAnimation = entry2.animationId() != null && !entry2.animationId().isEmpty();
        if (hasAnimation) {
            if (!this.dragon.m_9236_().f_46443_) {
                if (this.shouldBroadcastInstantly(key)) {
                    float pitch = entry2.basePitch();
                    float variance = entry2.pitchVariance();
                    if (variance != 0.0f) {
                        pitch += this.dragon.m_217043_().m_188501_() * variance;
                    }
                    this.playServerBroadcast(entry2.soundSupplier().get(), entry2.volume(), pitch, null);
                }
                if (!this.dragon.m_5803_() && !this.dragon.isSleepTransitioning() && window > 0) {
                    this.dragon.triggerAnim(entry2.controllerId(), key);
                }
            }
        } else if (!this.dragon.m_9236_().f_46443_) {
            float volume = entry2.volume();
            float pitch = entry2.basePitch();
            float variance = entry2.pitchVariance();
            if (variance != 0.0f) {
                pitch += this.dragon.m_217043_().m_188501_() * variance;
            }
            this.playServerBroadcast(entry2.soundSupplier().get(), volume, pitch, null);
        }
    }

    private int getVocalAnimationWindowTicks(String key) {
        if (key == null) {
            return 0;
        }
        int custom = this.profile.getVocalAnimationWindowTicks(key);
        if (custom >= 0) {
            return custom;
        }
        Integer generic = GENERIC_VOCAL_WINDOWS.get(key);
        if (generic != null) {
            return generic;
        }
        return 40;
    }

    private boolean shouldBroadcastInstantly(String key) {
        return DEFAULT_NON_OVERLAPPING_KEYS.contains(key);
    }

    private void handleWingFlapSound(String key) {
        if (this.dragon.isStayOrSitMuted()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        double flightSpeed = this.dragon.getCachedHorizontalSpeed();
        float pitch = 1.0f + (float)(flightSpeed * (double)0.3f);
        float volume = Math.max(0.6f, 0.9f + (float)(flightSpeed * (double)0.2f));
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), (SoundEvent)ModSounds.RAEVYX_FLAP1.get(), SoundSource.NEUTRAL, volume, pitch, false);
    }

    private void handleStepSound(String key, String locator) {
        if (this.dragon.isStayOrSitMuted()) {
            return;
        }
        boolean running = this.dragon.isActuallyRunning() && !this.dragon.isFlying();
        boolean walking = !running && this.dragon.isWalking() && !this.dragon.isFlying();
        long now = this.dragon.f_19797_;
        if (key != null && key.endsWith("2")) {
            if (walking || running) {
                String k2;
                int desired = 0;
                int delay = this.requiredDelayTicks(now - this.lastStep1Tick, desired);
                String string = k2 = key.startsWith("run_step") ? "run_step2" : "step2";
                if (delay > 0) {
                    this.pendingStep2 = new PendingStep(k2, locator, delay);
                } else {
                    this.actuallyPlayStep(k2, locator);
                }
            } else {
                String k2 = key.startsWith("run_step") ? "run_step2" : "step2";
                this.actuallyPlayStep(k2, locator);
            }
        } else if (walking || running) {
            String k1;
            int desired = walking ? 12 : 10;
            int delay = this.requiredDelayTicks(now - this.lastStep2Tick, desired);
            assert (key != null);
            String string = k1 = key.startsWith("run_step") ? "run_step1" : "step1";
            if (delay > 0) {
                this.pendingStep1 = new PendingStep(k1, locator, delay);
            } else {
                this.actuallyPlayStep(k1, locator);
            }
        } else {
            assert (key != null);
            String k1 = key.startsWith("run_step") ? "run_step1" : "step1";
            this.actuallyPlayStep(k1, locator);
        }
    }

    private int requiredDelayTicks(long deltaTicks, int desired) {
        if (deltaTicks == Long.MIN_VALUE) {
            return 0;
        }
        if (deltaTicks < (long)desired) {
            return desired - (int)deltaTicks;
        }
        return 0;
    }

    private void actuallyPlayStep(String which, String locator) {
        double z;
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        float weight = 1.0f;
        if (this.dragon.isRunning()) {
            weight *= 1.2f;
        }
        if (this.dragon.m_20160_()) {
            weight *= 1.1f;
        }
        if (this.dragon.m_21223_() < this.dragon.m_21233_() * 0.5f) {
            weight *= 0.9f;
        }
        float volume = 0.65f * weight;
        float pitch = (0.9f + this.dragon.m_217043_().m_188501_() * 0.2f) / weight;
        Vec3 at = this.resolveLocatorWorldPos(locator);
        boolean isRun = which != null && which.startsWith("run_step");
        boolean isSecond = which != null && which.endsWith("2");
        double x = at != null ? at.f_82479_ : this.dragon.m_20185_();
        double y = at != null ? at.f_82480_ : this.dragon.m_20186_();
        double d = z = at != null ? at.f_82481_ : this.dragon.m_20189_();
        if (isRun) {
            if (isSecond) {
                this.dragon.m_9236_().m_7785_(x, y, z, (SoundEvent)ModSounds.RAEVYX_RUN_STEP2.get(), SoundSource.NEUTRAL, volume, pitch, false);
                this.lastStep2Tick = this.dragon.f_19797_;
            } else {
                this.dragon.m_9236_().m_7785_(x, y, z, (SoundEvent)ModSounds.RAEVYX_RUN_STEP1.get(), SoundSource.NEUTRAL, volume, pitch, false);
                this.lastStep1Tick = this.dragon.f_19797_;
            }
        } else if (isSecond) {
            this.dragon.m_9236_().m_7785_(x, y, z, (SoundEvent)ModSounds.RAEVYX_STEP2.get(), SoundSource.NEUTRAL, volume, pitch, false);
            this.lastStep2Tick = this.dragon.f_19797_;
        } else {
            this.dragon.m_9236_().m_7785_(x, y, z, (SoundEvent)ModSounds.RAEVYX_STEP1.get(), SoundSource.NEUTRAL, volume, pitch, false);
            this.lastStep1Tick = this.dragon.f_19797_;
        }
    }

    private void handleAutoSoundSpec(String spec) {
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (spec == null) {
            return;
        }
        String[] parts = spec.split("\\|");
        String id = parts[0];
        float vol = 1.0f;
        float pitch = 1.0f;
        try {
            if (parts.length >= 2) {
                vol = Float.parseFloat(parts[1]);
            }
            if (parts.length >= 3) {
                pitch = Float.parseFloat(parts[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        if (rl == null) {
            return;
        }
        SoundEvent evt = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
        if (evt == null) {
            return;
        }
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), evt, SoundSource.NEUTRAL, vol, pitch, false);
    }

    private void playServerBroadcast(SoundEvent sound, float volume, float pitch, Vec3 position) {
        if (this.dragon.m_9236_().f_46443_) {
            return;
        }
        double x = position != null ? position.f_82479_ : this.dragon.m_20185_();
        double y = position != null ? position.f_82480_ : this.dragon.m_20186_();
        double z = position != null ? position.f_82481_ : this.dragon.m_20189_();
        this.dragon.m_9236_().m_6263_(null, x, y, z, sound, SoundSource.NEUTRAL, volume, pitch);
    }

    private String mapStepKeyToLocator(String key) {
        if (key == null) {
            return null;
        }
        String k = key.toLowerCase(Locale.ROOT).trim();
        if (k.endsWith("1")) {
            return "rightfeetLocator";
        }
        if (k.endsWith("2")) {
            return "leftfeetLocator";
        }
        return null;
    }

    public Vec3 resolveLocatorWorldPos(String locator) {
        double lz;
        double ly;
        double lx;
        if (locator == null || locator.isEmpty()) {
            return null;
        }
        switch (locator) {
            case "leftfeetLocator": {
                lx = 2.2;
                ly = 0.05;
                lz = 2.85;
                break;
            }
            case "rightfeetLocator": {
                lx = -2.2;
                ly = 0.05;
                lz = 2.85;
                break;
            }
            case "mouth_origin": {
                Vec3 dynamic = this.dragon.getMouthPosition();
                if (dynamic != null) {
                    return dynamic;
                }
                lx = 0.1;
                ly = 8.7;
                lz = -17.4;
                break;
            }
            case "bodyLocator": {
                lx = 0.0;
                ly = 10.0;
                lz = 0.0;
                break;
            }
            default: {
                return null;
            }
        }
        Vec3 cached = this.dragon.getClientLocatorPosition(locator);
        if (cached != null) {
            return cached;
        }
        double modelScale = this.dragon.m_20205_() / 4.5f;
        double sx = lx / 16.0 * modelScale;
        double sy = ly / 16.0 * modelScale;
        double sz = lz / 16.0 * modelScale;
        double yawDeg = this.dragon.f_20883_;
        double cy = Math.cos(Math.toRadians(yawDeg));
        double syaw = Math.sin(Math.toRadians(yawDeg));
        double rx = sx * cy - sz * syaw;
        double rz = sx * syaw + sz * cy;
        return new Vec3(this.dragon.m_20185_() + rx, this.dragon.m_20186_() + sy, this.dragon.m_20189_() + rz);
    }

    private void handleTakeoffSound() {
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        float urgency = this.dragon.m_5448_() != null ? 1.3f : 1.0f;
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), SoundEvents.f_11893_, SoundSource.NEUTRAL, urgency * 1.2f, 0.85f, false);
    }

    private void handleLandingSound() {
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_()) {
            return;
        }
        double impactSpeed = Math.abs(this.dragon.m_20184_().f_82480_);
        float volume = (float)Math.max((double)0.8f, 1.0 + impactSpeed * 2.0);
        float pitch = (float)Math.max((double)0.7f, 1.0 - impactSpeed * (double)0.3f);
        this.dragon.m_5496_(SoundEvents.f_11913_, volume * 0.6f, pitch);
    }

    private static class PendingStep {
        String key;
        String locator;
        int ticksLeft;

        PendingStep(String key, String locator, int ticksLeft) {
            this.key = key;
            this.locator = locator;
            this.ticksLeft = ticksLeft;
        }
    }
}

