/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client;

import com.leon.saintsdragons.client.DragonStatusUIManager;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.network.MessageDragonRideInput;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DragonRideKeybinds {
    public static final KeyMapping DRAGON_ASCEND = new KeyMapping("key.saintsdragons.ascend", InputConstants.Type.KEYSYM, 32, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_DESCEND = new KeyMapping("key.saintsdragons.descend", InputConstants.Type.KEYSYM, 342, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_ACCELERATE = new KeyMapping("key.saintsdragons.accelerate", InputConstants.Type.KEYSYM, 341, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_TERTIARY_ABILITY = new KeyMapping("key.saintsdragons.ability_tertiary", InputConstants.Type.KEYSYM, 71, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_PRIMARY_ABILITY = new KeyMapping("key.saintsdragons.ability_primary", InputConstants.Type.KEYSYM, 82, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_SECONDARY_ABILITY = new KeyMapping("key.saintsdragons.ability_secondary", InputConstants.Type.KEYSYM, 72, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_TOGGLE_MELEE = new KeyMapping("key.saintsdragons.toggle_melee", InputConstants.Type.KEYSYM, 88, "key.categories.saintsdragons");
    private static boolean wasAscendPressed = false;
    private static boolean wasAccelerateDown = false;
    private static boolean wasTertiaryAbilityDown = false;
    private static boolean wasPrimaryAbilityDown = false;
    private static boolean wasSecondaryAbilityDown = false;
    private static boolean wasAttackDown = false;
    private static boolean wasToggleMeleeDown = false;
    private static int meleeCooldownTicks = 0;
    private static float lastForward = 0.0f;
    private static float lastStrafe = 0.0f;
    private static float lastYaw = 0.0f;
    private static boolean lastAscendDown = false;
    private static boolean lastDescendDown = false;

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        RideableDragonBase dragon;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            DragonRideKeybinds.resetStateTracking();
            return;
        }
        Entity vehicle = player.m_20202_();
        if (!(vehicle instanceof RideableDragonBase) || !(dragon = (RideableDragonBase)vehicle).canBeControlledBy((Player)player)) {
            DragonRideKeybinds.resetStateTracking();
            return;
        }
        DragonRideKeybinds.handleGenericControls(player, dragon);
    }

    private static void handleGenericControls(LocalPlayer player, RideableDragonBase dragon) {
        boolean movementChanged;
        if (meleeCooldownTicks > 0) {
            --meleeCooldownTicks;
        }
        boolean ascendDown = DRAGON_ASCEND.m_90857_();
        boolean descendDown = DRAGON_DESCEND.m_90857_();
        boolean accelerateDown = DRAGON_ACCELERATE.m_90857_();
        boolean tertiaryDown = DRAGON_TERTIARY_ABILITY.m_90857_();
        boolean primaryDown = DRAGON_PRIMARY_ABILITY.m_90857_();
        boolean secondaryDown = DRAGON_SECONDARY_ABILITY.m_90857_();
        boolean toggleMeleeDown = DRAGON_TOGGLE_MELEE.m_90857_();
        Minecraft mc = Minecraft.m_91087_();
        boolean attackDown = mc.f_91066_.f_92096_.m_90857_();
        boolean sneakDown = mc.f_91066_.f_92090_.m_90857_();
        float forward = player.f_20902_;
        float strafe = player.f_20900_;
        float yaw = player.m_146908_();
        boolean bl = movementChanged = forward != lastForward || strafe != lastStrafe || Math.abs(yaw - lastYaw) > 0.1f || ascendDown != lastAscendDown || descendDown != lastDescendDown;
        if (movementChanged) {
            DragonRideKeybinds.sendInput(ascendDown, descendDown, DragonRiderAction.NONE, null, forward, strafe, yaw);
            lastForward = forward;
            lastStrafe = strafe;
            lastYaw = yaw;
            lastAscendDown = ascendDown;
            lastDescendDown = descendDown;
        }
        if (accelerateDown != wasAccelerateDown) {
            DragonRiderAction action = accelerateDown ? DragonRiderAction.ACCELERATE : DragonRiderAction.STOP_ACCELERATE;
            DragonRideKeybinds.sendInput(ascendDown, descendDown, action, null, forward, strafe, yaw);
        }
        if (ascendDown && !wasAscendPressed && !dragon.m_29443_()) {
            DragonRideKeybinds.sendInput(false, false, DragonRiderAction.TAKEOFF_REQUEST, null, forward, strafe, yaw);
        }
        if (toggleMeleeDown && !wasToggleMeleeDown && meleeCooldownTicks == 0) {
            if (dragon.hasSecondaryMelee()) {
                DragonRideKeybinds.sendInput(false, false, DragonRiderAction.TOGGLE_MELEE, null, forward, strafe, yaw);
                meleeCooldownTicks = 60;
                int newMode = (dragon.getMeleeMode() + 1) % 2;
                DragonStatusUIManager.getInstance().getDragonStatusUI().getMeleeModeNotification().showNotification(newMode);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.no_secondary_melee"), true);
            }
        }
        DragonRideKeybinds.handleAbilityBinding(dragon.getTertiaryRiderAbility(), tertiaryDown, wasTertiaryAbilityDown, forward, strafe, yaw);
        DragonRideKeybinds.handleAbilityBinding(dragon.getPrimaryRiderAbility(), primaryDown, wasPrimaryAbilityDown, forward, strafe, yaw);
        DragonRideKeybinds.handleAbilityBinding(dragon.getSecondaryRiderAbility(), secondaryDown, wasSecondaryAbilityDown, forward, strafe, yaw);
        DragonRideKeybinds.handleAbilityBinding(dragon.getAttackRiderAbility(), attackDown, wasAttackDown, forward, strafe, yaw);
        wasAscendPressed = ascendDown;
        wasAccelerateDown = accelerateDown;
        wasTertiaryAbilityDown = tertiaryDown;
        wasPrimaryAbilityDown = primaryDown;
        wasSecondaryAbilityDown = secondaryDown;
        wasAttackDown = attackDown;
        wasToggleMeleeDown = toggleMeleeDown;
    }

    private static void handleAbilityBinding(RideableDragonBase.RiderAbilityBinding binding, boolean currentDown, boolean previousDown, float forward, float strafe, float yaw) {
        if (binding == null) {
            return;
        }
        String abilityId = binding.abilityId();
        if (abilityId == null || abilityId.isEmpty()) {
            return;
        }
        RideableDragonBase.RiderAbilityBinding.Activation activation = binding.activation();
        if (activation == RideableDragonBase.RiderAbilityBinding.Activation.PRESS) {
            if (currentDown && !previousDown) {
                DragonRideKeybinds.sendInput(false, false, DragonRiderAction.ABILITY_USE, abilityId, forward, strafe, yaw);
            }
        } else if (activation == RideableDragonBase.RiderAbilityBinding.Activation.HOLD) {
            if (currentDown && !previousDown) {
                DragonRideKeybinds.sendInput(false, false, DragonRiderAction.ABILITY_USE, abilityId, forward, strafe, yaw);
            } else if (!currentDown && previousDown) {
                DragonRideKeybinds.sendInput(false, false, DragonRiderAction.ABILITY_STOP, abilityId, forward, strafe, yaw);
            }
        }
    }

    private static void sendInput(boolean goingUp, boolean goingDown, DragonRiderAction action, String abilityName, float forward, float strafe, float yaw) {
        NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new MessageDragonRideInput(goingUp, goingDown, action, abilityName, forward, strafe, yaw));
    }

    private static void resetStateTracking() {
        wasAscendPressed = false;
        wasAccelerateDown = false;
        wasTertiaryAbilityDown = false;
        wasPrimaryAbilityDown = false;
        wasSecondaryAbilityDown = false;
        wasAttackDown = false;
        wasToggleMeleeDown = false;
        meleeCooldownTicks = 0;
        lastForward = 0.0f;
        lastStrafe = 0.0f;
        lastYaw = 0.0f;
        lastAscendDown = false;
        lastDescendDown = false;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModEventHandler {
        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            event.register(DRAGON_ASCEND);
            event.register(DRAGON_DESCEND);
            event.register(DRAGON_ACCELERATE);
            event.register(DRAGON_TERTIARY_ABILITY);
            event.register(DRAGON_PRIMARY_ABILITY);
            event.register(DRAGON_SECONDARY_ABILITY);
            event.register(DRAGON_TOGGLE_MELEE);
        }
    }
}

