/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.model.raevyx;

import com.leon.saintsdragons.SaintsDragons;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.state.BoneSnapshot;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class RaevyxModel
extends DefaultedEntityGeoModel<Raevyx> {
    private static final ResourceLocation ADULT_MODEL = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"geo/entity/raevyx.geo.json");
    private static final ResourceLocation FEMALE_MODEL = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"geo/entity/raevyx.geo.json");
    private static final ResourceLocation BABY_MODEL = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"geo/entity/baby_raevyx.geo.json");
    private static final ResourceLocation ADULT_ANIM = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"animations/entity/raevyx.animation.json");
    private static final ResourceLocation BABY_ANIM = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"animations/entity/baby_raevyx.animation.json");
    private static final ResourceLocation MALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/raevyx.png");
    private static final ResourceLocation FEMALE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/raevyx_female.png");
    private static final ResourceLocation BABY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"saintsdragons", (String)"textures/entity/raevyx/baby_raevyx.png");
    private float prevTailDragVelocity = 0.0f;

    public RaevyxModel() {
        super(SaintsDragons.rl("raevyx"), "head");
    }

    public ResourceLocation getModelResource(Raevyx entity) {
        if (entity.m_6162_()) {
            return BABY_MODEL;
        }
        if (entity.isFemale()) {
            return FEMALE_MODEL;
        }
        return ADULT_MODEL;
    }

    public ResourceLocation getTextureResource(Raevyx entity) {
        if (entity.m_6162_()) {
            return BABY_TEXTURE;
        }
        return entity.isFemale() ? FEMALE_TEXTURE : MALE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(Raevyx entity) {
        return entity.m_6162_() ? BABY_ANIM : ADULT_ANIM;
    }

    public void setCustomAnimations(Raevyx entity, long instanceId, AnimationState<Raevyx> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        float partialTick = animationState.getPartialTick();
        if (entity.m_6084_()) {
            this.applyBodyRotationDeviation(entity, partialTick);
            this.applyBankingRoll(entity, animationState);
            this.applyNeckFollow(entity, animationState);
            this.applyTailDrag(entity, partialTick);
        }
    }

    private void applyBodyRotationDeviation(Raevyx entity, float partialTick) {
        Optional rootOpt = this.getBone("body");
        if (rootOpt.isEmpty()) {
            return;
        }
        GeoBone root = (GeoBone)rootOpt.get();
        BoneSnapshot snap = root.getInitialSnapshot();
        double deviation = entity.bodyRotDeviation.get(partialTick);
        float deviationRad = (float)(deviation * 0.01745329238474369);
        root.setRotY(snap.getRotY() - deviationRad);
    }

    private void applyBankingRoll(Raevyx entity, AnimationState<Raevyx> state) {
        Optional bodyOpt = this.getBone("body");
        if (bodyOpt.isEmpty()) {
            return;
        }
        GeoBone body = (GeoBone)bodyOpt.get();
        BoneSnapshot snap = body.getInitialSnapshot();
        float partialTick = state.getPartialTick();
        float bankAngleDeg = entity.getBankAngleDegrees(partialTick);
        float bankAngleRad = Mth.m_14036_((float)(-bankAngleDeg * ((float)Math.PI / 180)), (float)-1.5707964f, (float)1.5707964f);
        body.setRotZ(snap.getRotZ() + bankAngleRad);
    }

    private void applyNeckFollow(Raevyx entity, AnimationState<Raevyx> state) {
        Optional headOpt = this.getBone("head");
        if (headOpt.isEmpty()) {
            return;
        }
        GeoBone head = (GeoBone)headOpt.get();
        float headDeltaX = head.getRotX() - head.getInitialSnapshot().getRotX();
        float headDeltaY = head.getRotY() - head.getInitialSnapshot().getRotY();
        head.setRotX(head.getInitialSnapshot().getRotX());
        head.setRotY(head.getInitialSnapshot().getRotY());
        this.applyNeckBoneFollow("neck1LookControl", headDeltaX, headDeltaY, 0.2f);
        this.applyNeckBoneFollow("neck2LookControl", headDeltaX, headDeltaY, 0.25f);
        this.applyNeckBoneFollow("neck3LookControl", headDeltaX, headDeltaY, 0.3f);
        this.applyNeckBoneFollow("neck4LookControl", headDeltaX, headDeltaY, 0.35f);
    }

    private void applyNeckBoneFollow(String boneName, float headDeltaX, float headDeltaY, float weight) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        BoneSnapshot snap = bone.getInitialSnapshot();
        float addX = headDeltaX * weight;
        float addY = headDeltaY * weight;
        bone.setRotX(snap.getRotX() + addX);
        bone.setRotY(snap.getRotY() + addY);
    }

    private void applyTailDrag(Raevyx entity, float partialTick) {
        float smoothedVelocity;
        double velocity = entity.yawVelocity.get(partialTick);
        velocity = Mth.m_14008_((double)velocity, (double)-30.0, (double)30.0);
        float targetVelocity = (float)velocity;
        this.prevTailDragVelocity = smoothedVelocity = Mth.m_14179_((float)0.15f, (float)this.prevTailDragVelocity, (float)targetVelocity);
        float velocityRad = smoothedVelocity * ((float)Math.PI / 180);
        this.applyTailBoneRotation("tail1Controller", velocityRad * 0.5f);
        this.applyTailBoneRotation("tail2Controller", velocityRad * 0.75f);
        this.applyTailBoneRotation("tail3Controller", velocityRad * 1.0f);
        this.applyTailBoneRotation("tail4Controller", velocityRad * 1.25f);
        this.applyTailBoneRotation("tail5Controller", velocityRad * 1.75f);
    }

    private void applyTailBoneRotation(String boneName, float rotationY) {
        Optional boneOpt = this.getBone(boneName);
        if (boneOpt.isEmpty()) {
            return;
        }
        GeoBone bone = (GeoBone)boneOpt.get();
        bone.setRotY(bone.getRotY() + rotationY);
    }
}

