/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.ui;

import com.leon.saintsdragons.client.DragonRideKeybinds;
import com.leon.saintsdragons.client.ui.DragonUIElement;
import com.leon.saintsdragons.common.registry.AbilityRegistry;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class DragonControlGuide
extends DragonUIElement {
    private static final int BASE_WIDTH = 150;
    private static final int TITLE_COLOR = -1;
    private static final int KEY_BG_DARK = -13421773;
    private static final int KEY_BG_LIGHT = -10066330;
    private static final int COLOR_ATTACK = -42406;
    private static final int COLOR_MOVEMENT = -16711681;
    private static final int COLOR_ABILITY = -14267;
    private DragonEntity dragon;
    private final List<ControlEntry> controls = new ArrayList<ControlEntry>();
    private Component cachedTitle = null;
    private int cachedTitleWidth = -1;

    public DragonControlGuide(int x, int y) {
        super(x, y, 150, 80);
    }

    public void setDragon(DragonEntity dragon) {
        this.dragon = dragon;
        this.updateControls();
    }

    private void updateControls() {
        RideableDragonBase base;
        this.controls.clear();
        if (this.dragon == null) {
            this.height = 0;
            this.width = 150;
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Options options = mc.f_91066_;
        Font font = mc.f_91062_;
        DragonEntity dragonEntity = this.dragon;
        RideableDragonBase rideable = dragonEntity instanceof RideableDragonBase ? (base = (RideableDragonBase)dragonEntity) : null;
        boolean attackHandledByAbility = false;
        if (rideable != null) {
            attackHandledByAbility = this.addAbilityEntry(rideable.getAttackRiderAbility(), options.f_92096_, "saintsdragons.ui.control.attack", -42406);
        }
        if (!attackHandledByAbility) {
            this.controls.add(ControlEntry.forKey(options.f_92096_, (Component)Component.m_237115_((String)"saintsdragons.ui.control.attack"), -42406));
        }
        this.controls.add(ControlEntry.forKey(DragonRideKeybinds.DRAGON_ASCEND, (Component)Component.m_237115_((String)"saintsdragons.ui.control.ascend"), -16711681));
        this.controls.add(ControlEntry.forKey(DragonRideKeybinds.DRAGON_DESCEND, (Component)Component.m_237115_((String)"saintsdragons.ui.control.descend"), -16711681));
        this.controls.add(ControlEntry.forKey(DragonRideKeybinds.DRAGON_ACCELERATE, (Component)Component.m_237115_((String)"saintsdragons.ui.control.accelerate"), -16711681));
        if (rideable != null) {
            this.addAbilityEntry(rideable.getPrimaryRiderAbility(), DragonRideKeybinds.DRAGON_PRIMARY_ABILITY, "saintsdragons.ui.control.ability_primary", -14267);
            this.addAbilityEntry(rideable.getSecondaryRiderAbility(), DragonRideKeybinds.DRAGON_SECONDARY_ABILITY, "saintsdragons.ui.control.ability_secondary", -14267);
            this.addAbilityEntry(rideable.getTertiaryRiderAbility(), DragonRideKeybinds.DRAGON_TERTIARY_ABILITY, "saintsdragons.ui.control.ability_tertiary", -14267);
            this.controls.add(ControlEntry.forKey(DragonRideKeybinds.DRAGON_TOGGLE_MELEE, (Component)Component.m_237115_((String)"saintsdragons.ui.control.toggle_melee"), -42406));
        }
        Objects.requireNonNull(font);
        int lineSpacing = 9 + 2;
        int contentHeight = 14 + this.controls.size() * lineSpacing + 4;
        this.height = Math.max(40, contentHeight);
        int maxWidth = 150;
        for (ControlEntry control : this.controls) {
            Component key = control.getKeyComponent();
            if (key.getString().isEmpty()) continue;
            int keyWidth = control.getKeyWidth(font);
            int functionWidth = control.getFunctionWidth(font);
            maxWidth = Math.max(maxWidth, keyWidth + functionWidth + 14);
        }
        this.width = maxWidth;
    }

    private boolean addAbilityEntry(@Nullable RideableDragonBase.RiderAbilityBinding binding, KeyMapping keyMapping, String slotTranslationKey, int color) {
        if (binding == null || binding.abilityId() == null || binding.abilityId().isEmpty()) {
            return false;
        }
        Component label = this.buildAbilityLabel(slotTranslationKey, binding.abilityId());
        this.controls.add(ControlEntry.forKey(keyMapping, label, color));
        return true;
    }

    private Component buildAbilityLabel(String slotTranslationKey, String abilityId) {
        MutableComponent slot = Component.m_237115_((String)slotTranslationKey);
        DragonAbilityType<?, ?> abilityType = AbilityRegistry.get(abilityId);
        MutableComponent abilityName = abilityType != null ? Component.m_237115_((String)("saintsdragons.ability." + abilityType.getName())) : Component.m_237115_((String)("saintsdragons.ability." + abilityId));
        return Component.m_237110_((String)"saintsdragons.ui.control.ability_with_name", (Object[])new Object[]{slot, abilityName});
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible || this.dragon == null || this.dragon.m_21224_() || this.controls.isEmpty()) {
            return;
        }
        Font font = Minecraft.m_91087_().f_91062_;
        if (this.cachedTitle == null) {
            this.cachedTitle = Component.m_237115_((String)"saintsdragons.ui.control.title");
            this.cachedTitleWidth = font.m_92852_((FormattedText)this.cachedTitle);
        }
        guiGraphics.m_280430_(font, this.cachedTitle, this.x + (this.width - this.cachedTitleWidth) / 2, this.y + 2, -1);
        int startY = this.y + 14;
        Objects.requireNonNull(font);
        int lineSpacing = 9 + 2;
        for (int i = 0; i < this.controls.size(); ++i) {
            ControlEntry control = this.controls.get(i);
            Component keyComponent = control.getKeyComponent();
            if (keyComponent.getString().isEmpty()) continue;
            int keyWidth = control.getKeyWidth(font);
            int entryY = startY + i * lineSpacing;
            Objects.requireNonNull(font);
            guiGraphics.m_280509_(this.x + 2, entryY, this.x + 2 + keyWidth, entryY + 9 + 1, -13421773);
            Objects.requireNonNull(font);
            guiGraphics.m_280509_(this.x + 3, entryY + 1, this.x + 1 + keyWidth, entryY + 9, -10066330);
            guiGraphics.m_280430_(font, keyComponent, this.x + 4, entryY + 1, -1);
            guiGraphics.m_280430_(font, control.functionText, this.x + 2 + keyWidth + 4, entryY + 1, control.color);
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            this.renderDragHandle(guiGraphics);
        }
    }

    private void renderDragHandle(GuiGraphics guiGraphics) {
        int handleSize = 4;
        int handleX = this.x + this.width - handleSize - 2;
        int handleY = this.y + 2;
        guiGraphics.m_280509_(handleX, handleY, handleX + handleSize, handleY + handleSize, -1);
        guiGraphics.m_280509_(handleX + 1, handleY + 1, handleX + handleSize - 1, handleY + handleSize - 1, -16777216);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int handleSize = 4;
        int handleX = this.x + this.width - handleSize - 2;
        int handleY = this.y + 2;
        if (button == 0 && mouseX >= (double)handleX && mouseX <= (double)(handleX + handleSize) && mouseY >= (double)handleY && mouseY <= (double)(handleY + handleSize)) {
            this.startDragging(mouseX, mouseY);
            return true;
        }
        return false;
    }

    private static class ControlEntry {
        private final KeyMapping keyMapping;
        private final Component functionText;
        private final int color;
        private Component cachedKeyComponent = null;
        private int cachedKeyWidth = -1;
        private int cachedFunctionWidth = -1;

        private ControlEntry(KeyMapping keyMapping, Component functionText, int color) {
            this.keyMapping = keyMapping;
            this.functionText = functionText;
            this.color = color;
        }

        static ControlEntry forKey(KeyMapping keyMapping, Component functionText, int color) {
            return new ControlEntry(keyMapping, functionText, color);
        }

        Component getKeyComponent() {
            if (this.cachedKeyComponent == null) {
                this.cachedKeyComponent = this.keyMapping != null ? this.keyMapping.m_90863_() : Component.m_237119_();
            }
            return this.cachedKeyComponent;
        }

        int getKeyWidth(Font font) {
            if (this.cachedKeyWidth == -1) {
                this.cachedKeyWidth = font.m_92852_((FormattedText)this.getKeyComponent()) + 6;
            }
            return this.cachedKeyWidth;
        }

        int getFunctionWidth(Font font) {
            if (this.cachedFunctionWidth == -1) {
                this.cachedFunctionWidth = font.m_92852_((FormattedText)this.functionText);
            }
            return this.cachedFunctionWidth;
        }
    }
}

