/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.ui;

import com.leon.saintsdragons.client.ui.DragonUIElement;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DragonSpeedIndicator
extends DragonUIElement {
    private static final double BLOCKS_PER_TICK_TO_MPH = 44.738725;
    private static final float MIN_BASELINE_MPH = 5.0f;
    private static final float MAX_DECAY_FACTOR = 0.05f;
    private DragonEntity dragon;
    private float currentSpeedMph = 0.0f;
    private float maxSpeedMph = 5.0f;
    private float baselineMaxSpeedMph = 5.0f;
    private String cachedSpeedText = "";
    private int cachedSpeedTextWidth = 0;
    private int cachedLastSpeed = -1;

    public DragonSpeedIndicator(int x, int y) {
        super(x, y, 120, 16);
    }

    public void setDragon(DragonEntity dragon) {
        this.dragon = dragon;
        if (dragon != null) {
            this.maxSpeedMph = this.baselineMaxSpeedMph = this.resolveBaselineSpeedMph(dragon);
        } else {
            this.currentSpeedMph = 0.0f;
            this.baselineMaxSpeedMph = 5.0f;
            this.maxSpeedMph = 5.0f;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible || this.dragon == null || this.dragon.m_21224_()) {
            return;
        }
        this.updateSpeed();
        guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
        guiGraphics.m_280509_(this.x + 2, this.y + 2, this.x + this.width - 2, this.y + this.height - 2, -13421773);
        float speedPercent = this.maxSpeedMph <= 0.0f ? 0.0f : Math.min(this.currentSpeedMph / this.maxSpeedMph, 1.0f);
        int gaugeWidth = this.width - 4;
        int fillWidth = (int)((float)gaugeWidth * speedPercent);
        if (fillWidth > 0) {
            int color = this.getSpeedColor(speedPercent);
            guiGraphics.m_280509_(this.x + 2, this.y + 2, this.x + 2 + fillWidth, this.y + this.height - 2, color);
        }
        Font font = this.minecraft.f_91062_;
        int roundedSpeed = Math.round(this.currentSpeedMph);
        if (roundedSpeed != this.cachedLastSpeed) {
            this.cachedSpeedText = String.format("%.0f mph", Float.valueOf(this.currentSpeedMph));
            this.cachedSpeedTextWidth = font.m_92895_(this.cachedSpeedText);
            this.cachedLastSpeed = roundedSpeed;
        }
        int textX = this.x + this.width - this.cachedSpeedTextWidth - 2;
        Objects.requireNonNull(font);
        int textY = this.y + (this.height - 9) / 2;
        guiGraphics.m_280488_(font, this.cachedSpeedText, textX, textY, 0xFFFFFF);
        guiGraphics.m_280488_(font, "Speed:", this.x + 2, textY, 0xCCCCCC);
        if (this.isMouseOver(mouseX, mouseY)) {
            this.renderDragHandle(guiGraphics);
        }
    }

    private void updateSpeed() {
        if (this.dragon == null) {
            return;
        }
        double velX = this.dragon.m_20184_().f_82479_;
        double velY = this.dragon.m_20184_().f_82480_;
        double velZ = this.dragon.m_20184_().f_82481_;
        double blocksPerTick = Math.sqrt(velX * velX + velY * velY + velZ * velZ);
        this.currentSpeedMph = (float)(blocksPerTick * 44.738725);
        if (this.currentSpeedMph > this.maxSpeedMph) {
            this.maxSpeedMph = this.currentSpeedMph;
        } else if (this.maxSpeedMph > this.baselineMaxSpeedMph) {
            float decay = (this.maxSpeedMph - this.baselineMaxSpeedMph) * 0.05f;
            this.maxSpeedMph = Math.max(this.baselineMaxSpeedMph, this.maxSpeedMph - decay);
        }
    }

    private int getSpeedColor(float speedPercent) {
        if (speedPercent < 0.3f) {
            return -16711936;
        }
        if (speedPercent < 0.7f) {
            return -256;
        }
        if (speedPercent < 0.9f) {
            return -30720;
        }
        return -65536;
    }

    private void renderDragHandle(GuiGraphics guiGraphics) {
        int handleSize = 4;
        int handleX = this.x + this.width - handleSize - 2;
        int handleY = this.y + 2;
        guiGraphics.m_280509_(handleX, handleY, handleX + handleSize, handleY + handleSize, -1);
        guiGraphics.m_280509_(handleX + 1, handleY + 1, handleX + handleSize - 1, handleY + handleSize - 1, -16777216);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int handleSize = 4;
        int handleX = this.x + this.width - handleSize - 2;
        int handleY = this.y + 2;
        if (button == 0 && mouseX >= (double)handleX && mouseX <= (double)(handleX + handleSize) && mouseY >= (double)handleY && mouseY <= (double)(handleY + handleSize)) {
            this.startDragging(mouseX, mouseY);
            return true;
        }
        return false;
    }

    private float resolveBaselineSpeedMph(DragonEntity dragon) {
        AttributeInstance movement;
        double bestMph = 0.0;
        AttributeInstance flying = dragon.m_21051_(Attributes.f_22280_);
        if (flying != null) {
            bestMph = Math.max(bestMph, flying.m_22135_() * 44.738725);
        }
        if ((movement = dragon.m_21051_(Attributes.f_22279_)) != null) {
            bestMph = Math.max(bestMph, movement.m_22135_() * 44.738725);
        }
        if (bestMph <= 0.0) {
            bestMph = 5.0;
        }
        return (float)Math.max(5.0, bestMph);
    }
}

