/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.particle.raevyx;

import com.leon.saintsdragons.common.registry.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public record RaevyxLightningStormData(float size, boolean female) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<RaevyxLightningStormData> DESERIALIZER = new ParticleOptions.Deserializer<RaevyxLightningStormData>(){

        @NotNull
        public RaevyxLightningStormData fromCommand(@Nonnull ParticleType<RaevyxLightningStormData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            boolean female = false;
            if (reader.canRead() && reader.peek() == ' ') {
                reader.expect(' ');
                female = reader.readBoolean();
            }
            return new RaevyxLightningStormData(size, female);
        }

        @NotNull
        public RaevyxLightningStormData fromNetwork(@Nonnull ParticleType<RaevyxLightningStormData> type, @Nonnull FriendlyByteBuf buf) {
            return new RaevyxLightningStormData(buf.readFloat(), buf.readBoolean());
        }
    };

    public static Codec<RaevyxLightningStormData> CODEC(ParticleType<RaevyxLightningStormData> type) {
        return RecordCodecBuilder.create(b -> b.group((App)Codec.FLOAT.fieldOf("size").forGetter(RaevyxLightningStormData::size), (App)Codec.BOOL.optionalFieldOf("female", (Object)false).forGetter(RaevyxLightningStormData::female)).apply((Applicative)b, RaevyxLightningStormData::new));
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buf) {
        buf.writeFloat(this.size);
        buf.writeBoolean(this.female);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %s", ModParticles.LIGHTNING_STORM.getId(), Float.valueOf(this.size), Boolean.toString(this.female));
    }

    @NotNull
    public ParticleType<RaevyxLightningStormData> m_6012_() {
        return (ParticleType)ModParticles.LIGHTNING_STORM.get();
    }
}

