/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.world;

import com.leon.saintsdragons.common.config.SaintsDragonsConfig;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.world.SDWorldRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import org.jetbrains.annotations.NotNull;

public class AddDragonsBiomeModifier
implements BiomeModifier {
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            if ((Integer)SaintsDragonsConfig.RAEVYX_SPAWN_WEIGHT.get() > 0) {
                this.addDragonSpawn(builder, biome, "saintsdragons:has_raevyx", MobCategory.CREATURE, (EntityType)ModEntities.RAEVYX.get(), (Integer)SaintsDragonsConfig.RAEVYX_SPAWN_WEIGHT.get(), (Integer)SaintsDragonsConfig.RAEVYX_MIN_GROUP_SIZE.get(), (Integer)SaintsDragonsConfig.RAEVYX_MAX_GROUP_SIZE.get());
            }
            if ((Integer)SaintsDragonsConfig.STEGONAUT_SPAWN_WEIGHT.get() > 0) {
                this.addDragonSpawn(builder, biome, "saintsdragons:has_stegonaut", MobCategory.CREATURE, (EntityType)ModEntities.STEGONAUT.get(), (Integer)SaintsDragonsConfig.STEGONAUT_SPAWN_WEIGHT.get(), (Integer)SaintsDragonsConfig.STEGONAUT_MIN_GROUP_SIZE.get(), (Integer)SaintsDragonsConfig.STEGONAUT_MAX_GROUP_SIZE.get());
            }
            if ((Integer)SaintsDragonsConfig.CINDERVANE_SPAWN_WEIGHT.get() > 0) {
                this.addDragonSpawn(builder, biome, "saintsdragons:has_cindervane", MobCategory.CREATURE, (EntityType)ModEntities.CINDERVANE.get(), (Integer)SaintsDragonsConfig.CINDERVANE_SPAWN_WEIGHT.get(), (Integer)SaintsDragonsConfig.CINDERVANE_MIN_GROUP_SIZE.get(), (Integer)SaintsDragonsConfig.CINDERVANE_MAX_GROUP_SIZE.get());
            }
            if ((Integer)SaintsDragonsConfig.NULLJAW_SPAWN_WEIGHT.get() > 0) {
                this.addDragonSpawn(builder, biome, "saintsdragons:has_nulljaw", MobCategory.CREATURE, (EntityType)ModEntities.NULLJAW.get(), (Integer)SaintsDragonsConfig.NULLJAW_SPAWN_WEIGHT.get(), (Integer)SaintsDragonsConfig.NULLJAW_MIN_GROUP_SIZE.get(), (Integer)SaintsDragonsConfig.NULLJAW_MAX_GROUP_SIZE.get());
            }
        }
    }

    private void addDragonSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, String tagName, MobCategory category, EntityType<?> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (weight <= 0 || minGroupSize <= 0 || maxGroupSize <= 0) {
            return;
        }
        if (minGroupSize > maxGroupSize) {
            minGroupSize = maxGroupSize;
        }
        if (biome.getTagKeys().anyMatch(tag -> tag.f_203868_().toString().equals(tagName))) {
            builder.getMobSpawnSettings().m_48376_(category, new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize));
        }
    }

    @NotNull
    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SDWorldRegistry.ADD_DRAGONS_CODEC.get();
    }
}

