/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class CindervaneRestGoal
extends Goal {
    private final Cindervane amphithere;
    private int retryCooldown;

    public CindervaneRestGoal(Cindervane amphithere) {
        this.amphithere = amphithere;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        boolean isNight;
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.amphithere.getRestManager().isResting()) {
            return true;
        }
        if (this.amphithere.m_21824_()) {
            return false;
        }
        if (this.amphithere.m_21827_()) {
            return false;
        }
        if (this.amphithere.isSleepLocked()) {
            return false;
        }
        if (this.amphithere.m_20072_() || this.amphithere.m_20077_()) {
            return false;
        }
        if (this.amphithere.isDying() || this.amphithere.m_20160_()) {
            return false;
        }
        if (this.amphithere.m_5448_() != null || this.amphithere.m_5912_()) {
            return false;
        }
        if (this.amphithere.m_29443_()) {
            return false;
        }
        long dayTime = this.amphithere.m_9236_().m_46468_() % 24000L;
        boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
        if (!isNight) {
            return false;
        }
        return this.amphithere.m_217043_().m_188501_() < 5.0E-4f;
    }

    public boolean m_8045_() {
        boolean safeToRest = !this.amphithere.m_20072_() && this.amphithere.m_5448_() == null && !this.amphithere.m_5912_();
        long dayTime = this.amphithere.m_9236_().m_46468_() % 24000L;
        boolean isNight = dayTime >= 13000L && dayTime < 23000L;
        return this.amphithere.getRestManager().isResting() && safeToRest && isNight;
    }

    public void m_8056_() {
        DragonRestManager restManager = this.amphithere.getRestManager();
        if (restManager.isResting()) {
            return;
        }
        restManager.startRest(Integer.MAX_VALUE);
        this.amphithere.m_21839_(true);
        this.amphithere.m_21573_().m_26573_();
    }

    public void m_8037_() {
        long dayTime;
        if (this.amphithere.m_9236_().f_46443_) {
            return;
        }
        DragonRestManager restManager = this.amphithere.getRestManager();
        DragonRestState state = restManager.getCurrentState();
        this.amphithere.m_21573_().m_26573_();
        this.amphithere.m_20334_(0.0, this.amphithere.m_20184_().f_82480_, 0.0);
        if (!(state != DragonRestState.SITTING_DOWN && state != DragonRestState.SITTING || this.amphithere.m_21827_())) {
            this.amphithere.m_21839_(true);
        }
        boolean isNight = (dayTime = this.amphithere.m_9236_().m_46468_() % 24000L) >= 13000L && dayTime < 23000L;
        switch (state) {
            case SITTING_DOWN: {
                if (restManager.getStateTimer() <= 50 || this.amphithere.isInSitTransition()) break;
                restManager.advanceState();
                break;
            }
            case SITTING: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.amphithere.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.amphithere.m_5803_() || this.amphithere.isSleepTransitioning()) && restManager.getStateTimer() <= 65) break;
                restManager.advanceState();
                break;
            }
            case SLEEPING: {
                if (isNight) break;
                restManager.advanceState();
                this.amphithere.startSleepExit();
                this.amphithere.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (restManager.getStateTimer() <= 47) break;
                restManager.advanceState();
                this.amphithere.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.amphithere.m_21839_(false);
                break;
            }
            case STANDING_UP: {
                if (restManager.getStateTimer() <= 46) break;
                restManager.advanceState();
                break;
            }
        }
        restManager.tick();
    }

    public void m_8041_() {
        DragonRestManager restManager = this.amphithere.getRestManager();
        if (restManager.isResting() && restManager.getCurrentState() != DragonRestState.STANDING_UP) {
            if (this.amphithere.m_5803_() || this.amphithere.isSleepTransitioning()) {
                this.amphithere.startSleepExit();
            }
            this.amphithere.m_21839_(false);
            restManager.stopRest();
        }
        this.retryCooldown = 400 + this.amphithere.m_217043_().m_188503_(401);
    }

    public boolean m_6767_() {
        return true;
    }
}

