/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class NulljawRestGoal
extends Goal {
    private final Nulljaw drake;
    private int retryCooldown;
    private static final int SIT_PAUSE = 20;
    private static final int SLEEP_MIN = 80;
    private static final int SLEEP_MAX = 160;
    private static final int WAKE_PAUSE = 20;
    private static final int RETRY_COOLDOWN_MIN = 200;
    private static final int RETRY_COOLDOWN_MAX = 400;

    public NulljawRestGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.drake.getRestManager().isResting()) {
            return true;
        }
        if (this.drake.m_21824_()) {
            return false;
        }
        if (this.drake.isSleepLocked()) {
            return false;
        }
        if (this.drake.m_20072_() || this.drake.m_20077_()) {
            return false;
        }
        if (this.drake.isDying() || this.drake.m_20160_()) {
            return false;
        }
        if (this.drake.m_5448_() != null || this.drake.m_5912_()) {
            return false;
        }
        if (this.drake.m_6069_()) {
            return false;
        }
        if (this.drake.getActiveAbility() != null) {
            return false;
        }
        return this.drake.m_217043_().m_188501_() < 5.0E-4f;
    }

    public boolean m_8045_() {
        boolean safeToRest = !this.drake.m_20072_() && this.drake.m_5448_() == null && !this.drake.m_5912_();
        return this.drake.getRestManager().isResting() && safeToRest;
    }

    public void m_8056_() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting()) {
            return;
        }
        int sleepDuration = 80 + this.drake.m_217043_().m_188503_(80);
        restManager.startRest(sleepDuration);
        this.drake.m_21839_(true);
        this.drake.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.drake.m_9236_().f_46443_) {
            return;
        }
        DragonRestManager restManager = this.drake.getRestManager();
        DragonRestState state = restManager.getCurrentState();
        this.drake.m_21573_().m_26573_();
        this.drake.m_20334_(0.0, this.drake.m_20184_().f_82480_, 0.0);
        if (!(state != DragonRestState.SITTING_DOWN && state != DragonRestState.SITTING || this.drake.m_21827_())) {
            this.drake.m_21839_(true);
        }
        switch (state) {
            case SITTING_DOWN: {
                if (restManager.getStateTimer() <= 38 || this.drake.isInSitTransition()) break;
                restManager.advanceState();
                break;
            }
            case SITTING: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.drake.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.drake.m_5803_() || this.drake.isSleepTransitioning()) && restManager.getStateTimer() <= 55) break;
                restManager.advanceState();
                break;
            }
            case SLEEPING: {
                restManager.incrementRestingTicks();
                if (restManager.getRestingTicks() < restManager.getRestDuration()) break;
                restManager.advanceState();
                this.drake.startSleepExit();
                this.drake.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (restManager.getStateTimer() <= 45) break;
                restManager.advanceState();
                this.drake.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.drake.m_21839_(false);
                break;
            }
            case STANDING_UP: {
                if (restManager.getStateTimer() <= 45) break;
                restManager.advanceState();
                break;
            }
        }
        restManager.tick();
    }

    public void m_8041_() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting() && restManager.getCurrentState() != DragonRestState.STANDING_UP) {
            if (this.drake.m_5803_() || this.drake.isSleepTransitioning()) {
                this.drake.startSleepExit();
            }
            this.drake.m_21839_(false);
            restManager.stopRest();
        }
        this.retryCooldown = 200 + this.drake.m_217043_().m_188503_(200);
    }

    public boolean m_6767_() {
        return true;
    }
}

