/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.util.DragonMathUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RaevyxDodgeGoal
extends Goal {
    private final Raevyx wyvern;
    private static final double SCAN_RADIUS_H = 32.0;
    private static final double SCAN_RADIUS_V = 22.0;
    private static final int SCAN_INTERVAL = 2;
    private static final int DODGE_TICKS = 9;
    private static final int COOLDOWN = 8;
    private static final double DOT_THREAT = 0.65;
    private static final double MIN_SPEED2 = 0.0015;
    private static final double DODGE_LAT_IMPULSE = 0.8;
    private static final double DODGE_UP_IMPULSE = 0.4;
    private long nextScanTime = 0L;
    private long nextAllowedDodgeTime = 0L;

    private List<Projectile> getCachedThreats() {
        return this.wyvern.getCachedNearbyProjectiles().stream().filter(p -> p.m_6084_() && p.m_19749_() != this.wyvern && p.m_19749_() != this.wyvern.m_269323_() && p.m_20184_().m_82556_() > 0.0015).collect(Collectors.toList());
    }

    public RaevyxDodgeGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        Object mostThreatening;
        if (!this.wyvern.m_6084_()) {
            return false;
        }
        if (this.wyvern.m_21824_() && this.wyvern.m_20160_()) {
            return false;
        }
        if (this.wyvern.isDodging()) {
            return false;
        }
        if (!this.wyvern.m_29443_()) {
            return false;
        }
        long now = this.wyvern.m_9236_().m_46467_();
        if (now < this.nextScanTime) {
            return false;
        }
        this.nextScanTime = now + 2L;
        if (now < this.nextAllowedDodgeTime) {
            return false;
        }
        List<Object> threats = this.getCachedThreats().stream().filter(p -> DragonMathUtil.hasLineOfSight((LivingEntity)this.wyvern, (Entity)p)).collect(Collectors.toList());
        if (threats.isEmpty()) {
            threats = this.getCachedThreats();
        }
        if ((mostThreatening = this.mostMovingTowardMeFromList(threats, (LivingEntity)this.wyvern)) == null) {
            return false;
        }
        Vec3 dv = new Vec3(mostThreatening.m_20185_() - ((Projectile)mostThreatening).f_19854_, mostThreatening.m_20186_() - ((Projectile)mostThreatening).f_19855_, mostThreatening.m_20189_() - ((Projectile)mostThreatening).f_19856_);
        if (dv.m_82556_() < 0.0015) {
            return false;
        }
        Vec3 dodgeDirection = DragonMathUtil.calculateDodgeDirection((Entity)this.wyvern, mostThreatening);
        if (dodgeDirection.equals((Object)Vec3.f_82478_)) {
            return false;
        }
        Vec3 dodgeVec = new Vec3(dodgeDirection.f_82479_ * 0.8, 0.4, dodgeDirection.f_82481_ * 0.8);
        dodgeVec = DragonMathUtil.clampVectorLength(dodgeVec, 1.5);
        this.wyvern.beginDodge(dodgeVec, 9);
        this.nextAllowedDodgeTime = now + 8L;
        return true;
    }

    public void m_8056_() {
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.triggerDodgeAnimation();
        this.wyvern.playAnnoyedSound();
    }

    public boolean m_8045_() {
        return false;
    }

    public void m_8041_() {
    }

    private Vec3 guessProjectileDestination(Projectile projectile) {
        Vec3 from = projectile.m_20182_();
        Vec3 vel = projectile.m_20184_();
        if (vel.m_82556_() < 1.0E-6) {
            return from;
        }
        Vec3 to = from.m_82549_(vel.m_82490_(50.0));
        return projectile.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)projectile)).m_82450_();
    }

    @Nullable
    private <T extends Projectile> T mostMovingTowardMe(Class<? extends T> cls, Predicate<? super T> pred, LivingEntity me, AABB box) {
        return this.mostMovingTowardMeFromList(me.m_9236_().m_6443_(cls, box, pred), me);
    }

    private <T extends Projectile> T mostMovingTowardMeFromList(List<? extends T> entities, LivingEntity me) {
        double best = 0.65;
        Projectile bestEnt = null;
        for (Projectile p : entities) {
            double dot;
            Vec3 dv = new Vec3(p.m_20185_() - p.f_19854_, p.m_20186_() - p.f_19855_, p.m_20189_() - p.f_19856_);
            double ls = dv.m_82556_();
            if (ls < 0.0015 || !((dot = dv.m_82541_().m_82526_(me.m_20182_().m_82546_(p.m_20182_()).m_82541_())) > best)) continue;
            best = dot;
            bestEnt = p;
        }
        return (T)bestEnt;
    }
}

