/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class RaevyxRestGoal
extends Goal {
    private final Raevyx wyvern;
    private int retryCooldown;

    public RaevyxRestGoal(Raevyx wyvern) {
        this.wyvern = wyvern;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.wyvern.getRestManager().isResting()) {
            return true;
        }
        if (this.wyvern.m_21824_()) {
            return false;
        }
        if (this.wyvern.m_21827_()) {
            return false;
        }
        if (this.wyvern.isSleepLocked()) {
            return false;
        }
        if (this.wyvern.m_20072_() || this.wyvern.m_20077_()) {
            return false;
        }
        if (this.wyvern.isDying() || this.wyvern.m_20160_()) {
            return false;
        }
        if (this.wyvern.m_5448_() != null || this.wyvern.m_5912_()) {
            return false;
        }
        if (this.wyvern.m_29443_()) {
            return false;
        }
        return this.wyvern.m_217043_().m_188501_() < 5.0E-4f;
    }

    public boolean m_8045_() {
        boolean safeToRest = !this.wyvern.m_20072_() && this.wyvern.m_5448_() == null && !this.wyvern.m_5912_();
        return this.wyvern.getRestManager().isResting() && safeToRest;
    }

    public void m_8056_() {
        DragonRestManager restManager = this.wyvern.getRestManager();
        if (restManager.isResting()) {
            return;
        }
        int sleepDuration = 100 + this.wyvern.m_217043_().m_188503_(101);
        restManager.startRest(sleepDuration);
        this.wyvern.m_21839_(true);
        this.wyvern.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.wyvern.m_9236_().f_46443_) {
            return;
        }
        DragonRestManager restManager = this.wyvern.getRestManager();
        DragonRestState state = restManager.getCurrentState();
        this.wyvern.m_21573_().m_26573_();
        this.wyvern.m_20334_(0.0, this.wyvern.m_20184_().f_82480_, 0.0);
        if (!(state != DragonRestState.SITTING_DOWN && state != DragonRestState.SITTING || this.wyvern.m_21827_())) {
            this.wyvern.m_21839_(true);
        }
        switch (state) {
            case SITTING_DOWN: {
                if (restManager.getStateTimer() <= 35 || this.wyvern.isInSitTransition()) break;
                restManager.advanceState();
                break;
            }
            case SITTING: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.wyvern.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.wyvern.m_5803_() || this.wyvern.isSleepTransitioning()) && restManager.getStateTimer() <= 55) break;
                restManager.advanceState();
                break;
            }
            case SLEEPING: {
                restManager.incrementRestingTicks();
                if (restManager.getRestingTicks() < restManager.getRestDuration()) break;
                restManager.advanceState();
                this.wyvern.startSleepExit();
                this.wyvern.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (restManager.getStateTimer() <= 58) break;
                restManager.advanceState();
                this.wyvern.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                this.wyvern.m_21839_(false);
                break;
            }
            case STANDING_UP: {
                if (restManager.getStateTimer() <= 20) break;
                restManager.advanceState();
                break;
            }
        }
        restManager.tick();
    }

    public void m_8041_() {
        DragonRestManager restManager = this.wyvern.getRestManager();
        if (restManager.isResting() && restManager.getCurrentState() != DragonRestState.STANDING_UP) {
            if (this.wyvern.m_5803_() || this.wyvern.isSleepTransitioning()) {
                this.wyvern.startSleepExit();
            }
            this.wyvern.m_21839_(false);
            restManager.stopRest();
        }
        this.retryCooldown = 200 + this.wyvern.m_217043_().m_188503_(201);
    }

    public boolean m_6767_() {
        return true;
    }
}

