/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.stegonaut;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import com.leon.saintsdragons.server.entity.sleep.DragonRestManager;
import com.leon.saintsdragons.server.entity.sleep.DragonRestState;
import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;

public class StegonautSleepGoal
extends Goal {
    private final Stegonaut drake;
    private int retryCooldown;

    public StegonautSleepGoal(Stegonaut drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        boolean isNight;
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
            return false;
        }
        if (this.drake.getRestManager().isResting()) {
            return true;
        }
        if (this.drake.m_21827_()) {
            return false;
        }
        if (this.drake.isDying() || this.drake.m_20160_()) {
            return false;
        }
        if (this.drake.m_5448_() != null || this.drake.m_5912_()) {
            return false;
        }
        long dayTime = this.drake.m_9236_().m_46468_() % 24000L;
        boolean bl = isNight = dayTime >= 13000L && dayTime < 23000L;
        if (!isNight) {
            return false;
        }
        if (this.drake.consumeDayNapQueued()) {
            return true;
        }
        return this.drake.m_217043_().m_188501_() < 0.001f;
    }

    public boolean m_8045_() {
        boolean safeToRest = this.drake.m_5448_() == null && !this.drake.m_5912_();
        long dayTime = this.drake.m_9236_().m_46468_() % 24000L;
        boolean isNight = dayTime >= 13000L && dayTime < 23000L;
        return this.drake.getRestManager().isResting() && safeToRest && isNight;
    }

    public void m_8056_() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting()) {
            return;
        }
        if (this.drake.consumeDayNapQueued()) {
            int napDuration = 1200 + this.drake.m_217043_().m_188503_(1200);
            this.drake.startNap();
            restManager.startRest(napDuration);
        } else {
            restManager.startRest(Integer.MAX_VALUE);
        }
        this.drake.m_21839_(true);
        this.drake.m_21573_().m_26573_();
    }

    public void m_8037_() {
        long dayTime;
        if (this.drake.m_9236_().f_46443_) {
            return;
        }
        DragonRestManager restManager = this.drake.getRestManager();
        DragonRestState state = restManager.getCurrentState();
        this.drake.m_21573_().m_26573_();
        this.drake.m_20334_(0.0, this.drake.m_20184_().f_82480_, 0.0);
        if (!(state != DragonRestState.SITTING_DOWN && state != DragonRestState.SITTING || this.drake.m_21827_())) {
            this.drake.m_21839_(true);
        }
        boolean isNight = (dayTime = this.drake.m_9236_().m_46468_() % 24000L) >= 13000L && dayTime < 23000L;
        switch (state) {
            case SITTING_DOWN: {
                if (restManager.getStateTimer() <= 35) break;
                restManager.advanceState();
                break;
            }
            case SITTING: {
                if (restManager.getStateTimer() <= 10) break;
                restManager.advanceState();
                this.drake.startSleepEnter();
                break;
            }
            case FALLING_ASLEEP: {
                if ((!this.drake.m_5803_() || this.drake.isSleepTransitioning()) && restManager.getStateTimer() <= 50) break;
                restManager.advanceState();
                break;
            }
            case SLEEPING: {
                boolean shouldWake;
                restManager.incrementRestingTicks();
                boolean bl = shouldWake = !isNight || restManager.getRestingTicks() >= restManager.getRestDuration();
                if (!shouldWake) break;
                restManager.advanceState();
                this.drake.startSleepExit();
                this.drake.m_21839_(true);
                break;
            }
            case WAKING_UP: {
                if (restManager.getStateTimer() <= 45) break;
                restManager.advanceState();
                this.drake.m_21839_(true);
                break;
            }
            case SITTING_AFTER: {
                if (restManager.getStateTimer() <= 10) break;
                restManager.advanceState();
                this.drake.m_21839_(false);
                break;
            }
            case STANDING_UP: {
                if (restManager.getStateTimer() <= 30) break;
                restManager.advanceState();
                break;
            }
        }
        restManager.tick();
    }

    public void m_8041_() {
        DragonRestManager restManager = this.drake.getRestManager();
        if (restManager.isResting() && restManager.getCurrentState() != DragonRestState.STANDING_UP) {
            if (this.drake.m_5803_() || this.drake.isSleepTransitioning()) {
                this.drake.startSleepExit();
            }
            this.drake.m_21839_(false);
            restManager.stopRest();
        }
        this.retryCooldown = 200 + this.drake.m_217043_().m_188503_(201);
    }

    public boolean m_6767_() {
        return true;
    }
}

