/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.navigation;

import com.leon.saintsdragons.server.entity.interfaces.DragonFlightCapable;
import com.leon.saintsdragons.util.DragonMathUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DragonFlightMoveHelper
extends MoveControl {
    private final DragonFlightCapable dragon;
    private final Mob mob;
    private float speedFactor = 1.0f;
    private final float maxYawChange;
    private final float maxPitchChange;
    private final float speedFactorMin;
    private final float speedFactorMax;
    private final float speedTransitionRate;
    private final double accelerationCap;
    private final double velocityBlendRate;

    public DragonFlightMoveHelper(DragonFlightCapable dragon) {
        this(dragon, DragonFlightMoveHelper.getDefaultParameters());
    }

    public DragonFlightMoveHelper(DragonFlightCapable dragon, FlightParameters params) {
        super((Mob)dragon);
        this.dragon = dragon;
        this.mob = (Mob)dragon;
        this.maxYawChange = params.maxYawChange;
        this.maxPitchChange = params.maxPitchChange;
        this.speedFactorMin = params.speedFactorMin;
        this.speedFactorMax = params.speedFactorMax;
        this.speedTransitionRate = params.speedTransitionRate;
        this.accelerationCap = params.accelerationCap;
        this.velocityBlendRate = params.velocityBlendRate;
    }

    private static FlightParameters getDefaultParameters() {
        return new FlightParameters(4.0f, 8.0f, 0.5f, 3.2f, 0.15f, 0.22, 0.16);
    }

    public void m_8126_() {
        if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
            return;
        }
        if (this.dragon.isHovering() || this.dragon.isLanding()) {
            this.handleHoveringMovement();
        } else {
            this.handleGlidingMovement();
        }
    }

    private void handleGlidingMovement() {
        float targetSpeedFactor;
        double totalDist;
        if (this.mob.f_19862_) {
            this.mob.m_146922_(this.mob.m_146908_() + 180.0f);
            this.speedFactor = this.speedFactorMin;
            this.mob.m_21573_().m_26573_();
            return;
        }
        float distX = (float)(this.f_24975_ - this.mob.m_20185_());
        float distY = (float)(this.f_24976_ - this.mob.m_20186_());
        float distZ = (float)(this.f_24977_ - this.mob.m_20189_());
        double horizontalDist = Math.sqrt(distX * distX + distZ * distZ);
        if (horizontalDist > 1.0E-6) {
            double yFractionReduction = 1.0 - (double)Mth.m_14154_((float)(distY * 0.7f)) / horizontalDist;
            distX = (float)((double)distX * yFractionReduction);
            distZ = (float)((double)distZ * yFractionReduction);
            horizontalDist = Math.sqrt(distX * distX + distZ * distZ);
        }
        if ((totalDist = Math.sqrt(distX * distX + distZ * distZ + distY * distY)) < 1.0E-6) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            return;
        }
        float currentYaw = this.mob.m_146908_();
        float desiredYaw = (float)Mth.m_14136_((double)distZ, (double)distX) * 57.295776f;
        float wrappedCurrentYaw = Mth.m_14177_((float)(currentYaw + 90.0f));
        float wrappedDesiredYaw = Mth.m_14177_((float)desiredYaw);
        this.mob.m_146922_(Mth.m_14148_((float)wrappedCurrentYaw, (float)wrappedDesiredYaw, (float)this.maxYawChange) - 90.0f);
        this.mob.f_20883_ = this.mob.m_146908_();
        float desiredPitch = (float)(-(Mth.m_14136_((double)(-distY), (double)horizontalDist) * 57.2957763671875));
        this.mob.m_146926_(Mth.m_14148_((float)this.mob.m_146909_(), (float)desiredPitch, (float)this.maxPitchChange));
        float yawDifference = Math.abs(Mth.m_14177_((float)(this.mob.m_146908_() - currentYaw)));
        if (yawDifference < 3.0f) {
            targetSpeedFactor = this.speedFactorMax;
        } else {
            float turnSeverity = Mth.m_14036_((float)(yawDifference / 15.0f), (float)0.0f, (float)1.0f);
            targetSpeedFactor = DragonMathUtil.lerpSmooth(0.6f, this.speedFactorMax, 1.0f - turnSeverity, DragonMathUtil.EasingFunction.EASE_OUT_SINE);
        }
        float distScale = Mth.m_14036_((float)((float)(totalDist / 45.0) + 0.35f), (float)0.35f, (float)1.0f);
        targetSpeedFactor *= distScale;
        LivingEntity target = this.mob.m_5448_();
        if (this.dragon.m_29443_() && target != null && target.m_6084_()) {
            targetSpeedFactor *= 1.12f;
        }
        if (this.isLineObstructed(this.mob.m_20182_(), new Vec3(this.f_24975_, this.f_24976_, this.f_24977_))) {
            targetSpeedFactor *= 0.5f;
        }
        this.speedFactor = Mth.m_14036_((float)Mth.m_14121_((float)this.speedFactor, (float)targetSpeedFactor, (float)this.speedTransitionRate), (float)this.speedFactorMin, (float)this.speedFactorMax);
        Vec3 dir = new Vec3((double)distX, (double)distY, (double)distZ).m_82490_(1.0 / totalDist);
        Vec3 motion = this.mob.m_20184_();
        Vec3 targetVel = dir.m_82490_((double)this.speedFactor);
        Vec3 delta = targetVel.m_82546_(motion).m_82490_(this.velocityBlendRate);
        double accelCap = this.accelerationCap;
        if (this.isLineObstructed(this.mob.m_20182_(), new Vec3(this.f_24975_, this.f_24976_, this.f_24977_))) {
            accelCap *= 0.6;
            delta = delta.m_82490_(0.6);
        }
        delta = DragonFlightMoveHelper.clampPerAxis(delta, accelCap);
        Vec3 blended = motion.m_82549_(delta);
        this.mob.m_20256_(blended);
    }

    private void handleHoveringMovement() {
        float yawErr;
        LivingEntity target = this.mob.m_5448_();
        if (target != null && this.mob.m_20280_((Entity)target) < 1600.0 && (yawErr = DragonMathUtil.yawErrorToTarget((Entity)this.mob, (Entity)target)) > 4.0f) {
            DragonMathUtil.smoothLookAt((LivingEntity)this.mob, (Entity)target, 10.0f, 10.0f);
        }
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            Vec3 targetVec = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
            double distance = targetVec.m_82553_();
            if (this.checkCollisions(targetVec = targetVec.m_82541_(), Mth.m_14165_((double)distance))) {
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(targetVec.m_82490_(0.1)));
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        }
    }

    private boolean checkCollisions(Vec3 direction, int steps) {
        AABB boundingBox = this.mob.m_20191_();
        for (int i = 1; i < steps; ++i) {
            boundingBox = boundingBox.m_82383_(direction);
            if (this.mob.m_9236_().m_45756_((Entity)this.mob, boundingBox)) continue;
            return false;
        }
        return true;
    }

    private static Vec3 clampPerAxis(Vec3 v, double cap) {
        double cx = Mth.m_14008_((double)v.f_82479_, (double)(-cap), (double)cap);
        double cy = Mth.m_14008_((double)v.f_82480_, (double)(-cap), (double)cap);
        double cz = Mth.m_14008_((double)v.f_82481_, (double)(-cap), (double)cap);
        return new Vec3(cx, cy, cz);
    }

    private boolean isLineObstructed(Vec3 from, Vec3 to) {
        BlockHitResult hit = this.mob.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
        return hit.m_6662_() != HitResult.Type.MISS;
    }

    public boolean hasGivenUp() {
        return this.f_24981_ == MoveControl.Operation.WAIT;
    }

    public static class FlightParameters {
        public final float maxYawChange;
        public final float maxPitchChange;
        public final float speedFactorMin;
        public final float speedFactorMax;
        public final float speedTransitionRate;
        public final double accelerationCap;
        public final double velocityBlendRate;

        public FlightParameters(float maxYawChange, float maxPitchChange, float speedFactorMin, float speedFactorMax, float speedTransitionRate, double accelerationCap, double velocityBlendRate) {
            this.maxYawChange = maxYawChange;
            this.maxPitchChange = maxPitchChange;
            this.speedFactorMin = speedFactorMin;
            this.speedFactorMax = speedFactorMax;
            this.speedTransitionRate = speedTransitionRate;
            this.accelerationCap = accelerationCap;
            this.velocityBlendRate = velocityBlendRate;
        }
    }
}

