/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;

public class DieAbility<T extends DragonEntity>
extends DragonAbility<T> {
    public DieAbility(DragonAbilityType<T, ? extends DragonAbility<T>> type, T user) {
        super(type, user, DieAbility.buildTrack(user), 0);
    }

    private static <E extends DragonEntity> DragonAbilitySection[] buildTrack(E dragon) {
        int duration = Math.max(1, dragon.getDeathAnimationDurationTicks());
        return new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, duration)};
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        DragonEntity dragon = (DragonEntity)((Object)this.getUser());
        dragon.onDeathAbilityStarted();
        String abilityId = this.getAbilityType().getName();
        String controllerId = "action";
        DragonEntity.VocalEntry deathEntry = dragon.getVocalEntries().get(abilityId);
        if (deathEntry != null && deathEntry.controllerId() != null) {
            controllerId = deathEntry.controllerId();
        }
        String animationTrigger = "die";
        if (abilityId.startsWith("baby_")) {
            animationTrigger = "baby_die";
        }
        dragon.triggerAnim(controllerId, animationTrigger);
        if (!this.getLevel().f_46443_ && dragon instanceof SoundHandledDragon) {
            SoundHandledDragon soundDragon = (SoundHandledDragon)((Object)dragon);
            soundDragon.getSoundHandler().playVocal(abilityId);
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (!this.getLevel().f_46443_) {
            ((DragonEntity)((Object)this.getUser())).m_20331_(false);
            ((DragonEntity)((Object)this.getUser())).m_6469_(this.getLevel().m_269111_().m_287172_(), Float.MAX_VALUE);
        }
        this.complete();
    }

    @Override
    public boolean damageInterrupts() {
        return false;
    }
}

