/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.SoundHandledDragon;

public class HurtAbility<T extends DragonEntity>
extends DragonAbility<T> {
    private static final int DURATION_TICKS = 11;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 11)};
    private static final String DEFAULT_CONTROLLER = "action";
    private final String controllerId;
    private final String animationTrigger;
    private final String manualVocalKey;

    public HurtAbility(DragonAbilityType<T, ? extends DragonAbility<T>> type, T user) {
        super(type, user, TRACK, 10);
        String abilityId = type.getName();
        this.controllerId = HurtAbility.resolveControllerId(abilityId);
        this.animationTrigger = HurtAbility.resolveAnimationTrigger(abilityId);
        this.manualVocalKey = HurtAbility.resolveManualVocalKey(abilityId);
    }

    private static String resolveAnimationTrigger(String abilityId) {
        return switch (abilityId) {
            case "cindervane_hurt" -> "cindervane_hurt";
            case "raevyx_hurt" -> "raevyx_hurt";
            case "baby_raevyx_hurt" -> "baby_raevyx_hurt";
            default -> "hurt";
        };
    }

    private static String resolveManualVocalKey(String abilityId) {
        return switch (abilityId) {
            case "stegonaut_hurt" -> "hurt";
            case "hurt", "cindervane_hurt", "raevyx_hurt", "baby_raevyx_hurt" -> abilityId;
            default -> null;
        };
    }

    private static String resolveControllerId(String abilityId) {
        return switch (abilityId) {
            case "cindervane_hurt", "raevyx_hurt", "baby_raevyx_hurt" -> "hurt";
            default -> DEFAULT_CONTROLLER;
        };
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        Object t;
        if (section == null) {
            return;
        }
        if (this.animationTrigger != null) {
            ((DragonEntity)((Object)this.getUser())).triggerAnim(this.controllerId, this.animationTrigger);
        }
        if (!this.getLevel().f_46443_ && this.manualVocalKey != null && (t = this.getUser()) instanceof SoundHandledDragon) {
            SoundHandledDragon soundHandled = (SoundHandledDragon)t;
            soundHandled.getSoundHandler().playVocal(this.manualVocalKey);
        }
    }

    @Override
    public boolean tryAbility() {
        return this.canUse();
    }

    @Override
    public boolean damageInterrupts() {
        return false;
    }

    @Override
    public boolean isOverlayAbility() {
        return true;
    }
}

