/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.cindervane;

import com.leon.saintsdragons.common.registry.ModSounds;
import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class CindervaneRoarAbility
extends DragonAbility<Cindervane> {
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 6), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.ACTIVE, 30), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 10)};
    private static final int SOUND_DELAY_TICKS = 3;
    private boolean soundQueued = false;

    public CindervaneRoarAbility(DragonAbilityType<Cindervane, CindervaneRoarAbility> type, Cindervane user) {
        super(type, user, TRACK, 20);
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            Cindervane dragon = (Cindervane)this.getUser();
            String trigger = dragon.m_29443_() ? "roar_air" : "roar_ground";
            dragon.triggerAnim("actions", trigger);
            this.soundQueued = true;
        }
    }

    @Override
    protected void endSection(DragonAbilitySection section) {
        if (section != null && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.soundQueued = false;
        }
    }

    @Override
    public void tickUsing() {
        DragonAbilitySection section = this.getCurrentSection();
        if (section == null) {
            return;
        }
        Cindervane dragon = (Cindervane)this.getUser();
        if (!dragon.m_9236_().f_46443_) {
            dragon.triggerScreenShake(0.6f);
        }
        if (this.soundQueued && section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP && this.getTicksInSection() >= 3) {
            if (!dragon.m_9236_().f_46443_) {
                Vec3 mouth = dragon.getMouthPosition();
                boolean flying = dragon.m_29443_();
                float basePitch = flying ? 1.05f : 0.9f;
                float pitch = basePitch + dragon.m_217043_().m_188501_() * 0.05f;
                dragon.m_9236_().m_6263_(null, mouth.f_82479_, mouth.f_82480_, mouth.f_82481_, (SoundEvent)ModSounds.CINDERVANE_ROAR.get(), SoundSource.NEUTRAL, 1.5f, pitch);
            }
            this.soundQueued = false;
        }
    }
}

