/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.ability.abilities.raevyx;

import com.leon.saintsdragons.server.entity.ability.DragonAbility;
import com.leon.saintsdragons.server.entity.ability.DragonAbilitySection;
import com.leon.saintsdragons.server.entity.ability.DragonAbilityType;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class RaevyxSummonStormAbility
extends DragonAbility<Raevyx> {
    private static final int SUPERCHARGE_TICKS = 2400;
    private static final int COOLDOWN_TICKS = 4800;
    private static final int ANIMATION_LENGTH_TICKS = 145;
    private static final int SCREEN_SHAKE_TRIGGER_TICK = 35;
    private static final DragonAbilitySection[] TRACK = new DragonAbilitySection[]{new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.STARTUP, 145), new DragonAbilitySection.AbilitySectionInstant(DragonAbilitySection.AbilitySectionType.ACTIVE), new DragonAbilitySection.AbilitySectionDuration(DragonAbilitySection.AbilitySectionType.RECOVERY, 20)};
    private boolean isGroundCast;

    public RaevyxSummonStormAbility(DragonAbilityType<Raevyx, RaevyxSummonStormAbility> type, Raevyx user) {
        super(type, user, TRACK, 4800);
    }

    @Override
    public void tickUsing() {
        if (this.getTicksInUse() >= 35 && !((Raevyx)this.getUser()).m_9236_().f_46443_) {
            ((Raevyx)this.getUser()).triggerScreenShake(1.5f);
        }
    }

    @Override
    protected void beginSection(DragonAbilitySection section) {
        if (section == null) {
            return;
        }
        if (section.sectionType == DragonAbilitySection.AbilitySectionType.STARTUP) {
            this.isGroundCast = !((Raevyx)this.getUser()).m_29443_();
            ((Raevyx)this.getUser()).startTemporaryInvuln(145);
            if (this.isGroundCast) {
                ((Raevyx)this.getUser()).lockRiderControls(145);
                ((Raevyx)this.getUser()).lockTakeoff(145);
            } else {
                ((Raevyx)this.getUser()).lockTakeoff(145);
            }
            String trigger = this.isGroundCast ? "summon_storm_ground" : "summon_storm_air";
            ((Raevyx)this.getUser()).triggerAnim("action", trigger);
        } else if (section.sectionType == DragonAbilitySection.AbilitySectionType.ACTIVE && !this.getLevel().f_46443_) {
            ((Raevyx)this.getUser()).startSupercharge(2400);
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                LevelData ld = server.m_6106_();
                if (ld instanceof ServerLevelData) {
                    ServerLevelData data = (ServerLevelData)ld;
                    data.m_5565_(true);
                    data.m_6399_(2400);
                    data.m_5557_(true);
                    data.m_6398_(2400);
                }
                server.m_5594_(null, ((Raevyx)this.getUser()).m_20183_(), SoundEvents.f_12090_, SoundSource.WEATHER, 6.0f, 0.9f);
            }
        }
    }
}

