/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.controller.cindervane;

import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CindervaneRiderController(Cindervane dragon) {
    private static final double SEAT_BASE_FACTOR = 0.05;
    private static final double SEAT_LIFT = 0.7;
    private static final double SEAT_0_FORWARD = 8.0;
    private static final double SEAT_0_SIDE = 0.0;
    private static final double SEAT_1_FORWARD = 4.0;
    private static final double SEAT_1_SIDE = 0.0;
    private static final double CRUISE_SPEED_MULT = 4.5;
    private static final double SPRINT_SPEED_MULT = 6.5;
    private static final double ACCELERATION = 0.12;
    private static final double DRAG_WITH_INPUT = 0.06;
    private static final double DRAG_NO_INPUT = 0.45;
    private static final double STRAFE_POWER = 0.4;
    private static final double ASCEND_THRUST = 0.06;
    private static final double DESCEND_THRUST = 0.85;
    private static final double TERMINAL_VELOCITY = 1.2;
    private static final double VERTICAL_DRAG = 0.95;

    @Nullable
    public Player getRidingPlayer() {
        LivingEntity livingEntity = this.dragon.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return player;
        }
        return null;
    }

    public Vec3 getRiddenInput(Player player, Vec3 deltaIn) {
        float f;
        float f2 = f = player.f_20902_ < 0.0f ? 0.5f : 1.0f;
        if (this.dragon.m_29443_()) {
            return new Vec3((double)(player.f_20900_ * 0.3f), 0.0, (double)(player.f_20902_ * 0.8f * f));
        }
        return new Vec3((double)(player.f_20900_ * 0.4f), 0.0, (double)(player.f_20902_ * 0.7f * f));
    }

    public void tickRidden(Player player, Vec3 travelVector) {
        player.f_19789_ = 0.0f;
        this.dragon.f_19789_ = 0.0f;
        this.dragon.m_6710_(null);
        boolean flying = this.dragon.m_29443_();
        float yawDiff = Math.abs(player.m_146908_() - this.dragon.m_146908_());
        if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f || yawDiff > 5.0f) {
            float currentYaw = this.dragon.m_146908_();
            float targetYaw = player.m_146908_();
            float rawDiff = Mth.m_14177_((float)(targetYaw - currentYaw));
            float blend = flying ? 0.3f : 0.25f;
            float newYaw = currentYaw + rawDiff * blend;
            this.dragon.m_146922_(newYaw);
            this.dragon.f_20883_ = newYaw;
            this.dragon.f_20885_ = newYaw;
            if (flying) {
                float targetPitch = Mth.m_14036_((float)(player.m_146909_() * 0.4f), (float)-35.0f, (float)30.0f);
                this.dragon.m_146926_(targetPitch);
            } else {
                this.dragon.m_146926_(0.0f);
            }
            this.dragon.m_20256_(this.dragon.m_20184_());
        }
        if (this.dragon.m_20096_()) {
            player.f_19789_ = 0.0f;
            this.dragon.f_19789_ = 0.0f;
        }
    }

    public float getRiddenSpeed(Player rider) {
        if (this.dragon.m_29443_()) {
            return (float)this.dragon.m_21133_(Attributes.f_22280_);
        }
        float baseSpeed = (float)this.dragon.m_21133_(Attributes.f_22279_);
        if (this.dragon.isAccelerating()) {
            return baseSpeed * 0.6f;
        }
        return baseSpeed * 0.5f;
    }

    public void handleRiderMovement(Player player, Vec3 motion) {
        if (this.dragon.m_21573_().m_26570_() != null) {
            this.dragon.m_21573_().m_26573_();
        }
        if (this.dragon.m_29443_()) {
            Vec3 newHorizontalVel;
            boolean hasInput;
            double baseSpeed = this.dragon.m_21133_(Attributes.f_22280_);
            boolean sprinting = this.dragon.isAccelerating();
            double targetSpeed = (sprinting ? 6.5 : 4.5) * baseSpeed;
            double forwardInput = motion.f_82481_;
            double strafeInput = motion.f_82479_;
            Vec3 currentVel = this.dragon.m_20184_();
            Vec3 horizontalVel = new Vec3(currentVel.f_82479_, 0.0, currentVel.f_82481_);
            float yawRad = (float)Math.toRadians(this.dragon.m_146908_());
            double forwardX = -Math.sin(yawRad);
            double forwardZ = Math.cos(yawRad);
            double strafeX = Math.cos(yawRad);
            double strafeZ = Math.sin(yawRad);
            double targetDirX = forwardX * forwardInput + strafeX * strafeInput * 0.4;
            double targetDirZ = forwardZ * forwardInput + strafeZ * strafeInput * 0.4;
            double dirLength = Math.hypot(targetDirX, targetDirZ);
            boolean bl = hasInput = Math.abs(forwardInput) > 0.01 || Math.abs(strafeInput) > 0.01;
            if (hasInput && dirLength > 0.01) {
                Vec3 targetVelocity = new Vec3((targetDirX /= dirLength) * targetSpeed, 0.0, (targetDirZ /= dirLength) * targetSpeed);
                newHorizontalVel = new Vec3(Mth.m_14139_((double)0.12, (double)horizontalVel.f_82479_, (double)targetVelocity.f_82479_), 0.0, Mth.m_14139_((double)0.12, (double)horizontalVel.f_82481_, (double)targetVelocity.f_82481_));
                newHorizontalVel = newHorizontalVel.m_82490_(0.94);
            } else {
                newHorizontalVel = horizontalVel.m_82490_(0.55);
                if (newHorizontalVel.m_82553_() < 0.01) {
                    newHorizontalVel = Vec3.f_82478_;
                }
            }
            double finalSpeed = newHorizontalVel.m_82553_();
            if (finalSpeed > targetSpeed) {
                newHorizontalVel = newHorizontalVel.m_82490_(targetSpeed / finalSpeed);
            }
            double newVerticalVel = currentVel.f_82480_;
            newVerticalVel = this.dragon.isGoingUp() ? (newVerticalVel += 0.06) : (this.dragon.isGoingDown() ? (newVerticalVel -= 0.85) : (newVerticalVel *= 0.95));
            newVerticalVel = Mth.m_14008_((double)newVerticalVel, (double)-1.2, (double)1.2);
            Vec3 finalVelocity = new Vec3(newHorizontalVel.f_82479_, newVerticalVel, newHorizontalVel.f_82481_);
            this.dragon.m_6478_(MoverType.SELF, finalVelocity);
            this.dragon.m_20256_(finalVelocity);
            this.dragon.m_267651_(true);
            player.f_19789_ = 0.0f;
            this.dragon.f_19789_ = 0.0f;
        }
    }

    public double getPassengersRidingOffset() {
        return (double)this.dragon.m_20206_() * 0.05;
    }

    public void positionRider(@NotNull Entity passenger, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MoveFunction moveFunction) {
        if (!this.dragon.m_20363_(passenger)) {
            return;
        }
        List passengers = this.dragon.m_20197_();
        int seatIndex = passengers.indexOf(passenger);
        if (seatIndex == -1) {
            return;
        }
        String locatorName = seatIndex == 0 ? "passengerSeat0" : "passengerSeat1";
        Vec3 passengerLoc = this.dragon.getClientLocatorPosition(locatorName);
        if (passengerLoc != null) {
            Vec3 dragonOldPos = new Vec3(this.dragon.f_19854_, this.dragon.f_19855_, this.dragon.f_19856_);
            float oldYaw = this.dragon.f_19859_;
            Vec3 worldOffset = passengerLoc.m_82546_(dragonOldPos);
            double oldYawRad = Math.toRadians(-oldYaw);
            double cosOld = Math.cos(oldYawRad);
            double sinOld = Math.sin(oldYawRad);
            double localX = worldOffset.f_82479_ * cosOld - worldOffset.f_82481_ * sinOld;
            double localY = worldOffset.f_82480_;
            double localZ = worldOffset.f_82479_ * sinOld + worldOffset.f_82481_ * cosOld;
            float currentYaw = this.dragon.m_146908_();
            double currentYawRad = Math.toRadians(-currentYaw);
            double cosCurrent = Math.cos(currentYawRad);
            double sinCurrent = Math.sin(currentYawRad);
            double currentWorldX = localX * cosCurrent + localZ * sinCurrent;
            double currentWorldZ = -localX * sinCurrent + localZ * cosCurrent;
            Vec3 dragonCurrentPos = this.dragon.m_20182_();
            Vec3 passengerCurrentPos = dragonCurrentPos.m_82520_(currentWorldX, localY, currentWorldZ);
            moveFunction.m_20372_(passenger, passengerCurrentPos.f_82479_, passengerCurrentPos.f_82480_, passengerCurrentPos.f_82481_);
        } else {
            double side;
            double forward;
            double offsetY = this.getPassengersRidingOffset() + 0.7;
            if (seatIndex == 0) {
                forward = 8.0;
                side = 0.0;
            } else {
                forward = 4.0;
                side = 0.0;
            }
            double rad = Math.toRadians(this.dragon.f_20883_);
            double dx = -Math.sin(rad) * forward + Math.cos(rad) * side;
            double dz = Math.cos(rad) * forward + Math.sin(rad) * side;
            moveFunction.m_20372_(passenger, this.dragon.m_20185_() + dx, this.dragon.m_20186_() + offsetY, this.dragon.m_20189_() + dz);
        }
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(@NotNull LivingEntity passenger) {
        passenger.f_19789_ = 0.0f;
        Level level = this.dragon.m_9236_();
        Vec3 base = this.dragon.m_20182_();
        double[] radii = new double[]{2.5, 3.5, 1.8};
        int[] angles = new int[]{0, 30, -30, 60, -60, 90, -90, 150, -150, 180};
        for (double r : radii) {
            for (int a : angles) {
                double rad = Math.toRadians(this.dragon.m_146908_() + (float)a);
                double cx = base.f_82479_ + Math.cos(rad) * r;
                double cz = base.f_82481_ + Math.sin(rad) * r;
                int startY = (int)Math.floor(base.f_82480_ + 1.0);
                for (int dy = 0; dy <= 6; ++dy) {
                    int y = startY - dy;
                    BlockPos pos = new BlockPos((int)Math.floor(cx), y, (int)Math.floor(cz));
                    BlockPos below = pos.m_7495_();
                    BlockState bsBelow = level.m_8055_(below);
                    BlockState bsAt = level.m_8055_(pos);
                    boolean solidBelow = !bsBelow.m_60795_() && !bsBelow.m_60812_((BlockGetter)level, below).m_83281_();
                    boolean spaceFree = bsAt.m_60812_((BlockGetter)level, pos).m_83281_();
                    boolean fluidOk = bsAt.m_60819_().m_76178_();
                    if (!solidBelow || !spaceFree || !fluidOk) continue;
                    return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.05, (double)pos.m_123343_() + 0.5);
                }
            }
        }
        Vec3 direction = this.dragon.m_20252_(1.0f);
        return base.m_82549_(direction.m_82490_(2.0));
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        List passengers = this.dragon.m_20197_();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity firstPassenger = (Entity)passengers.get(0);
        if (firstPassenger instanceof Player) {
            Player player = (Player)firstPassenger;
            if (this.dragon.m_21824_() && this.dragon.m_21830_((LivingEntity)player)) {
                return player;
            }
        }
        return null;
    }

    public void requestRiderTakeoff() {
        if (!this.dragon.m_21824_() || this.getRidingPlayer() == null || this.dragon.m_29443_()) {
            return;
        }
        if (!this.dragon.canTakeoff()) {
            return;
        }
        this.dragon.m_21573_().m_26573_();
        this.dragon.setFlying(true);
        this.dragon.setTakeoff(true);
        this.dragon.setHovering(false);
        this.dragon.setLanding(false);
        this.dragon.setRiderTakeoffTicks(25);
        Vec3 current = this.dragon.m_20184_();
        double upward = Math.max(current.f_82480_, 0.25);
        this.dragon.m_20334_(current.f_82479_, upward, current.f_82481_);
    }
}

