/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.dragons.stegonaut.handlers;

import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class StegonautAnimationHandler {
    private final Stegonaut drake;
    private static final RawAnimation IDLE_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.idle");
    private static final RawAnimation WALK_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.walk");
    private static final RawAnimation SLEEP_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.sleep");
    private static final RawAnimation SIT_ANIM = RawAnimation.begin().thenLoop("animation.stegonaut.sit");

    public StegonautAnimationHandler(Stegonaut drake) {
        this.drake = drake;
    }

    public PlayState handleMovementAnimation(AnimationState<Stegonaut> state) {
        state.getController().transitionLength(8);
        if (this.drake.m_5803_()) {
            return this.handleSleepAnimation(state);
        }
        if (this.drake.m_21827_() || this.drake.getSitProgress() > 0.5f) {
            state.setAndContinue(SIT_ANIM);
            return PlayState.CONTINUE;
        }
        int groundState = this.drake.getEffectiveGroundState();
        if (groundState >= 1 || this.drake.isWalking()) {
            state.setAndContinue(WALK_ANIM);
        } else {
            state.setAndContinue(IDLE_ANIM);
        }
        return PlayState.CONTINUE;
    }

    private PlayState handleSleepAnimation(AnimationState<Stegonaut> state) {
        state.getController().transitionLength(12);
        state.setAndContinue(SLEEP_ANIM);
        return PlayState.CONTINUE;
    }

    public void initializeAnimation() {
    }

    public void resetAnimationState() {
    }

    public void setupActionController(AnimationController<Stegonaut> actionController) {
        actionController.triggerableAnim("grumble1", RawAnimation.begin().thenPlay("animation.stegonaut.grumble1"));
        actionController.triggerableAnim("grumble2", RawAnimation.begin().thenPlay("animation.stegonaut.grumble2"));
        actionController.triggerableAnim("grumble3", RawAnimation.begin().thenPlay("animation.stegonaut.grumble3"));
        actionController.triggerableAnim("eat", RawAnimation.begin().thenPlay("animation.stegonaut.eat"));
        actionController.triggerableAnim("hurt", RawAnimation.begin().thenPlay("animation.stegonaut.hurt"));
        actionController.triggerableAnim("die", RawAnimation.begin().thenPlay("animation.stegonaut.die"));
    }

    public PlayState actionPredicate(AnimationState<Stegonaut> state) {
        state.getController().transitionLength(5);
        return PlayState.STOP;
    }
}

