/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.entity.handler;

import com.leon.saintsdragons.server.entity.base.DragonEntity;
import com.leon.saintsdragons.server.entity.interfaces.DragonSoundProfile;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animation.AnimationController;

public class DragonSoundHandler {
    private final DragonEntity dragon;
    private final DragonSoundProfile profile;
    private static final int MIN_OVERLAP_GUARD_TICKS = 5;
    private static final Set<String> DEFAULT_NON_OVERLAPPING_KEYS = Set.of("hurt", "stegonaut_hurt", "cindervane_hurt", "primitive_drake_hurt", "die", "raevyx_hurt", "raevyx_die", "baby_raevyx_hurt", "baby_raevyx_die");
    private static final Map<String, Integer> GENERIC_VOCAL_WINDOWS = Map.of("hurt", 20, "die", 62);
    private final Map<String, Integer> vocalCooldowns = new HashMap<String, Integer>();

    public DragonSoundHandler(DragonEntity dragon) {
        this.dragon = dragon;
        DragonSoundProfile providedProfile = dragon.getSoundProfile();
        this.profile = providedProfile != null ? providedProfile : DragonSoundProfile.EMPTY;
    }

    public void tick() {
    }

    public void handleAnimationSound(DragonEntity entity, Object keyframeData, AnimationController<?> controller) {
        String raw;
        if (this.dragon.isDying()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (keyframeData == null) {
            return;
        }
        String controllerName = null;
        try {
            if (controller != null && controller.getName() != null) {
                controllerName = controller.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean sittingMuted = this.dragon.isStayOrSitMuted();
        boolean sleeping = this.dragon.m_5803_();
        boolean sleepTransitioning = this.dragon.isSleepTransitioning();
        if (sleeping) {
            return;
        }
        if (sleepTransitioning && !"action".equals(controllerName)) {
            return;
        }
        String locator = null;
        try {
            raw = (String)keyframeData.getClass().getMethod("getSound", new Class[0]).invoke(keyframeData, new Object[0]);
            try {
                locator = (String)keyframeData.getClass().getMethod("getLocator", new Class[0]).invoke(keyframeData, new Object[0]);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            return;
        }
        if (raw == null || raw.isEmpty()) {
            return;
        }
        String sound = raw.toLowerCase(Locale.ROOT);
        if (sound.contains(":")) {
            this.handleAutoSoundSpec(sound);
            return;
        }
        String normalizedForFlap = null;
        if (sound.contains("flap")) {
            normalizedForFlap = sound.substring(sound.indexOf("flap"));
        }
        String normalizedForStep = null;
        if (sound.contains("step")) {
            normalizedForStep = sound.substring(sound.indexOf("step"));
        }
        if (this.profile.handleAnimationSound(this, this.dragon, sound, locator)) {
            return;
        }
        if (sittingMuted) {
            return;
        }
        if (normalizedForFlap != null && normalizedForFlap.startsWith("flap")) {
            this.handleWingFlapSound(normalizedForFlap);
            return;
        }
        if (normalizedForStep != null && (normalizedForStep.startsWith("step") || normalizedForStep.startsWith("run_step"))) {
            try {
                String ctrl;
                if (controller != null && controller.getName() != null && !"movement".equals(ctrl = controller.getName())) {
                    return;
                }
            }
            catch (Throwable ctrl) {
                // empty catch block
            }
            String stepLocator = locator != null && !locator.isEmpty() ? locator : this.mapStepKeyToLocator(normalizedForStep);
            this.handleStepSound(normalizedForStep, stepLocator);
            return;
        }
        switch (sound) {
            case "wing_flap": {
                this.handleWingFlapSound(sound);
                break;
            }
            case "dragon_step": {
                this.handleStepSound(sound, null);
                break;
            }
            case "takeoff_whoosh": {
                this.handleTakeoffSound();
                break;
            }
            case "landing_thud": {
                this.handleLandingSound();
                break;
            }
            default: {
                this.handleSoundByName(sound);
            }
        }
    }

    public void handleSoundByName(String soundName) {
        if (this.dragon.isDying()) {
            return;
        }
        if (this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return;
        }
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        String key = soundName.toLowerCase(Locale.ROOT);
        if (this.profile.handleSoundByName(this, this.dragon, key)) {
            return;
        }
        if (key.startsWith("flap")) {
            this.handleWingFlapSound(key);
            return;
        }
        if (key.startsWith("step") || key.startsWith("run_step")) {
            this.handleStepSound(key, null);
            return;
        }
        switch (key) {
            case "wing_flap": {
                this.handleWingFlapSound(key);
                break;
            }
            case "dragon_step": {
                this.handleStepSound(key, null);
                break;
            }
            case "takeoff_whoosh": {
                this.handleTakeoffSound();
                break;
            }
            case "landing_thud": {
                this.handleLandingSound();
                break;
            }
        }
    }

    public void playVocal(String key) {
        boolean hasAnimation;
        Integer guard;
        boolean suppressOverlap;
        DragonEntity.VocalEntry entry2;
        if (key == null || key.isEmpty() || this.dragon.m_9236_().f_46443_) {
            return;
        }
        int currentTick = this.dragon.f_19797_;
        if (!this.vocalCooldowns.isEmpty()) {
            this.vocalCooldowns.entrySet().removeIf(entry -> (Integer)entry.getValue() <= currentTick);
        }
        if ((entry2 = this.dragon.getVocalEntries().get(key)) == null) {
            entry2 = this.profile.getFallbackVocalEntry(key);
        }
        boolean bl = suppressOverlap = entry2 != null ? entry2.preventOverlap() : DEFAULT_NON_OVERLAPPING_KEYS.contains(key);
        if (suppressOverlap && (guard = this.vocalCooldowns.get(key)) != null && guard > currentTick) {
            return;
        }
        if (entry2 == null) {
            return;
        }
        if (!entry2.allowDuringSleep() && (this.dragon.m_5803_() || this.dragon.isSleepTransitioning())) {
            return;
        }
        if (!entry2.allowWhenSitting() && this.dragon.isStayOrSitMuted()) {
            return;
        }
        int window = this.getVocalAnimationWindowTicks(key);
        if (suppressOverlap) {
            this.vocalCooldowns.put(key, currentTick + Math.max(window, 5));
        }
        boolean bl2 = hasAnimation = entry2.animationId() != null && !entry2.animationId().isEmpty();
        if (hasAnimation) {
            if (!this.dragon.m_9236_().f_46443_) {
                if (this.shouldBroadcastInstantly(key)) {
                    float pitch = entry2.basePitch();
                    float variance = entry2.pitchVariance();
                    if (variance != 0.0f) {
                        pitch += this.dragon.m_217043_().m_188501_() * variance;
                    }
                    this.playServerBroadcast(entry2.soundSupplier().get(), entry2.volume(), pitch, null);
                }
                if (!this.dragon.m_5803_() && !this.dragon.isSleepTransitioning() && window > 0) {
                    this.dragon.triggerAnim(entry2.controllerId(), key);
                }
            }
        } else if (!this.dragon.m_9236_().f_46443_) {
            float volume = entry2.volume();
            float pitch = entry2.basePitch();
            float variance = entry2.pitchVariance();
            if (variance != 0.0f) {
                pitch += this.dragon.m_217043_().m_188501_() * variance;
            }
            this.playServerBroadcast(entry2.soundSupplier().get(), volume, pitch, null);
        }
    }

    private int getVocalAnimationWindowTicks(String key) {
        if (key == null) {
            return 0;
        }
        int custom = this.profile.getVocalAnimationWindowTicks(key);
        if (custom >= 0) {
            return custom;
        }
        Integer generic = GENERIC_VOCAL_WINDOWS.get(key);
        if (generic != null) {
            return generic;
        }
        return 40;
    }

    private boolean shouldBroadcastInstantly(String key) {
        return DEFAULT_NON_OVERLAPPING_KEYS.contains(key);
    }

    private void handleWingFlapSound(String key) {
        if (this.dragon.isStayOrSitMuted()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (this.profile.handleWingFlapSound(this, this.dragon, key)) {
            return;
        }
        double flightSpeed = this.dragon.getCachedHorizontalSpeed();
        float pitch = 1.0f + (float)(flightSpeed * (double)0.3f);
        float volume = Math.max(0.6f, 0.9f + (float)(flightSpeed * (double)0.2f));
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), SoundEvents.f_11893_, SoundSource.NEUTRAL, volume, pitch, false);
    }

    private void handleStepSound(String key, String locator) {
        if (this.dragon.isStayOrSitMuted()) {
            return;
        }
        this.actuallyPlayStep(key, locator);
    }

    private void actuallyPlayStep(String which, String locator) {
        double z;
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        float weight = 1.0f;
        if (this.dragon.isRunning()) {
            weight *= 1.2f;
        }
        if (this.dragon.m_20160_()) {
            weight *= 1.1f;
        }
        if (this.dragon.m_21223_() < this.dragon.m_21233_() * 0.5f) {
            weight *= 0.9f;
        }
        float volume = 0.65f * weight;
        float pitch = (0.9f + this.dragon.m_217043_().m_188501_() * 0.2f) / weight;
        Vec3 at = this.resolveLocatorWorldPos(locator);
        double x = at != null ? at.f_82479_ : this.dragon.m_20185_();
        double y = at != null ? at.f_82480_ : this.dragon.m_20186_();
        double d = z = at != null ? at.f_82481_ : this.dragon.m_20189_();
        if (this.profile.handleStepSound(this, this.dragon, which, locator, x, y, z, volume, pitch)) {
            return;
        }
        this.dragon.m_9236_().m_7785_(x, y, z, SoundEvents.f_11916_, SoundSource.NEUTRAL, volume, pitch, false);
    }

    private void handleAutoSoundSpec(String spec) {
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        if (spec == null) {
            return;
        }
        String[] parts = spec.split("\\|");
        String id = parts[0];
        float vol = 1.0f;
        float pitch = 1.0f;
        try {
            if (parts.length >= 2) {
                vol = Float.parseFloat(parts[1]);
            }
            if (parts.length >= 3) {
                pitch = Float.parseFloat(parts[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        if (rl == null) {
            return;
        }
        SoundEvent evt = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(rl);
        if (evt == null) {
            return;
        }
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), evt, SoundSource.NEUTRAL, vol, pitch, false);
    }

    private void playServerBroadcast(SoundEvent sound, float volume, float pitch, Vec3 position) {
        if (this.dragon.m_9236_().f_46443_) {
            return;
        }
        double x = position != null ? position.f_82479_ : this.dragon.m_20185_();
        double y = position != null ? position.f_82480_ : this.dragon.m_20186_();
        double z = position != null ? position.f_82481_ : this.dragon.m_20189_();
        this.dragon.m_9236_().m_6263_(null, x, y, z, sound, SoundSource.NEUTRAL, volume, pitch);
    }

    private String mapStepKeyToLocator(String key) {
        if (key == null) {
            return null;
        }
        String k = key.toLowerCase(Locale.ROOT).trim();
        if (k.endsWith("1")) {
            return "rightfeetLocator";
        }
        if (k.endsWith("2")) {
            return "leftfeetLocator";
        }
        return null;
    }

    public Vec3 resolveLocatorWorldPos(String locator) {
        Vec3 dynamic;
        if (locator == null || locator.isEmpty()) {
            return null;
        }
        if ("mouth_origin".equals(locator) && (dynamic = this.dragon.getMouthPosition()) != null) {
            return dynamic;
        }
        Vec3 cached = this.dragon.getClientLocatorPosition(locator);
        if (cached != null) {
            return cached;
        }
        return null;
    }

    private void handleTakeoffSound() {
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_() || this.dragon.isSleepTransitioning()) {
            return;
        }
        if (!this.dragon.m_9236_().f_46443_) {
            return;
        }
        float urgency = this.dragon.m_5448_() != null ? 1.3f : 1.0f;
        this.dragon.m_9236_().m_7785_(this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), SoundEvents.f_11893_, SoundSource.NEUTRAL, urgency * 1.2f, 0.85f, false);
    }

    private void handleLandingSound() {
        if (this.dragon.isStayOrSitMuted() || this.dragon.m_5803_()) {
            return;
        }
        double impactSpeed = Math.abs(this.dragon.m_20184_().f_82480_);
        float volume = (float)Math.max((double)0.8f, 1.0 + impactSpeed * 2.0);
        float pitch = (float)Math.max((double)0.7f, 1.0 - impactSpeed * (double)0.3f);
        this.dragon.m_5496_(SoundEvents.f_11913_, volume * 0.6f, pitch);
    }
}

