/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.input;

import com.leon.saintsdragons.client.DragonStatusUIManager;
import com.leon.saintsdragons.common.network.DragonRiderAction;
import com.leon.saintsdragons.common.network.MessageDragonRideInput;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.server.entity.base.RideableDragonBase;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public final class DragonRideInputHandler {
    private static final String KEY_CATEGORY = "key.categories.saintsdragons";
    public static final KeyMapping DRAGON_ASCEND = new KeyMapping("key.saintsdragons.ascend", InputConstants.Type.KEYSYM, 32, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_DESCEND = new KeyMapping("key.saintsdragons.descend", InputConstants.Type.KEYSYM, 342, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_ACCELERATE = new KeyMapping("key.saintsdragons.accelerate", InputConstants.Type.KEYSYM, 341, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_TERTIARY_ABILITY = new KeyMapping("key.saintsdragons.ability_tertiary", InputConstants.Type.KEYSYM, 71, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_PRIMARY_ABILITY = new KeyMapping("key.saintsdragons.ability_primary", InputConstants.Type.KEYSYM, 82, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_SECONDARY_ABILITY = new KeyMapping("key.saintsdragons.ability_secondary", InputConstants.Type.KEYSYM, 72, "key.categories.saintsdragons");
    public static final KeyMapping DRAGON_TOGGLE_MELEE = new KeyMapping("key.saintsdragons.toggle_melee", InputConstants.Type.KEYSYM, 88, "key.categories.saintsdragons");
    private static final KeyMapping[] ALL_KEYS = new KeyMapping[]{DRAGON_ASCEND, DRAGON_DESCEND, DRAGON_ACCELERATE, DRAGON_TERTIARY_ABILITY, DRAGON_PRIMARY_ABILITY, DRAGON_SECONDARY_ABILITY, DRAGON_TOGGLE_MELEE};
    private static boolean wasAscendPressed = false;
    private static boolean wasAccelerateDown = false;
    private static boolean wasTertiaryAbilityDown = false;
    private static boolean wasPrimaryAbilityDown = false;
    private static boolean wasSecondaryAbilityDown = false;
    private static boolean wasAttackDown = false;
    private static boolean wasToggleMeleeDown = false;
    private static int meleeCooldownTicks = 0;
    private static float lastForward = 0.0f;
    private static float lastStrafe = 0.0f;
    private static float lastYaw = 0.0f;
    private static boolean lastAscendDown = false;
    private static boolean lastDescendDown = false;

    private DragonRideInputHandler() {
    }

    public static void registerKeys(Consumer<KeyMapping> registrar) {
        for (KeyMapping mapping : ALL_KEYS) {
            registrar.accept(mapping);
        }
        KeyMapping.m_90854_();
    }

    public static void clientTick() {
        RideableDragonBase dragon;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            DragonRideInputHandler.resetStateTracking();
            return;
        }
        Entity vehicle = player.m_20202_();
        if (!(vehicle instanceof RideableDragonBase) || !(dragon = (RideableDragonBase)vehicle).canBeControlledBy((Player)player)) {
            DragonRideInputHandler.resetStateTracking();
            return;
        }
        DragonRideInputHandler.handleControls(mc, player, dragon);
    }

    private static void handleControls(Minecraft mc, LocalPlayer player, RideableDragonBase dragon) {
        boolean movementChanged;
        if (meleeCooldownTicks > 0) {
            --meleeCooldownTicks;
        }
        boolean ascendDown = DRAGON_ASCEND.m_90857_() || mc.f_91066_.f_92089_.m_90857_();
        boolean descendDown = DRAGON_DESCEND.m_90857_() || mc.f_91066_.f_92090_.m_90857_();
        boolean accelerateDown = DRAGON_ACCELERATE.m_90857_() || mc.f_91066_.f_92091_.m_90857_();
        boolean tertiaryDown = DRAGON_TERTIARY_ABILITY.m_90857_();
        boolean primaryDown = DRAGON_PRIMARY_ABILITY.m_90857_();
        boolean secondaryDown = DRAGON_SECONDARY_ABILITY.m_90857_();
        boolean toggleMeleeDown = DRAGON_TOGGLE_MELEE.m_90857_();
        boolean attackDown = mc.f_91066_.f_92096_.m_90857_();
        float forward = player.f_20902_;
        float strafe = player.f_20900_;
        float yaw = player.m_146908_();
        boolean bl = movementChanged = forward != lastForward || strafe != lastStrafe || Math.abs(yaw - lastYaw) > 0.1f || ascendDown != lastAscendDown || descendDown != lastDescendDown;
        if (movementChanged) {
            DragonRideInputHandler.sendInput(ascendDown, descendDown, DragonRiderAction.NONE, null, forward, strafe, yaw);
            lastForward = forward;
            lastStrafe = strafe;
            lastYaw = yaw;
            lastAscendDown = ascendDown;
            lastDescendDown = descendDown;
        }
        if (accelerateDown != wasAccelerateDown) {
            DragonRiderAction action = accelerateDown ? DragonRiderAction.ACCELERATE : DragonRiderAction.STOP_ACCELERATE;
            DragonRideInputHandler.sendInput(ascendDown, descendDown, action, null, forward, strafe, yaw);
        }
        if (ascendDown && !wasAscendPressed && !dragon.m_29443_()) {
            DragonRideInputHandler.sendInput(false, false, DragonRiderAction.TAKEOFF_REQUEST, null, forward, strafe, yaw);
        }
        if (toggleMeleeDown && !wasToggleMeleeDown && meleeCooldownTicks == 0) {
            if (dragon.hasSecondaryMelee()) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.TOGGLE_MELEE, null, forward, strafe, yaw);
                meleeCooldownTicks = 60;
                int newMode = (dragon.getMeleeMode() + 1) % 2;
                DragonStatusUIManager.getInstance().getDragonStatusUI().getMeleeModeNotification().showNotification(newMode);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.no_secondary_melee"), true);
            }
        }
        DragonRideInputHandler.handleAbilityBinding(dragon.getTertiaryRiderAbility(), tertiaryDown, wasTertiaryAbilityDown, forward, strafe, yaw);
        DragonRideInputHandler.handleAbilityBinding(dragon.getPrimaryRiderAbility(), primaryDown, wasPrimaryAbilityDown, forward, strafe, yaw);
        DragonRideInputHandler.handleAbilityBinding(dragon.getSecondaryRiderAbility(), secondaryDown, wasSecondaryAbilityDown, forward, strafe, yaw);
        DragonRideInputHandler.handleAbilityBinding(dragon.getAttackRiderAbility(), attackDown, wasAttackDown, forward, strafe, yaw);
        wasAscendPressed = ascendDown;
        wasAccelerateDown = accelerateDown;
        wasTertiaryAbilityDown = tertiaryDown;
        wasPrimaryAbilityDown = primaryDown;
        wasSecondaryAbilityDown = secondaryDown;
        wasAttackDown = attackDown;
        wasToggleMeleeDown = toggleMeleeDown;
    }

    private static void handleAbilityBinding(RideableDragonBase.RiderAbilityBinding binding, boolean currentDown, boolean previousDown, float forward, float strafe, float yaw) {
        if (binding == null) {
            return;
        }
        String abilityId = binding.abilityId();
        if (abilityId == null || abilityId.isEmpty()) {
            return;
        }
        RideableDragonBase.RiderAbilityBinding.Activation activation = binding.activation();
        if (activation == RideableDragonBase.RiderAbilityBinding.Activation.PRESS) {
            if (currentDown && !previousDown) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.ABILITY_USE, abilityId, forward, strafe, yaw);
            }
        } else if (activation == RideableDragonBase.RiderAbilityBinding.Activation.HOLD) {
            if (currentDown && !previousDown) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.ABILITY_USE, abilityId, forward, strafe, yaw);
            } else if (!currentDown && previousDown) {
                DragonRideInputHandler.sendInput(false, false, DragonRiderAction.ABILITY_STOP, abilityId, forward, strafe, yaw);
            }
        }
    }

    private static void sendInput(boolean goingUp, boolean goingDown, DragonRiderAction action, String abilityName, float forward, float strafe, float yaw) {
        NetworkHandler.sendToServer(new MessageDragonRideInput(goingUp, goingDown, action, abilityName, forward, strafe, yaw));
    }

    private static void resetStateTracking() {
        wasAscendPressed = false;
        wasAccelerateDown = false;
        wasTertiaryAbilityDown = false;
        wasPrimaryAbilityDown = false;
        wasSecondaryAbilityDown = false;
        wasAttackDown = false;
        wasToggleMeleeDown = false;
        meleeCooldownTicks = 0;
        lastForward = 0.0f;
        lastStrafe = 0.0f;
        lastYaw = 0.0f;
        lastAscendDown = false;
        lastDescendDown = false;
    }
}

