/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.particle.raevyx;

import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningArcData;
import com.leon.saintsdragons.common.particle.raevyx.RaevyxLightningStormData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RaevyxLightningParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private final boolean female;
    private static final Vector3f[] CORNER_CACHE = new Vector3f[4];

    protected RaevyxLightningParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, float size, SpriteSet spriteSet, boolean female) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.female = female;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107663_ = size;
        this.f_107225_ = 8;
        this.m_107250_(size * 1.5f, size * 1.5f);
        this.updateSprite();
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.updateSprite();
        }
    }

    private void updateSprite() {
        float agePercent = (float)this.f_107224_ / (float)this.f_107225_;
        int spriteIndex = Math.min((int)(agePercent * 8.0f), 7);
        this.m_108337_(this.spriteSet.m_5819_(spriteIndex, 7));
    }

    public void m_5744_(@Nonnull VertexConsumer buffer, @Nonnull Camera camera, float partialTicks) {
        Vec3 cam = camera.m_90583_();
        float cx = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - cam.m_7096_());
        float cy = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - cam.m_7098_());
        float cz = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - cam.m_7094_());
        Quaternionf camQ = new Quaternionf();
        camQ.rotateY((float)Math.toRadians(-camera.m_90590_()));
        float size = this.m_5902_(partialTicks);
        CORNER_CACHE[0].set(-1.0f, -1.0f, 0.0f);
        CORNER_CACHE[1].set(-1.0f, 1.0f, 0.0f);
        CORNER_CACHE[2].set(1.0f, 1.0f, 0.0f);
        CORNER_CACHE[3].set(1.0f, -1.0f, 0.0f);
        for (int i = 0; i < 4; ++i) {
            Vector3f v = CORNER_CACHE[i];
            v.rotate((Quaternionfc)camQ);
            v.mul(size);
            v.add(cx, cy, cz);
        }
        float u0 = this.m_5970_();
        float u1 = this.m_5952_();
        float v0 = this.m_5951_();
        float v1 = this.m_5950_();
        int light = this.m_6355_(partialTicks);
        buffer.m_5483_((double)CORNER_CACHE[0].x(), (double)CORNER_CACHE[0].y(), (double)CORNER_CACHE[0].z()).m_7421_(u1, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)CORNER_CACHE[1].x(), (double)CORNER_CACHE[1].y(), (double)CORNER_CACHE[1].z()).m_7421_(u1, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)CORNER_CACHE[2].x(), (double)CORNER_CACHE[2].y(), (double)CORNER_CACHE[2].z()).m_7421_(u0, v0).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
        buffer.m_5483_((double)CORNER_CACHE[3].x(), (double)CORNER_CACHE[3].y(), (double)CORNER_CACHE[3].z()).m_7421_(u0, v1).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    static {
        for (int i = 0; i < 4; ++i) {
            RaevyxLightningParticle.CORNER_CACHE[i] = new Vector3f();
        }
    }

    public static class FactoryArc
    implements ParticleProvider<RaevyxLightningArcData> {
        private final SpriteSet spriteSet;

        public FactoryArc(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@Nonnull RaevyxLightningArcData data, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RaevyxLightningParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.size(), this.spriteSet, data.female());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<RaevyxLightningStormData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(@Nonnull RaevyxLightningStormData data, @Nonnull ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new RaevyxLightningParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, data.size(), this.spriteSet, data.female());
        }
    }
}

