/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.renderer.layer.raevyx;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class RaevyxLightningBeamLayer
extends GeoRenderLayer<Raevyx> {
    private static final ResourceLocation INNER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/lightning_beam_inner.png");
    private static final ResourceLocation OUTER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/lightning_beam_outer.png");
    private static final ResourceLocation FEMALE_INNER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/female_lightning_beam_inner.png");
    private static final ResourceLocation FEMALE_OUTER_TEX = SaintsDragonsCommon.rl("textures/effects/raevyx/female_lightning_beam_outer.png");
    private static final float BASE_BEAM_WIDTH = 0.3f;
    private static final float OUTER_BEAM_BONUS = 0.15f;
    private static final float INNER_SPEED_MULTIPLIER = 0.25f;
    private static final float OUTER_SPEED_MULTIPLIER = 0.25f;
    private static final float BEAM_SHAKE_INTENSITY = 0.01f;
    private static final Map<Raevyx, BeamState> STATES = new WeakHashMap<Raevyx, BeamState>();
    private static final float APPEAR_TICKS = 5.0f;
    private static final float DISAPPEAR_TICKS = 6.0f;
    private static final float LOCAL_OFFSET_LEFT = 1.5f;
    private static final float LOCAL_OFFSET_UP = 1.5f;
    private static final float LOCAL_OFFSET_FWD = 4.0f;

    public RaevyxLightningBeamLayer() {
        super(null);
    }

    public void render(@NotNull PoseStack poseStack, Raevyx animatable, BakedGeoModel bakedModel, @NotNull RenderType renderType, @NotNull MultiBufferSource bufferSource, @NotNull VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
        Vec3 end;
        Vec3 mouthWorld;
        BeamState state = STATES.computeIfAbsent(animatable, k -> new BeamState());
        boolean beaming = animatable.isBeaming();
        if (beaming) {
            state.disappear = 0.0f;
            state.appear = Mth.m_14036_((float)(state.appear + 0.2f), (float)0.0f, (float)1.0f);
            mouthWorld = animatable.computeHeadMouthOrigin(partialTick);
            Vec3 predictedEnd = RaevyxLightningBeamLayer.predictBeamEnd(animatable, mouthWorld, partialTick);
            Vec3 serverEnd = animatable.getClientBeamEndPosition(partialTick);
            if (serverEnd == null) {
                end = predictedEnd;
            } else {
                double hspeed = animatable.m_20184_().m_165924_();
                float turnRate = Math.abs(Mth.m_14118_((float)animatable.f_20886_, (float)animatable.f_20885_));
                float weight = Mth.m_14036_((float)((float)(hspeed * 3.0 + (double)(turnRate / 90.0f))), (float)0.0f, (float)1.0f);
                end = RaevyxLightningBeamLayer.lerpVec(serverEnd, predictedEnd, weight);
            }
            state.lastMouth = mouthWorld;
            state.lastEnd = end;
        } else {
            if (state.lastMouth == null || state.lastEnd == null || state.appear <= 0.0f && state.disappear >= 1.0f) {
                return;
            }
            state.disappear = Mth.m_14036_((float)(state.disappear + 0.16666667f), (float)0.0f, (float)1.0f);
            state.appear = 0.0f;
            mouthWorld = state.lastMouth;
            end = state.lastEnd;
        }
        double ox = Mth.m_14139_((double)partialTick, (double)animatable.f_19854_, (double)animatable.m_20185_());
        double oy = Mth.m_14139_((double)partialTick, (double)animatable.f_19855_, (double)animatable.m_20186_());
        double oz = Mth.m_14139_((double)partialTick, (double)animatable.f_19856_, (double)animatable.m_20189_());
        float scale = 1.0f;
        Vec3 rawBeamPosition = end.m_82546_(mouthWorld);
        float length = (float)(rawBeamPosition.m_82553_() / (double)scale);
        if (length <= 0.001f) {
            return;
        }
        Vec3 vec3 = rawBeamPosition.m_82541_();
        float xRot = (float)Math.acos(vec3.f_82480_);
        float yRot = (float)Math.atan2(vec3.f_82481_, vec3.f_82479_);
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        float shakeByX = (float)Math.sin(ageInTicks * 4.0f) * 0.01f;
        float shakeByY = (float)Math.sin(ageInTicks * 4.0f + 1.2f) * 0.01f;
        float shakeByZ = (float)Math.sin(ageInTicks * 4.0f + 2.4f) * 0.01f;
        float mx = (float)((mouthWorld.f_82479_ - ox) / (double)scale);
        float my = (float)((mouthWorld.f_82480_ - oy) / (double)scale);
        float mz = (float)((mouthWorld.f_82481_ - oz) / (double)scale);
        poseStack.m_85836_();
        poseStack.m_252880_(mx + shakeByX, my + shakeByY, mz + shakeByZ);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - yRot) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_((-1.5707964f + xRot) * 57.295776f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(45.0f));
        poseStack.m_252880_(1.5f, 1.5f, 4.0f);
        float visScale = beaming ? RaevyxLightningBeamLayer.easeOutCubic(state.appear) : 1.0f - state.disappear;
        visScale = Mth.m_14036_((float)visScale, (float)0.0f, (float)1.0f);
        float scaledLength = Math.max(0.001f, length * visScale);
        float scaledWidth = Math.max(0.001f, 0.3f * (0.75f + 0.25f * visScale));
        ResourceLocation innerTex = animatable.isFemale() ? FEMALE_INNER_TEX : INNER_TEX;
        ResourceLocation outerTex = animatable.isFemale() ? FEMALE_OUTER_TEX : OUTER_TEX;
        this.renderBeam(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, true, innerTex);
        this.renderBeam(animatable, poseStack, bufferSource, partialTick, scaledWidth, scaledLength, false, outerTex);
        poseStack.m_85849_();
    }

    private void renderBeam(Raevyx entity, PoseStack poseStack, MultiBufferSource source, float partialTicks, float width, float length, boolean inner, ResourceLocation texture) {
        float speed;
        VertexConsumer vertexconsumer;
        int vertices;
        poseStack.m_85836_();
        float startAlpha = 1.0f;
        float endAlpha = 1.0f;
        if (inner) {
            vertices = 4;
            vertexconsumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            speed = 0.25f;
        } else {
            vertices = 8;
            vertexconsumer = source.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
            width += 0.15f;
            speed = 0.25f;
            endAlpha = 0.0f;
        }
        float v = ((float)entity.f_19797_ + partialTicks) * -0.25f * speed;
        float v1 = v + length * (inner ? 0.5f : 0.15f);
        float f4 = -width;
        float f5 = 0.0f;
        float f6 = 0.0f;
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        for (int j = 0; j <= vertices; ++j) {
            Matrix3f matrix3f = posestack$pose.m_252943_();
            float f7 = Mth.m_14089_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f8 = Mth.m_14031_((float)((float)Math.PI + (float)j * ((float)Math.PI * 2) / (float)vertices)) * width;
            float f9 = (float)j + 1.0f;
            vertexconsumer.m_252986_(matrix4f, f4 * 0.55f, f5 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f6, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f4, f5, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f6, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7, f8, length).m_85950_(1.0f, 1.0f, 1.0f, endAlpha).m_7421_(f9, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexconsumer.m_252986_(matrix4f, f7 * 0.55f, f8 * 0.55f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, startAlpha).m_7421_(f9, v).m_86008_(OverlayTexture.f_118083_).m_85969_(240).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }

    private static float easeOutCubic(float t) {
        float p = 1.0f - t;
        return 1.0f - p * p * p;
    }

    private static Vec3 lerpVec(Vec3 a, Vec3 b, float t) {
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        return a.m_82549_(b.m_82546_(a).m_82490_((double)t));
    }

    private static Vec3 predictBeamEnd(Raevyx dragon, Vec3 mouthWorld, float partialTicks) {
        Vec3 aimDir = dragon.getBeamAimDirection();
        if (aimDir == null || aimDir.m_82556_() < 1.0E-6) {
            dragon.refreshBeamAimDirection(mouthWorld, true);
            aimDir = dragon.getBeamAimDirection();
        }
        if (aimDir == null || aimDir.m_82556_() < 1.0E-6) {
            LivingEntity cp = dragon.m_6688_();
            if (cp instanceof LivingEntity) {
                LivingEntity rider = cp;
                aimDir = rider.m_20252_(partialTicks).m_82541_();
            } else {
                LivingEntity tgt = dragon.m_5448_();
                if (tgt != null && tgt.m_6084_()) {
                    Vec3 aimPoint = tgt.m_20299_(partialTicks).m_82520_(0.0, -0.25, 0.0);
                    aimDir = aimPoint.m_82546_(mouthWorld).m_82541_();
                } else {
                    float yaw = Mth.m_14179_((float)partialTicks, (float)dragon.f_20886_, (float)dragon.f_20885_);
                    float pitch = Mth.m_14179_((float)partialTicks, (float)dragon.f_19860_, (float)dragon.m_146909_());
                    aimDir = Vec3.m_82498_((float)pitch, (float)yaw).m_82541_();
                }
            }
        }
        double MAX_DISTANCE = 32.0;
        Vec3 tentativeEnd = mouthWorld.m_82549_(aimDir.m_82490_(32.0));
        BlockHitResult hit = dragon.m_9236_().m_45547_(new ClipContext(mouthWorld, tentativeEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dragon));
        return hit.m_6662_() != HitResult.Type.MISS ? hit.m_82450_() : tentativeEnd;
    }

    private static final class BeamState {
        float appear;
        float disappear;
        Vec3 lastMouth;
        Vec3 lastEnd;

        private BeamState() {
        }
    }
}

