/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.client.ui;

import com.leon.saintsdragons.client.ui.DragonUIElement;
import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class DragonHealthBar
extends DragonUIElement {
    private static final ResourceLocation LIGHTNING_HEALTH_BORDER = SaintsDragonsCommon.rl("textures/entity/lightningdragon/health_border.png");
    private static final ResourceLocation LIGHTNING_HEALTH_FILL = SaintsDragonsCommon.rl("textures/entity/lightningdragon/health_fill.png");
    private DragonEntity dragon;
    private float currentHealthPercent = 1.0f;
    private float targetHealthPercent = 1.0f;
    private long lastHealthUpdate = 0L;
    private String cachedHealthText = "";
    private int cachedTextWidth = 0;
    private float cachedHealth = -1.0f;
    private float cachedMaxHealth = -1.0f;
    private boolean cachedGender = false;

    public DragonHealthBar(int x, int y) {
        super(x, y, 18, 100);
    }

    public void setDragon(DragonEntity dragon) {
        this.dragon = dragon;
        this.updateHealth();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible || this.dragon == null || this.dragon.m_21224_()) {
            return;
        }
        this.updateHealth();
        guiGraphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, -2130771968);
        int fillHeight = (int)((float)this.height * this.currentHealthPercent);
        if (fillHeight > 0) {
            int fillY = this.y + this.height - fillHeight;
            guiGraphics.m_280509_(this.x + 2, fillY + 2, this.x + this.width - 2, this.y + this.height - 2, -8388608);
        }
        float currentHealth = this.dragon.m_21223_();
        float maxHealth = this.dragon.m_21233_();
        boolean isFemale = this.dragon.isFemale();
        if (currentHealth != this.cachedHealth || maxHealth != this.cachedMaxHealth || isFemale != this.cachedGender) {
            String genderSymbol = isFemale ? "\u2640" : "\u2642";
            this.cachedHealthText = String.format("%s %.0f/%.0f", genderSymbol, Float.valueOf(currentHealth), Float.valueOf(maxHealth));
            this.cachedTextWidth = this.minecraft.f_91062_.m_92895_(this.cachedHealthText);
            this.cachedHealth = currentHealth;
            this.cachedMaxHealth = maxHealth;
            this.cachedGender = isFemale;
        }
        int textX = Math.max(4, this.x - this.cachedTextWidth - 8);
        Objects.requireNonNull(this.minecraft.f_91062_);
        int textY = this.y + (this.height - 9) / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        guiGraphics.m_280509_(textX - 2, textY - 2, textX + this.cachedTextWidth + 2, textY + 9 + 2, Integer.MIN_VALUE);
        guiGraphics.m_280488_(this.minecraft.f_91062_, this.cachedHealthText, textX, textY, 0xFFFFFF);
        if (this.isMouseOver(mouseX, mouseY)) {
            this.renderDragHandle(guiGraphics);
        }
    }

    private void updateHealth() {
        long timeSinceUpdate;
        if (this.dragon == null) {
            return;
        }
        float newHealthPercent = this.dragon.m_21223_() / this.dragon.m_21233_();
        if (newHealthPercent != this.targetHealthPercent) {
            this.targetHealthPercent = newHealthPercent;
            this.lastHealthUpdate = System.currentTimeMillis();
        }
        if ((timeSinceUpdate = System.currentTimeMillis() - this.lastHealthUpdate) < 500L) {
            float animationProgress = (float)timeSinceUpdate / 500.0f;
            this.currentHealthPercent += (this.targetHealthPercent - this.currentHealthPercent) * animationProgress;
        } else {
            this.currentHealthPercent = this.targetHealthPercent;
        }
    }

    private void renderDragHandle(GuiGraphics guiGraphics) {
        int handleSize = 4;
        int handleX = this.x + this.width - handleSize - 2;
        int handleY = this.y + 2;
        guiGraphics.m_280509_(handleX, handleY, handleX + handleSize, handleY + handleSize, -1);
        guiGraphics.m_280509_(handleX + 1, handleY + 1, handleX + handleSize - 1, handleY + handleSize - 1, -16777216);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int handleSize = 4;
        int handleX = this.x + this.width - handleSize - 2;
        int handleY = this.y + 2;
        if (button == 0 && mouseX >= (double)handleX && mouseX <= (double)(handleX + handleSize) && mouseY >= (double)handleY && mouseY <= (double)(handleY + handleSize)) {
            this.startDragging(mouseX, mouseY);
            return true;
        }
        return false;
    }
}

