/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.init;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.common.registry.ModItems;
import com.leon.saintsdragons.server.command.DragonAllyCommand;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import com.leon.saintsdragons.server.entity.dragons.stegonaut.Stegonaut;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;

public final class CommonModEvents {
    private CommonModEvents() {
    }

    public static void registerEntityAttributes(BiConsumer<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> registrar) {
        registrar.accept(ModEntities.RAEVYX.get(), Raevyx.createAttributes());
        registrar.accept(ModEntities.STEGONAUT.get(), Stegonaut.createAttributes());
        registrar.accept(ModEntities.CINDERVANE.get(), Cindervane.createAttributes());
        registrar.accept(ModEntities.NULLJAW.get(), Nulljaw.createAttributes());
    }

    public static void registerCreativeTabEntries(CreativeTabRegistrar registrar) {
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, ModItems.RAEVYX_SPAWN_EGG);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, ModItems.STEGONAUT_SPAWN_EGG);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, ModItems.CINDERVANE_SPAWN_EGG);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256731_, ModItems.NULLJAW_SPAWN_EGG);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, ModItems.DRAGON_ALLY_BOOK);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, ModItems.STEGONAUT_BINDER);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, ModItems.RAEVYX_BINDER);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, ModItems.CINDERVANE_BINDER);
        registrar.accept((ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256869_, ModItems.NULLJAW_BINDER);
    }

    public static void registerSpawnPlacements(SpawnPlacementRegistrar registrar) {
        registrar.register(ModEntities.RAEVYX.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Raevyx::canSpawnHere);
        registrar.register(ModEntities.STEGONAUT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Stegonaut::canSpawnHere);
        registrar.register(ModEntities.CINDERVANE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Cindervane::canSpawnHere);
        registrar.register(ModEntities.NULLJAW.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Nulljaw::canSpawnHere);
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        DragonAllyCommand.register(dispatcher);
    }

    @FunctionalInterface
    public static interface CreativeTabRegistrar {
        public void accept(ResourceKey<CreativeModeTab> var1, Supplier<? extends Item> var2);
    }

    @FunctionalInterface
    public static interface SpawnPlacementRegistrar {
        public <T extends Mob> void register(EntityType<T> var1, SpawnPlacements.Type var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }
}

