/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.item;

import com.leon.saintsdragons.common.registry.ModEntities;
import com.leon.saintsdragons.server.entity.dragons.cindervane.Cindervane;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CindervaneBinderItem
extends Item {
    private static final String BOUND_DRAGON_UUID = "BoundDragonUUID";
    private static final String BOUND_DRAGON_NAME = "BoundDragonName";
    private static final String BOUND_OWNER_UUID = "BoundOwnerUUID";
    private static final String BOUND_OWNER_NAME = "BoundOwnerName";
    private static final String IS_BOUND = "IsBound";

    public CindervaneBinderItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (target instanceof Cindervane) {
            Cindervane amphithere = (Cindervane)target;
            if (!amphithere.m_21824_() || !amphithere.m_21830_((LivingEntity)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.not_dragon_owner"), true);
                return InteractionResult.FAIL;
            }
            if (!amphithere.canBeBound()) {
                player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.dragon_cannot_be_captured"), true);
                return InteractionResult.FAIL;
            }
            if (CindervaneBinderItem.isBound(stack)) {
                player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.binder_already_occupied"), true);
                return InteractionResult.FAIL;
            }
            ItemStack newStack = this.captureAmphithere(stack, amphithere, player);
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_150109_().m_6836_(player.m_150109_().f_35977_, newStack);
            } else {
                player.m_150109_().m_6836_(40, newStack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (CindervaneBinderItem.isBound(stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && CindervaneBinderItem.isBound(stack)) {
            return this.releaseAmphithere(stack, player, context.m_8083_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    private ItemStack captureAmphithere(ItemStack stack, Cindervane amphithere, Player player) {
        ItemStack newStack = stack.m_41777_();
        CompoundTag tag = newStack.m_41784_();
        tag.m_128362_(BOUND_DRAGON_UUID, amphithere.m_20148_());
        tag.m_128359_(BOUND_DRAGON_NAME, amphithere.m_7755_().getString());
        if (amphithere.m_8077_()) {
            Component customName = amphithere.m_7770_();
            if (customName != null) {
                tag.m_128359_("BoundCustomName", Component.Serializer.m_130703_((Component)customName));
            } else {
                tag.m_128473_("BoundCustomName");
            }
        } else {
            tag.m_128473_("BoundCustomName");
        }
        tag.m_128379_(IS_BOUND, true);
        LivingEntity owner = amphithere.m_269323_();
        if (owner instanceof Player) {
            Player ownerPlayer = (Player)owner;
            tag.m_128362_(BOUND_OWNER_UUID, ownerPlayer.m_20148_());
            tag.m_128359_(BOUND_OWNER_NAME, ownerPlayer.m_7755_().getString());
        } else {
            tag.m_128473_(BOUND_OWNER_UUID);
            tag.m_128473_(BOUND_OWNER_NAME);
        }
        CompoundTag amphithereData = new CompoundTag();
        amphithere.m_7380_(amphithereData);
        tag.m_128365_("AmphithereData", (Tag)amphithereData);
        newStack.m_41751_(tag);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (int i = 0; i < serverPlayer.m_150109_().m_6643_(); ++i) {
                if (serverPlayer.m_150109_().m_8020_(i) != stack) continue;
                serverPlayer.m_150109_().m_6836_(i, newStack);
                break;
            }
        }
        amphithere.m_142687_(Entity.RemovalReason.DISCARDED);
        player.m_5661_((Component)Component.m_237110_((String)"saintsdragons.message.amphithere_captured", (Object[])new Object[]{amphithere.m_7755_().getString()}), true);
        return newStack;
    }

    private boolean releaseAmphithere(ItemStack stack, Player player, BlockPos pos) {
        MutableComponent customName;
        UUID ownerUUID;
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_(BOUND_DRAGON_UUID)) {
            return false;
        }
        UUID uUID = ownerUUID = tag.m_128441_(BOUND_OWNER_UUID) ? tag.m_128342_(BOUND_OWNER_UUID) : null;
        if (ownerUUID != null && !player.m_20148_().equals(ownerUUID)) {
            player.m_5661_((Component)Component.m_237115_((String)"saintsdragons.message.cannot_release_others_dragon"), true);
            return false;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        String amphithereName = tag.m_128461_(BOUND_DRAGON_NAME);
        Cindervane newAmphithere = new Cindervane((EntityType<? extends Cindervane>)ModEntities.CINDERVANE.get(), (Level)serverLevel);
        if (tag.m_128441_("AmphithereData")) {
            CompoundTag amphithereData = tag.m_128469_("AmphithereData");
            newAmphithere.m_7378_(amphithereData);
        }
        newAmphithere.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_() + 1, (double)pos.m_123343_() + 0.5);
        if (ownerUUID != null) {
            Player owner = serverLevel.m_46003_(ownerUUID);
            if (owner != null) {
                newAmphithere.m_21828_(owner);
            }
        } else {
            newAmphithere.m_21828_(player);
        }
        if (tag.m_128441_("BoundCustomName") && (customName = Component.Serializer.m_130701_((String)tag.m_128461_("BoundCustomName"))) != null) {
            newAmphithere.m_6593_((Component)customName);
        }
        serverLevel.m_7967_((Entity)newAmphithere);
        tag.m_128473_(BOUND_DRAGON_UUID);
        tag.m_128473_(BOUND_DRAGON_NAME);
        tag.m_128473_(BOUND_OWNER_UUID);
        tag.m_128473_(BOUND_OWNER_NAME);
        tag.m_128473_("BoundCustomName");
        tag.m_128473_("AmphithereData");
        tag.m_128379_(IS_BOUND, false);
        player.m_5661_((Component)Component.m_237110_((String)"saintsdragons.message.cindervane_released", (Object[])new Object[]{amphithereName}), true);
        return true;
    }

    public static boolean isBound(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128471_(IS_BOUND);
    }

    @Nullable
    public static UUID getBoundAmphithereUUID(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(BOUND_DRAGON_UUID)) {
            return tag.m_128342_(BOUND_DRAGON_UUID);
        }
        return null;
    }

    @Nullable
    public static String getBoundAmphithereName(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(BOUND_DRAGON_NAME)) {
            return tag.m_128461_(BOUND_DRAGON_NAME);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.cindervane_binder.description"));
        if (CindervaneBinderItem.isBound(stack)) {
            String amphithereName = CindervaneBinderItem.getBoundAmphithereName(stack);
            if (amphithereName != null) {
                tooltip.add((Component)Component.m_237110_((String)"saintsdragons.tooltip.cindervane_binder.bound", (Object[])new Object[]{amphithereName}));
            }
            tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.cindervane_binder.right_click_to_release"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.cindervane_binder.empty"));
            tooltip.add((Component)Component.m_237115_((String)"saintsdragons.tooltip.cindervane_binder.right_click_cindervane_to_bind"));
        }
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return CindervaneBinderItem.isBound(stack);
    }
}

