/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.network;

import com.leon.saintsdragons.common.network.MessageDragonAllyList;
import com.leon.saintsdragons.common.network.NetworkHandler;
import com.leon.saintsdragons.server.entity.base.DragonEntity;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MessageDragonAllyRequest {
    private final int dragonId;

    public MessageDragonAllyRequest(int dragonId) {
        this.dragonId = dragonId;
    }

    private MessageDragonAllyRequest(FriendlyByteBuf buffer) {
        this.dragonId = buffer.readInt();
    }

    public static void encode(MessageDragonAllyRequest message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.dragonId);
    }

    public static MessageDragonAllyRequest decode(FriendlyByteBuf buffer) {
        return new MessageDragonAllyRequest(buffer);
    }

    public static void handle(MessageDragonAllyRequest message, ServerPlayer player) {
        if (player == null) {
            return;
        }
        Entity entity = player.m_9236_().m_6815_(message.dragonId);
        if (!(entity instanceof DragonEntity)) {
            return;
        }
        DragonEntity dragon = (DragonEntity)entity;
        if (!dragon.m_21824_() || !dragon.m_21830_((LivingEntity)player)) {
            return;
        }
        NetworkHandler.sendToPlayer(player, new MessageDragonAllyList(dragon.m_19879_(), dragon.allyManager.getAllyUsernames()));
    }
}

