/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.particle.raevyx;

import com.leon.saintsdragons.common.registry.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public record RaevyxLightningArcData(float size, boolean female) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<RaevyxLightningArcData> DESERIALIZER = new ParticleOptions.Deserializer<RaevyxLightningArcData>(){

        @NotNull
        public RaevyxLightningArcData fromCommand(@Nonnull ParticleType<RaevyxLightningArcData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            boolean female = false;
            if (reader.canRead() && reader.peek() == ' ') {
                reader.expect(' ');
                female = reader.readBoolean();
            }
            return new RaevyxLightningArcData(size, female);
        }

        @NotNull
        public RaevyxLightningArcData fromNetwork(@Nonnull ParticleType<RaevyxLightningArcData> type, @Nonnull FriendlyByteBuf buf) {
            return new RaevyxLightningArcData(buf.readFloat(), buf.readBoolean());
        }
    };

    public static Codec<RaevyxLightningArcData> CODEC(ParticleType<RaevyxLightningArcData> type) {
        return RecordCodecBuilder.create(b -> b.group((App)Codec.FLOAT.fieldOf("size").forGetter(RaevyxLightningArcData::size), (App)Codec.BOOL.optionalFieldOf("female", (Object)false).forGetter(RaevyxLightningArcData::female)).apply((Applicative)b, RaevyxLightningArcData::new));
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buf) {
        buf.writeFloat(this.size);
        buf.writeBoolean(this.female);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %s", BuiltInRegistries.f_257034_.m_7981_(ModParticles.LIGHTNING_ARC.get()), Float.valueOf(this.size), Boolean.toString(this.female));
    }

    @NotNull
    public ParticleType<RaevyxLightningArcData> m_6012_() {
        return ModParticles.LIGHTNING_ARC.get();
    }
}

