/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.particle.raevyx;

import com.leon.saintsdragons.common.registry.ModParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public record RaevyxLightningChainData(float size, Vec3 startPos, Vec3 endPos, boolean female) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<RaevyxLightningChainData> DESERIALIZER = new ParticleOptions.Deserializer<RaevyxLightningChainData>(){

        @NotNull
        public RaevyxLightningChainData fromCommand(@Nonnull ParticleType<RaevyxLightningChainData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = reader.readFloat();
            reader.expect(' ');
            double startX = reader.readDouble();
            reader.expect(' ');
            double startY = reader.readDouble();
            reader.expect(' ');
            double startZ = reader.readDouble();
            reader.expect(' ');
            double endX = reader.readDouble();
            reader.expect(' ');
            double endY = reader.readDouble();
            reader.expect(' ');
            double endZ = reader.readDouble();
            boolean female = false;
            if (reader.canRead() && reader.peek() == ' ') {
                reader.expect(' ');
                female = reader.readBoolean();
            }
            return new RaevyxLightningChainData(size, new Vec3(startX, startY, startZ), new Vec3(endX, endY, endZ), female);
        }

        @NotNull
        public RaevyxLightningChainData fromNetwork(@Nonnull ParticleType<RaevyxLightningChainData> type, @Nonnull FriendlyByteBuf buf) {
            float size = buf.readFloat();
            double startX = buf.readDouble();
            double startY = buf.readDouble();
            double startZ = buf.readDouble();
            double endX = buf.readDouble();
            double endY = buf.readDouble();
            double endZ = buf.readDouble();
            boolean female = buf.readBoolean();
            return new RaevyxLightningChainData(size, new Vec3(startX, startY, startZ), new Vec3(endX, endY, endZ), female);
        }
    };

    public static Codec<RaevyxLightningChainData> CODEC(ParticleType<RaevyxLightningChainData> type) {
        return RecordCodecBuilder.create(b -> b.group((App)Codec.FLOAT.fieldOf("size").forGetter(RaevyxLightningChainData::size), (App)Vec3.f_231074_.fieldOf("startPos").forGetter(RaevyxLightningChainData::startPos), (App)Vec3.f_231074_.fieldOf("endPos").forGetter(RaevyxLightningChainData::endPos), (App)Codec.BOOL.optionalFieldOf("female", (Object)false).forGetter(RaevyxLightningChainData::female)).apply((Applicative)b, RaevyxLightningChainData::new));
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buf) {
        buf.writeFloat(this.size);
        buf.writeDouble(this.startPos.f_82479_);
        buf.writeDouble(this.startPos.f_82480_);
        buf.writeDouble(this.startPos.f_82481_);
        buf.writeDouble(this.endPos.f_82479_);
        buf.writeDouble(this.endPos.f_82480_);
        buf.writeDouble(this.endPos.f_82481_);
        buf.writeBoolean(this.female);
    }

    @NotNull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %.2f %s", BuiltInRegistries.f_257034_.m_7981_(ModParticles.LIGHTNING_CHAIN.get()), Float.valueOf(this.size), this.startPos.f_82479_, this.startPos.f_82480_, this.startPos.f_82481_, this.endPos.f_82479_, this.endPos.f_82480_, this.endPos.f_82481_, Boolean.toString(this.female));
    }

    @NotNull
    public ParticleType<RaevyxLightningChainData> m_6012_() {
        return ModParticles.LIGHTNING_CHAIN.get();
    }
}

