/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.common.registry;

import com.leon.saintsdragons.common.registry.Element;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;

public class ElementalProfile {
    private final Element element;
    private final Set<TagKey<DamageType>> immunities;
    private final Map<TagKey<DamageType>, Float> resistances;
    private final Map<TagKey<DamageType>, Float> weaknesses;

    private ElementalProfile(Builder builder) {
        this.element = builder.element;
        this.immunities = Set.copyOf(builder.immunities);
        this.resistances = Map.copyOf(builder.resistances);
        this.weaknesses = Map.copyOf(builder.weaknesses);
    }

    public Element getElement() {
        return this.element;
    }

    public boolean isImmuneTo(DamageSource source) {
        return this.immunities.stream().anyMatch(arg_0 -> ((DamageSource)source).m_269533_(arg_0));
    }

    public float getDamageMultiplier(DamageSource source) {
        if (this.isImmuneTo(source)) {
            return 0.0f;
        }
        for (Map.Entry<TagKey<DamageType>, Float> entry : this.resistances.entrySet()) {
            if (!source.m_269533_(entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        for (Map.Entry<TagKey<DamageType>, Float> entry : this.weaknesses.entrySet()) {
            if (!source.m_269533_(entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 1.0f;
    }

    public static Builder builder(Element element) {
        return new Builder(element);
    }

    public static class Builder {
        private final Element element;
        private final Set<TagKey<DamageType>> immunities = new HashSet<TagKey<DamageType>>();
        private final Map<TagKey<DamageType>, Float> resistances = new HashMap<TagKey<DamageType>, Float>();
        private final Map<TagKey<DamageType>, Float> weaknesses = new HashMap<TagKey<DamageType>, Float>();

        private Builder(Element element) {
            this.element = element;
        }

        public Builder immuneTo(TagKey<DamageType> damageType) {
            this.immunities.add(damageType);
            return this;
        }

        public Builder resistantTo(TagKey<DamageType> damageType, float multiplier) {
            if (multiplier < 0.0f || multiplier >= 1.0f) {
                throw new IllegalArgumentException("Resistance multiplier must be between 0.0 and 1.0 (exclusive)");
            }
            this.resistances.put(damageType, Float.valueOf(multiplier));
            return this;
        }

        public Builder weakTo(TagKey<DamageType> damageType, float multiplier) {
            if (multiplier <= 1.0f) {
                throw new IllegalArgumentException("Weakness multiplier must be greater than 1.0");
            }
            this.weaknesses.put(damageType, Float.valueOf(multiplier));
            return this;
        }

        public ElementalProfile build() {
            return new ElementalProfile(this);
        }
    }
}

