/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.forge.platform;

import com.leon.saintsdragons.platform.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class ForgeConfigHelper
implements ConfigHelper {
    @Override
    public ConfigHelper.ConfigBuilder commonBuilder(String fileName) {
        return new ForgeBuilder(fileName);
    }

    private static final class ForgeBuilder
    implements ConfigHelper.ConfigBuilder {
        private final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        private final String fileName;

        private ForgeBuilder(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public void push(String category) {
            this.builder.push(category);
        }

        @Override
        public void pop() {
            this.builder.pop();
        }

        @Override
        public ConfigHelper.IntValue defineInt(String key, int defaultValue, int min, int max) {
            ForgeConfigSpec.IntValue value = this.builder.defineInRange(key, defaultValue, min, max);
            return () -> ((ForgeConfigSpec.IntValue)value).get();
        }

        @Override
        public void build() {
            ForgeConfigSpec spec = this.builder.build();
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, this.fileName);
        }
    }
}

