/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.forge.world;

import com.leon.saintsdragons.common.SaintsDragonsCommon;
import com.leon.saintsdragons.common.config.SaintsDragonsConfig;
import com.leon.saintsdragons.common.registry.ModEntities;
import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public final class AddDragonsBiomeModifier
implements BiomeModifier {
    public static final Codec<AddDragonsBiomeModifier> CODEC = Codec.unit(AddDragonsBiomeModifier::new);
    private static final TagKey<Biome> HAS_RAEVYX = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)SaintsDragonsCommon.rl("has_raevyx"));
    private static final TagKey<Biome> HAS_STEGONAUT = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)SaintsDragonsCommon.rl("has_stegonaut"));
    private static final TagKey<Biome> HAS_CINDERVANE = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)SaintsDragonsCommon.rl("has_cindervane"));
    private static final TagKey<Biome> HAS_NULLJAW = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)SaintsDragonsCommon.rl("has_nulljaw"));

    private AddDragonsBiomeModifier() {
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase != BiomeModifier.Phase.MODIFY) {
            return;
        }
        try {
            if (biome.m_203656_(HAS_RAEVYX)) {
                AddDragonsBiomeModifier.addSpawn(builder, MobCategory.CREATURE, ModEntities.RAEVYX.get(), SaintsDragonsConfig.RAEVYX_SPAWN_WEIGHT.get(), SaintsDragonsConfig.RAEVYX_MIN_GROUP_SIZE.get(), SaintsDragonsConfig.RAEVYX_MAX_GROUP_SIZE.get());
            }
            if (biome.m_203656_(HAS_STEGONAUT)) {
                AddDragonsBiomeModifier.addSpawn(builder, MobCategory.CREATURE, ModEntities.STEGONAUT.get(), SaintsDragonsConfig.STEGONAUT_SPAWN_WEIGHT.get(), SaintsDragonsConfig.STEGONAUT_MIN_GROUP_SIZE.get(), SaintsDragonsConfig.STEGONAUT_MAX_GROUP_SIZE.get());
            }
            if (biome.m_203656_(HAS_CINDERVANE)) {
                AddDragonsBiomeModifier.addSpawn(builder, MobCategory.CREATURE, ModEntities.CINDERVANE.get(), SaintsDragonsConfig.CINDERVANE_SPAWN_WEIGHT.get(), SaintsDragonsConfig.CINDERVANE_MIN_GROUP_SIZE.get(), SaintsDragonsConfig.CINDERVANE_MAX_GROUP_SIZE.get());
            }
            if (biome.m_203656_(HAS_NULLJAW)) {
                AddDragonsBiomeModifier.addSpawn(builder, MobCategory.CREATURE, ModEntities.NULLJAW.get(), SaintsDragonsConfig.NULLJAW_SPAWN_WEIGHT.get(), SaintsDragonsConfig.NULLJAW_MIN_GROUP_SIZE.get(), SaintsDragonsConfig.NULLJAW_MAX_GROUP_SIZE.get());
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static void addSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, MobCategory category, EntityType<? extends Mob> entityType, int weight, int minGroupSize, int maxGroupSize) {
        if (weight <= 0 || minGroupSize <= 0 || maxGroupSize <= 0) {
            return;
        }
        if (minGroupSize > maxGroupSize) {
            minGroupSize = maxGroupSize;
        }
        MobSpawnSettings.SpawnerData spawnerData = new MobSpawnSettings.SpawnerData(entityType, weight, minGroupSize, maxGroupSize);
        MobSpawnSettingsBuilder spawnSettings = builder.getMobSpawnSettings();
        boolean alreadyPresent = spawnSettings.getSpawner(category).stream().anyMatch(existing -> existing.f_48404_ == entityType);
        if (!alreadyPresent) {
            spawnSettings.m_48376_(category, spawnerData);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

