/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class NulljawLeaveWaterGoal
extends Goal {
    private final Nulljaw drake;
    private Vec3 targetPos;
    private final int executionChance = 30;

    public NulljawLeaveWaterGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.drake.m_9236_().m_6425_(this.drake.m_20183_()).m_205070_(FluidTags.f_13131_) && (this.drake.m_5448_() != null || this.drake.m_217043_().m_188503_(30) == 0) && this.drake.shouldLeaveWater()) {
            this.targetPos = this.generateTarget();
            return this.targetPos != null;
        }
        return false;
    }

    public void m_8056_() {
        if (this.targetPos != null) {
            this.drake.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, 1.0);
        }
    }

    public void m_8037_() {
        if (this.targetPos != null) {
            this.drake.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, 1.0);
        }
        if (this.drake.f_19862_ && this.drake.m_20069_()) {
            float yawRad = this.drake.m_146908_() * ((float)Math.PI / 180);
            Vec3 current = this.drake.m_20184_();
            double pushX = (double)(-Mth.m_14031_((float)yawRad)) * 0.3;
            double pushZ = (double)Mth.m_14089_((float)yawRad) * 0.3;
            double upward = Mth.m_14008_((double)(current.f_82480_ + 0.08), (double)0.24, (double)0.45);
            this.drake.m_20334_(current.f_82479_ + pushX, upward, current.f_82481_ + pushZ);
        }
    }

    public boolean m_8045_() {
        if (!this.drake.shouldLeaveWater()) {
            this.drake.m_21573_().m_26573_();
            return false;
        }
        return !this.drake.m_21573_().m_26571_() && this.targetPos != null && !this.drake.m_9236_().m_6425_(BlockPos.m_274446_((Position)this.targetPos)).m_205070_(FluidTags.f_13131_);
    }

    private Vec3 generateTarget() {
        Vec3 vector3d = LandRandomPos.m_148488_((PathfinderMob)this.drake, (int)23, (int)7);
        for (int tries = 0; vector3d != null && tries < 8; ++tries) {
            boolean waterDetected = false;
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)BlockPos.m_274446_((Position)vector3d).m_7918_(-2, -1, -2), (BlockPos)BlockPos.m_274446_((Position)vector3d).m_7918_(2, 0, 2))) {
                if (!this.drake.m_9236_().m_6425_(blockpos1).m_205070_(FluidTags.f_13131_)) continue;
                waterDetected = true;
                break;
            }
            if (!waterDetected) {
                return vector3d;
            }
            vector3d = LandRandomPos.m_148488_((PathfinderMob)this.drake, (int)23, (int)7);
        }
        return null;
    }
}

