/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.nulljaw;

import com.leon.saintsdragons.server.entity.dragons.nulljaw.Nulljaw;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class NulljawSleepGoal
extends Goal {
    private final Nulljaw drake;
    private int retryCooldown;

    public NulljawSleepGoal(Nulljaw drake) {
        this.drake = drake;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.retryCooldown > 0) {
            --this.retryCooldown;
        }
        if (this.retryCooldown > 0) {
            return false;
        }
        if (this.drake.isSleepLocked()) {
            return false;
        }
        if (!this.drake.canSleepNow() || this.drake.isSleepSuppressed()) {
            return false;
        }
        if (this.drake.m_20072_() || this.drake.m_20077_()) {
            return false;
        }
        if (this.drake.isDying() || this.drake.m_20160_()) {
            return false;
        }
        if (this.drake.m_5448_() != null || this.drake.m_5912_()) {
            return false;
        }
        if (this.drake.m_9236_().m_46470_()) {
            return false;
        }
        return this.drake.m_21824_() && this.ownerAsleep();
    }

    public boolean m_8045_() {
        return this.drake.isSleepLocked();
    }

    public void m_8056_() {
        this.drake.startSleepEnter();
    }

    public void m_8037_() {
        if (this.drake.m_9236_().f_46443_) {
            return;
        }
        if (this.drake.isSleepLocked() && !this.shouldRemainAsleep() && !this.drake.isSleepTransitioning()) {
            this.drake.startSleepExit();
        }
    }

    public void m_8041_() {
        if (!this.drake.isSleepLocked()) {
            this.retryCooldown = 100;
        }
    }

    public boolean m_6767_() {
        return false;
    }

    private boolean ownerAsleep() {
        LivingEntity owner = this.drake.m_269323_();
        if (!(owner instanceof Player)) {
            return false;
        }
        Player player = (Player)owner;
        if (!player.m_5803_() || !player.m_6084_()) {
            return false;
        }
        return player.m_9236_() == this.drake.m_9236_();
    }

    private boolean shouldRemainAsleep() {
        return this.ownerAsleep();
    }
}

