/*
 * Decompiled with CFR 0.152.
 */
package com.leon.saintsdragons.server.ai.goals.raevyx;

import com.leon.saintsdragons.server.entity.dragons.raevyx.Raevyx;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class RaevyxBreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_();
    private final Raevyx dragon;
    private final Level level;
    private final double speedModifier;
    @Nullable
    private Raevyx partner;
    private int loveTime;

    public RaevyxBreedGoal(Raevyx dragon, double speedModifier) {
        this.dragon = dragon;
        this.level = dragon.m_9236_();
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.dragon.m_27593_()) {
            return false;
        }
        if (this.dragon.m_29443_()) {
            return false;
        }
        if (this.dragon.m_21827_()) {
            return false;
        }
        this.partner = this.findMate();
        return this.partner != null;
    }

    public boolean m_8045_() {
        return this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 60 && !this.dragon.m_29443_() && !this.dragon.m_21827_();
    }

    public void m_8041_() {
        this.partner = null;
        this.loveTime = 0;
    }

    public void m_8037_() {
        this.dragon.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.dragon.m_8132_());
        if (!this.dragon.m_29443_()) {
            this.dragon.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
        }
        ++this.loveTime;
        if (this.loveTime >= 60 && this.dragon.m_20280_((Entity)this.partner) < 600.0) {
            this.breed();
        }
    }

    @Nullable
    private Raevyx findMate() {
        List list = this.level.m_45971_(Raevyx.class, PARTNER_TARGETING, (LivingEntity)this.dragon, this.dragon.m_20191_().m_82400_(8.0));
        double closestDist = Double.MAX_VALUE;
        Raevyx closestMate = null;
        for (Raevyx candidate : list) {
            double dist;
            if (!this.dragon.m_7848_((Animal)candidate) || !((dist = this.dragon.m_20280_((Entity)candidate)) < closestDist)) continue;
            closestMate = candidate;
            closestDist = dist;
        }
        return closestMate;
    }

    private void breed() {
        ServerPlayer serverplayer;
        ServerLevel serverlevel = (ServerLevel)this.level;
        Raevyx baby = (Raevyx)this.dragon.m_142606_(serverlevel, (AgeableMob)this.partner);
        if (baby == null) {
            return;
        }
        this.dragon.m_27594_();
        this.partner.m_27594_();
        baby.m_6863_(true);
        baby.m_7678_((this.dragon.m_20185_() + this.partner.m_20185_()) / 2.0, this.dragon.m_20186_(), (this.dragon.m_20189_() + this.partner.m_20189_()) / 2.0, 0.0f, 0.0f);
        serverlevel.m_7967_((Entity)baby);
        this.level.m_7605_((Entity)this.dragon, (byte)18);
        if (this.level.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.level.m_7967_((Entity)new ExperienceOrb(this.level, this.dragon.m_20185_(), this.dragon.m_20186_(), this.dragon.m_20189_(), this.dragon.m_217043_().m_188503_(7) + 1));
        }
        if ((serverplayer = this.dragon.m_27592_()) == null && this.partner.m_27592_() != null) {
            serverplayer = this.partner.m_27592_();
        }
        if (serverplayer != null) {
            serverplayer.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this.dragon, (Animal)this.partner, (AgeableMob)baby);
        }
    }
}

